/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;

public class SetMobSpawnerPacket
extends Packet {
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public String spawnType;

    public SetMobSpawnerPacket() {
        this.isChunkDataPacket = true;
    }

    public SetMobSpawnerPacket(int x, int y, int z, String spawnType) {
        this.isChunkDataPacket = true;
        this.xPosition = x;
        this.yPosition = y;
        this.zPosition = z;
        if (spawnType == null) {
            spawnType = "none";
        }
        this.spawnType = spawnType;
    }

    @Override
    public void read(DataInputStream dis) throws IOException {
        this.xPosition = dis.readInt();
        this.yPosition = dis.readShort();
        this.zPosition = dis.readInt();
        this.spawnType = SetMobSpawnerPacket.readString(dis, 16);
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.xPosition);
        dos.writeShort(this.yPosition);
        dos.writeInt(this.zPosition);
        SetMobSpawnerPacket.writeString(this.spawnType, dos);
    }

    @Override
    public void handlePacket(PacketHandler packetHandler) {
        packetHandler.handleSetMobSpawner(this);
    }

    @Override
    public int getEstimatedSize() {
        return 12 + this.spawnType.length();
    }
}

