/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.sound.SoundTypes;

public class SyncIDsPacket
extends Packet {
    public Map<String, Integer> soundIds;
    private int packetSize;

    @Override
    public void read(DataInputStream in) throws IOException {
        int size = 0;
        this.packetSize = size += this.readSoundIds(in);
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        int size = 0;
        this.packetSize = size += this.writeSoundIds(out);
    }

    public int readSoundIds(DataInputStream in) throws IOException {
        this.soundIds = new HashMap<String, Integer>();
        int bytesRead = 0;
        int count = in.readInt();
        bytesRead += 4;
        for (int i = 0; i < count; ++i) {
            int id = in.readShort() & 0xFFFF;
            String name = SyncIDsPacket.readString(in, 64);
            this.soundIds.put(name, id);
        }
        return bytesRead;
    }

    public int writeSoundIds(DataOutputStream out) throws IOException {
        Map<String, Integer> soundIds = SoundTypes.getSoundIds();
        int bytesWritten = 0;
        out.writeInt(soundIds.size());
        bytesWritten += 4;
        for (Map.Entry<String, Integer> entry : soundIds.entrySet()) {
            out.writeShort(entry.getValue());
            SyncIDsPacket.writeString(entry.getKey(), out);
        }
        return bytesWritten;
    }

    @Override
    public void handlePacket(PacketHandler packetHandler) {
        packetHandler.handleIds(this);
    }

    @Override
    public int getEstimatedSize() {
        return this.packetSize;
    }
}

