/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.helper;

import java.awt.Desktop;
import java.io.File;

public abstract class Utils {
    public static final String hexString = "0123456789ABCDEF";

    public static String toHex(int value, int length) {
        int[] arr = new int[length];
        for (int i = 0; i < length; ++i) {
            arr[i] = value & 0xF;
            value >>= 4;
        }
        StringBuilder str = new StringBuilder();
        for (int i = arr.length - 1; i >= 0; --i) {
            str.append(hexString.charAt(arr[i]));
        }
        return str.toString();
    }

    public static int percentRound(double d) {
        return (int)Math.round(d * 100.0);
    }

    public static int percent(double d) {
        return (int)(d * 100.0);
    }

    public static double floor10(double d) {
        return (double)((long)(d * 10.0)) / 10.0;
    }

    public static double floor100(double d) {
        return (double)((long)(d * 100.0)) / 100.0;
    }

    public static void openDirectory(File file) {
        if (!file.exists()) {
            System.out.println("Can't open directory '" + file.getAbsolutePath() + "' because it doesnt exist!");
            return;
        }
        if (!file.isDirectory()) {
            System.out.println("Not a directory: '" + file.getAbsolutePath() + "'!");
            return;
        }
        try {
            Desktop.getDesktop().open(file);
        }
        catch (Exception e) {
            System.err.println("Error opening directory '" + file.getAbsolutePath() + "'!");
            e.printStackTrace();
        }
    }
}

