/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.ChestBlockEntity;
import net.minecraft.core.block.entity.DispenserBlockEntity;
import net.minecraft.core.block.entity.MobSpawnerBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class WorldFeatureLabyrinth
extends WorldFeature {
    int dungeonSize = 0;
    int dungeonLimit;
    int dungeonCount = 0;
    boolean treasureGenerated = false;
    boolean libraryGenerated = false;
    boolean isCold = false;
    int wallBlockA;
    int wallBlockB;
    int brickBlockA;
    int brickBlockB;
    int slabBlock;
    public ItemStack treasureItem;
    public WeightedRandomBag<WeightedRandomLootObject> chestLoot;
    public WeightedRandomBag<WeightedRandomLootObject> dispenserLoot;
    public WeightedRandomBag<String> spawnerMonsters;

    public WorldFeatureLabyrinth() {
        this.wallBlockA = Blocks.COBBLE_STONE.id;
        this.wallBlockB = Blocks.COBBLE_STONE_MOSSY.id;
        this.brickBlockA = Blocks.BRICK_STONE_POLISHED.id;
        this.brickBlockB = Blocks.BRICK_STONE_POLISHED_MOSSY.id;
        this.slabBlock = Blocks.SLAB_STONE_POLISHED.id;
    }

    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        Biome biome = world.getBlockBiome(x, y, z);
        if (biome == Biomes.OVERWORLD_DESERT || biome == Biomes.OVERWORLD_OUTBACK) {
            this.wallBlockA = Blocks.SANDSTONE.id;
            this.wallBlockB = Blocks.SANDSTONE.id;
            this.brickBlockA = Blocks.BRICK_SANDSTONE.id;
            this.brickBlockB = Blocks.BRICK_SANDSTONE.id;
            this.slabBlock = Blocks.SLAB_SANDSTONE.id;
        }
        if (biome == Biomes.OVERWORLD_TAIGA || biome == Biomes.OVERWORLD_TUNDRA || biome == Biomes.OVERWORLD_GLACIER) {
            this.wallBlockA = Blocks.PERMAFROST.id;
            this.wallBlockB = Blocks.COBBLE_PERMAFROST.id;
            this.brickBlockA = Blocks.BRICK_PERMAFROST.id;
            this.brickBlockB = Blocks.BRICK_PERMAFROST.id;
            this.isCold = true;
        }
        this.chestLoot = new WeightedRandomBag();
        this.chestLoot.addEntry(new WeightedRandomLootObject(Items.INGOT_IRON.getDefaultStack(), 1, 6), 100.0);
        this.chestLoot.addEntry(new WeightedRandomLootObject(Items.INGOT_GOLD.getDefaultStack(), 1, 4), 100.0);
        this.chestLoot.addEntry(new WeightedRandomLootObject(Items.SULPHUR.getDefaultStack(), 3, 8), 100.0);
        this.chestLoot.addEntry(new WeightedRandomLootObject(Items.DIAMOND.getDefaultStack(), 1, 4), 2.0);
        this.chestLoot.addEntry(new WeightedRandomLootObject(Items.FOOD_APPLE_GOLD.getDefaultStack()), 1.0);
        this.chestLoot.addEntry(new WeightedRandomLootObject(Items.DUST_REDSTONE.getDefaultStack(), 1, 4), 100.0);
        for (int i = 0; i < 9; ++i) {
            this.chestLoot.addEntry(new WeightedRandomLootObject(new ItemStack(Item.itemsList[Items.RECORD_13.id + i])), 1.0);
        }
        this.chestLoot.addEntry(new WeightedRandomLootObject(Items.FOOD_APPLE.getDefaultStack()), 100.0);
        this.chestLoot.addEntry(new WeightedRandomLootObject(Blocks.SPONGE_DRY.getDefaultStack(), 1, 4), 100.0);
        this.chestLoot.addEntry(new WeightedRandomLootObject(Items.HANDCANNON_LOADED.getDefaultStack()), 0.5);
        this.chestLoot.addEntry(new WeightedRandomLootObject(Items.HANDCANNON_UNLOADED.getDefaultStack()), 4.5);
        this.chestLoot.addEntry(new WeightedRandomLootObject(Items.ARMOR_HELMET_CHAINMAIL.getDefaultStack()).setRandomMetadata(Items.ARMOR_HELMET_CHAINMAIL.getMaxDamage() / 2, Items.ARMOR_HELMET_CHAINMAIL.getMaxDamage()), 20.0);
        this.chestLoot.addEntry(new WeightedRandomLootObject(Items.ARMOR_CHESTPLATE_CHAINMAIL.getDefaultStack()).setRandomMetadata(Items.ARMOR_CHESTPLATE_CHAINMAIL.getMaxDamage() / 2, Items.ARMOR_CHESTPLATE_CHAINMAIL.getMaxDamage()), 20.0);
        this.chestLoot.addEntry(new WeightedRandomLootObject(Items.ARMOR_LEGGINGS_CHAINMAIL.getDefaultStack()).setRandomMetadata(Items.ARMOR_LEGGINGS_CHAINMAIL.getMaxDamage() / 2, Items.ARMOR_LEGGINGS_CHAINMAIL.getMaxDamage()), 20.0);
        this.chestLoot.addEntry(new WeightedRandomLootObject(Items.ARMOR_BOOTS_CHAINMAIL.getDefaultStack()).setRandomMetadata(Items.ARMOR_BOOTS_CHAINMAIL.getMaxDamage() / 2, Items.ARMOR_BOOTS_CHAINMAIL.getMaxDamage()), 20.0);
        this.chestLoot.addEntry(new WeightedRandomLootObject(Items.INGOT_STEEL_CRUDE.getDefaultStack()), 10.0);
        this.chestLoot.addEntry(new WeightedRandomLootObject(null), 892.0);
        this.dispenserLoot = new WeightedRandomBag();
        this.dispenserLoot.addEntry(new WeightedRandomLootObject(Items.AMMO_ARROW.getDefaultStack(), 5, 7), 300.0);
        this.dispenserLoot.addEntry(new WeightedRandomLootObject(Items.AMMO_ARROW_GOLD.getDefaultStack()), 10.0);
        this.dispenserLoot.addEntry(new WeightedRandomLootObject(Items.AMMO_CHARGE_EXPLOSIVE.getDefaultStack()), 0.5);
        this.dispenserLoot.addEntry(new WeightedRandomLootObject(null), 289.5);
        this.spawnerMonsters = new WeightedRandomBag();
        this.spawnerMonsters.addEntry("Skeleton", 1.0);
        this.spawnerMonsters.addEntry("Zombie", 1.0);
        if (this.isCold) {
            this.spawnerMonsters.addEntry("Snowman", 1.0);
            this.spawnerMonsters.addEntry("ArmouredZombie", 1.0);
            this.treasureItem = Items.ARMOR_BOOTS_ICESKATES.getDefaultStack();
        } else {
            this.spawnerMonsters.addEntry("ArmouredZombie", 2.0);
            this.treasureItem = Items.ARMOR_QUIVER_GOLD.getDefaultStack();
        }
        if (this.canReplace(world, x, y, z)) {
            this.dungeonLimit = 1;
            this.generateBranch(world, random, x, y, z);
            return true;
        }
        return false;
    }

    public void generateBranch(World world, Random random, int blockX, int blockY, int blockZ) {
        boolean generateTrapOnWall = false;
        for (int x = blockX - 2; x <= blockX + 2; ++x) {
            boolean xWallCheck = x == blockX - 2 || x == blockX + 2;
            for (int y = blockY - 2; y <= blockY + 1; ++y) {
                boolean yWallCheck = y == blockY - 2;
                for (int z = blockZ - 2; z <= blockZ + 2; ++z) {
                    boolean zWallCheck;
                    boolean bl = zWallCheck = z == blockZ - 2 || z == blockZ + 2;
                    if (!this.canReplace(world, x, y, z)) continue;
                    if (xWallCheck && zWallCheck) {
                        world.setBlockWithNotify(x, y, z, random.nextInt(4) == 0 ? this.brickBlockB : this.brickBlockA);
                    } else if (xWallCheck || zWallCheck) {
                        world.setBlockWithNotify(x, y, z, this.wallBlockB);
                    } else if (yWallCheck) {
                        world.setBlockWithNotify(x, y, z, this.wallBlockB);
                    } else {
                        world.setBlockWithNotify(x, y, z, 0);
                    }
                    if (generateTrapOnWall || !xWallCheck && !zWallCheck || x != blockZ && z != blockZ || y != blockY) continue;
                    world.setBlockWithNotify(x, y, z, Blocks.MOTION_SENSOR_IDLE.id);
                    world.setBlockWithNotify(x, y - 1, z, Blocks.DISPENSER_COBBLE_STONE.id);
                    DispenserBlockEntity tileEntityDispenser = (DispenserBlockEntity)world.getBlockEntity(x, blockY - 1, z);
                    for (int k4 = 0; k4 < 3; ++k4) {
                        ItemStack itemstack = this.pickDispenserLootItem(random);
                        if (itemstack == null) continue;
                        tileEntityDispenser.setItem(random.nextInt(tileEntityDispenser.getContainerSize()), itemstack);
                    }
                    generateTrapOnWall = true;
                }
            }
        }
        if (this.dungeonSize < 10) {
            ++this.dungeonSize;
            int corridorsToSpawn = random.nextInt(4);
            for (int i = 0; i <= corridorsToSpawn; ++i) {
                this.createCorridor(world, random, blockX, blockY, blockZ, random.nextInt(4), 0);
            }
        }
    }

    public void generateDrop(World world, Random random, int blockX, int blockY, int blockZ) {
        if (random.nextBoolean()) {
            this.generateDungeon(world, random, blockX, blockY, blockZ, false);
        }
        int dropHeight = random.nextInt(10) + 10;
        for (int x = blockX - 2; x <= blockX + 2; ++x) {
            for (int y = blockY - dropHeight; y <= blockY + 1; ++y) {
                for (int z = blockZ - 2; z <= blockZ + 2; ++z) {
                    boolean yWallCheck;
                    boolean xWallCheck = x == blockX - 2 || x == blockX + 2;
                    boolean zWallCheck = z == blockZ - 2 || z == blockZ + 2;
                    boolean bl = yWallCheck = y == blockY - dropHeight;
                    if (!this.canReplace(world, x, y, z)) continue;
                    if (xWallCheck || zWallCheck) {
                        world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        continue;
                    }
                    if (yWallCheck) {
                        world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        if (this.dungeonSize < 10) continue;
                        world.setBlockWithNotify(x, y + 1, z, Blocks.SPIKES.id);
                        continue;
                    }
                    if (x != blockX && z != blockZ && random.nextInt(20) == 0 && world.getBlockId(x, y + 1, z) != this.slabBlock) {
                        world.setBlockWithNotify(x, y, z, this.slabBlock);
                        continue;
                    }
                    world.setBlockWithNotify(x, y, z, 0);
                }
            }
        }
        if (this.dungeonSize < 10) {
            ++this.dungeonSize;
            int corridorsToSpawn = random.nextInt(4) + 1;
            for (int i = 1; i <= corridorsToSpawn; ++i) {
                this.createCorridor(world, random, blockX, blockY - (dropHeight - 2), blockZ, random.nextInt(4), 0);
            }
        }
    }

    private boolean canReplace(World world, int x, int y, int z) {
        if (y <= 11) {
            return false;
        }
        if (world.getBlockId(x, y, z) == this.brickBlockA || world.getBlockId(x, y, z) == Blocks.PLANKS_OAK.id || world.getBlockId(x, y, z) == Blocks.COBWEB.id || world.getBlockId(x, y, z) == Blocks.BOOKSHELF_PLANKS_OAK.id || world.getBlockId(x, y, z) == Blocks.MOBSPAWNER.id || world.getBlockId(x, y, z) == this.brickBlockB) {
            return false;
        }
        if (world.getBlockId(x, y, z) == Blocks.MOTION_SENSOR_IDLE.id || world.getBlockId(x, y, z) == Blocks.DISPENSER_COBBLE_STONE.id || world.getBlockId(x, y, z) == Blocks.MOTION_SENSOR_ACTIVE.id) {
            world.removeBlockTileEntity(x, y, z);
            world.setBlockWithNotify(x, y, z, 0);
            return true;
        }
        return BlockTags.CAVES_CUT_THROUGH.appliesTo(world.getBlock(x, y, z)) || world.getBlockMaterial(x, y, z) == Material.grass || world.getBlockMaterial(x, y, z) == Material.dirt || world.getBlockMaterial(x, y, z) == Material.stone || world.getBlockMaterial(x, y, z) == Material.slate || world.getBlockMaterial(x, y, z) == Material.marble || world.getBlockMaterial(x, y, z) == Material.limestone || world.getBlockMaterial(x, y, z) == Material.basalt || world.getBlockMaterial(x, y, z) == Material.granite || world.getBlockMaterial(x, y, z) == Material.permafrost || world.getBlockMaterial(x, y, z) == Material.sand || world.getBlockMaterial(x, y, z) == Material.moss;
    }

    private void generateCorridor(World world, Random random, int blockX, int blockY, int blockZ, int rot, int corridorIteration) {
        int height = 2;
        int width = 2;
        int length = 2;
        for (int x = blockX - width; x <= blockX + width; ++x) {
            boolean xWallCheck = x == blockX - width || x == blockX + width;
            for (int y = blockY - height; y <= blockY + (height - 1); ++y) {
                boolean yWallCheck = y == blockY - height;
                for (int z = blockZ - length; z <= blockZ + length; ++z) {
                    boolean zWallCheck;
                    boolean bl = zWallCheck = z == blockZ - length || z == blockZ + length;
                    if (!this.canReplace(world, x, y, z) || (xWallCheck || zWallCheck || yWallCheck) && world.getBlockId(x, y + 1, z) == 0 && random.nextInt(3) > 0) continue;
                    if (rot == 0) {
                        if (xWallCheck) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        } else if (z == blockZ + length) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        } else if (yWallCheck) {
                            if (random.nextInt(3) == 0) {
                                world.setBlockWithNotify(x, y, z, this.wallBlockB);
                            } else {
                                world.setBlockWithNotify(x, y, z, this.wallBlockA);
                            }
                        } else {
                            world.setBlockWithNotify(x, y, z, 0);
                        }
                    } else if (rot == 1) {
                        if (x == blockX - width) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        } else if (zWallCheck) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        } else if (yWallCheck) {
                            if (random.nextInt(3) == 0) {
                                world.setBlockWithNotify(x, y, z, this.wallBlockB);
                            } else {
                                world.setBlockWithNotify(x, y, z, this.wallBlockA);
                            }
                        } else {
                            world.setBlockWithNotify(x, y, z, 0);
                        }
                    } else if (rot == 2) {
                        if (xWallCheck) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        } else if (z == blockZ - length) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        } else if (yWallCheck) {
                            if (random.nextInt(3) == 0) {
                                world.setBlockWithNotify(x, y, z, this.wallBlockB);
                            } else {
                                world.setBlockWithNotify(x, y, z, this.wallBlockA);
                            }
                        } else {
                            world.setBlockWithNotify(x, y, z, 0);
                        }
                    } else if (x == blockX + width) {
                        world.setBlockWithNotify(x, y, z, this.wallBlockA);
                    } else if (zWallCheck) {
                        world.setBlockWithNotify(x, y, z, this.wallBlockA);
                    } else if (yWallCheck) {
                        if (random.nextInt(3) == 0) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        } else {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        }
                    } else {
                        world.setBlockWithNotify(x, y, z, 0);
                    }
                    if (y != blockY + (height - 1) || zWallCheck || xWallCheck || random.nextInt(20) != 0) continue;
                    world.setBlockWithNotify(x, y, z, Blocks.COBWEB.id);
                }
            }
        }
        if (random.nextInt(2) == 0 && corridorIteration > 1) {
            if (random.nextInt(2) == 0) {
                this.generateBranch(world, random, blockX, blockY, blockZ);
            } else {
                this.generateDrop(world, random, blockX, blockY, blockZ);
            }
        } else if (random.nextInt(2) == 0 && corridorIteration > 1 && this.dungeonSize > 3 || this.dungeonSize >= 10 && this.dungeonCount < this.dungeonLimit) {
            this.createDungeon(world, random, blockX, blockY, blockZ, rot);
            ++this.dungeonCount;
        } else {
            if (random.nextInt(10) == 0 && corridorIteration > 1 && this.dungeonSize > 5) {
                return;
            }
            this.createCorridor(world, random, blockX, blockY, blockZ, rot, corridorIteration + 1);
        }
    }

    private void createCorridor(World world, Random random, int blockX, int blockY, int blockZ, int rot, int size) {
        if (rot == 0) {
            this.generateCorridor(world, random, blockX, blockY, blockZ + 4, 0, size);
        }
        if (rot == 1) {
            this.generateCorridor(world, random, blockX - 4, blockY, blockZ, 1, size);
        }
        if (rot == 2) {
            this.generateCorridor(world, random, blockX, blockY, blockZ - 4, 2, size);
        }
        if (rot == 3) {
            this.generateCorridor(world, random, blockX + 4, blockY, blockZ, 3, size);
        }
    }

    private void generateDungeon(World world, Random random, int blockX, int blockY, int blockZ, boolean doSpawner) {
        int chestZ;
        int size = 4;
        if (blockY < 10) {
            return;
        }
        for (int x = blockX - size; x <= blockX + size; ++x) {
            for (int y = blockY - 2; y <= blockY + 2; ++y) {
                for (int z = blockZ - size; z <= blockZ + size; ++z) {
                    boolean yWallCheck;
                    boolean xWallCheck = x == blockX - size || x == blockX + size;
                    boolean zWallCheck = z == blockZ - size || z == blockZ + size;
                    boolean bl = yWallCheck = y == blockY - 2;
                    if (!this.canReplace(world, x, y, z)) continue;
                    if (xWallCheck || zWallCheck) {
                        world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        continue;
                    }
                    if (yWallCheck) {
                        if (random.nextInt(5) == 0) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockB);
                            continue;
                        }
                        world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        continue;
                    }
                    world.setBlockWithNotify(x, y, z, 0);
                }
            }
        }
        int chestX = blockX + random.nextInt(size - 1) - (size - 1);
        if (this.canReplace(world, chestX, blockY - 2, chestZ = blockZ + random.nextInt(size - 1) - (size - 1))) {
            world.setBlockWithNotify(chestX, blockY - 1, chestZ, Blocks.CHEST_PLANKS_OAK.id);
            ChestBlockEntity tileentitychest = (ChestBlockEntity)world.getBlockEntity(chestX, blockY - 1, chestZ);
            for (int k4 = 0; k4 < 10; ++k4) {
                ItemStack itemstack = this.pickCheckLootItem(random);
                if (itemstack == null) continue;
                tileentitychest.setItem(random.nextInt(tileentitychest.getContainerSize()), itemstack);
            }
        }
        if (doSpawner) {
            world.setBlockWithNotify(blockX, blockY - 1, blockZ, Blocks.MOBSPAWNER.id);
            MobSpawnerBlockEntity tileentitymobspawner = (MobSpawnerBlockEntity)world.getBlockEntity(blockX, blockY - 1, blockZ);
            if (tileentitymobspawner != null) {
                tileentitymobspawner.setMobId(this.pickMobSpawner(random));
            }
        }
    }

    private void generateLibrary(World world, Random random, int blockX, int blockY, int blockZ) {
        int size = 10;
        int sideFacing = random.nextInt(2);
        if (blockY < 10) {
            return;
        }
        for (int x = blockX - size; x <= blockX + size; ++x) {
            for (int y = blockY - 2; y <= blockY + 3; ++y) {
                for (int z = blockZ - size; z <= blockZ + size; ++z) {
                    boolean yWallCheck;
                    int xRoom = x - blockX + size;
                    int zRoom = z - blockZ + size;
                    boolean xWallCheck = x == blockX - size || x == blockX + size;
                    boolean zWallCheck = z == blockZ - size || z == blockZ + size;
                    boolean bl = yWallCheck = y == blockY - 2;
                    if (!this.canReplace(world, x, y, z)) continue;
                    if (xWallCheck) {
                        if (zRoom % 4 != 0) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        } else {
                            world.setBlockWithNotify(x, y, z, this.brickBlockA);
                        }
                    } else if (zWallCheck) {
                        if (xRoom % 4 != 0) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        } else {
                            world.setBlockWithNotify(x, y, z, this.brickBlockA);
                        }
                    } else if (yWallCheck) {
                        if (x > blockX - 2 && x < blockX + 2 || z > blockZ - 2 && z < blockZ + 2) {
                            world.setBlockWithNotify(x, y, z, Blocks.PLANKS_OAK.id);
                        } else if (random.nextInt(5) == 0) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        } else {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        }
                        if (x > blockX - 3 && x < blockX + 3 && z > blockZ - 3 && z < blockZ + 3) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        }
                    } else if (y == blockY + 3) {
                        if (random.nextInt(5) == 0) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        } else {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        }
                    } else if (x > blockX - size && x < blockX + size || z > blockZ - size && z < blockX + size) {
                        if (!(xRoom % 4 == 0 || zRoom % 2 != 0 || x > blockX - 2 && x < blockX + 2 || z > blockZ - 1 && z < blockZ + 1 || y >= blockY + 2)) {
                            if (xRoom % 2 == 0) {
                                world.setBlockWithNotify(x, y, z, Blocks.BOOKSHELF_PLANKS_OAK.id);
                            } else if (random.nextInt(5) == 0) {
                                world.setBlockWithNotify(x, y, z, Blocks.LOG_OAK_MOSSY.id);
                            } else {
                                world.setBlockWithNotify(x, y, z, Blocks.LOG_OAK.id);
                            }
                        } else {
                            world.setBlockWithNotify(x, y, z, 0);
                        }
                    } else {
                        world.setBlockWithNotify(x, y, z, 0);
                    }
                    if (zRoom % 2 != 0 || x != blockX - 2 && x != blockX + 2 || z != blockZ - 2 && z != blockZ + 2) continue;
                    world.setBlockWithNotify(x, y, z, this.brickBlockA);
                }
            }
        }
        this.generateDrop(world, random, blockX, blockY, blockZ);
    }

    private void createDungeon(World world, Random random, int blockX, int blockY, int blockZ, int rot) {
        int dx = 0;
        int dz = 0;
        if (rot == 0) {
            dz = 1;
        }
        if (rot == 1) {
            dx = -1;
        }
        if (rot == 2) {
            dz = -1;
        }
        if (rot == 3) {
            dx = 1;
        }
        if (this.canReplace(world, blockX + dx * 5, blockY, blockZ + dz * 5)) {
            if (this.dungeonSize == 10 && !this.libraryGenerated) {
                this.libraryGenerated = true;
                this.generateLibrary(world, random, blockX + dx * 4, blockY, blockZ + dz * 4);
            } else {
                this.generateDungeon(world, random, blockX + dx * 4, blockY, blockZ + dz * 4, true);
            }
        }
    }

    private ItemStack pickDispenserLootItem(Random random) {
        return this.dispenserLoot.getRandom(random).getItemStack(random);
    }

    private ItemStack pickCheckLootItem(Random random) {
        if (!this.treasureGenerated && this.dungeonSize > 7) {
            this.treasureGenerated = true;
            return this.treasureItem.copy();
        }
        return this.chestLoot.getRandom(random).getItemStack(random);
    }

    private String pickMobSpawner(Random random) {
        return this.spawnerMonsters.getRandom(random);
    }
}

