/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature.tree.spooner;

import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.MethodParametersAnnotation;
import net.minecraft.core.world.generate.feature.WorldFeature;

public abstract class WorldFeatureSpoonerTree
extends WorldFeature {
    protected int[] pos = null;
    protected int height;
    protected final int trunkId;
    protected final int trunkData;
    protected final int leavesId;
    protected final int leavesData;
    protected Random random = null;

    protected static int distToMat(double[] coord, double[] vec, List<Integer> matidxlist, World world, boolean invert, double limit) {
        int z;
        int y;
        int x;
        int blockId;
        double[] curCoord = new double[]{coord[0] + 0.5, coord[1] + 0.5, coord[2] + 0.5};
        int iterations = 0;
        while (!(matidxlist.contains(blockId = world.getBlockId(x = (int)Math.floor(curCoord[0]), y = (int)Math.floor(curCoord[1]), z = (int)Math.floor(curCoord[2]))) && !invert || !matidxlist.contains(blockId) && invert)) {
            for (int i = 0; i < 3; ++i) {
                int n = i;
                curCoord[n] = curCoord[n] + vec[i];
            }
            ++iterations;
            if (limit == 0.0 || !((double)iterations > limit)) continue;
            break;
        }
        return iterations;
    }

    protected boolean assignValue(int x, int y, int z, int id, int meta, World world) {
        if (id == this.leavesId) {
            if (!Block.solid[world.getBlockId(x, y, z)]) {
                return world.setBlockAndMetadataWithNotify(x, y, z, id, meta);
            }
            return false;
        }
        return world.setBlockAndMetadata(x, y, z, id, meta);
    }

    @MethodParametersAnnotation(names={"height", "trunkId", "trunkData", "leavesId", "leavesData"})
    public WorldFeatureSpoonerTree(int height, int trunkId, int trunkData, int leavesId, int leavesData) {
        this.height = height;
        this.trunkId = trunkId;
        this.trunkData = trunkData;
        this.leavesId = leavesId;
        this.leavesData = leavesData;
    }

    protected void prepare(World world) {
    }

    protected void makeTrunk(World world) {
    }

    protected void makeFoliage(World world) {
    }

    private boolean canGenerateTree(World world) {
        int blockIdUnderneath = world.getBlockId(this.pos[0], this.pos[1] - 1, this.pos[2]);
        if (!Block.hasTag(blockIdUnderneath, BlockTags.GROWS_TREES)) {
            return false;
        }
        for (int yC = this.pos[1]; yC <= this.pos[1] + 5; ++yC) {
            for (int xC = this.pos[0] - 1; xC <= this.pos[0] + 1; ++xC) {
                for (int zC = this.pos[2] - 1; zC <= this.pos[2] + 1; ++zC) {
                    int blockId = world.getBlockId(xC, yC, zC);
                    if (blockId == 0 || blockId == this.leavesId) continue;
                    return false;
                }
            }
        }
        int interruptedTrunkHeight = -1;
        for (int y = this.pos[1]; y < world.getHeightBlocks(); ++y) {
            if (!Block.solid[world.getBlockId(this.pos[0], y, this.pos[2])]) continue;
            interruptedTrunkHeight = y - this.pos[1];
            break;
        }
        if (interruptedTrunkHeight == -1) {
            return true;
        }
        if (interruptedTrunkHeight < 6) {
            return false;
        }
        this.height = interruptedTrunkHeight;
        return true;
    }

    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        this.random = random;
        this.pos = new int[]{x, y, z};
        if (y < 1 || y + this.height > world.getHeightBlocks()) {
            return false;
        }
        if (!this.canGenerateTree(world)) {
            return false;
        }
        this.prepare(world);
        this.makeFoliage(world);
        this.makeTrunk(world);
        return true;
    }
}

