/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.pathfinder;

import net.minecraft.core.util.helper.MathHelper;

public class Node {
    public final int x;
    public final int y;
    public final int z;
    private final int hash;
    int heapIdx = -1;
    float g;
    float h;
    float f;
    Node cameFrom;
    public boolean closed = false;

    public Node(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.hash = Node.createHash(x, y, z);
    }

    public static int createHash(int i, int j, int k) {
        return j & 0xFF | (i & Short.MAX_VALUE) << 8 | (k & Short.MAX_VALUE) << 24 | (i >= 0 ? 0 : Integer.MIN_VALUE) | (k >= 0 ? 0 : 32768);
    }

    public float distanceTo(Node other) {
        float f = other.x - this.x;
        float f1 = other.y - this.y;
        float f2 = other.z - this.z;
        return MathHelper.sqrt_float(f * f + f1 * f1 + f2 * f2);
    }

    public boolean equals(Object that) {
        if (that instanceof Node) {
            Node nThat = (Node)that;
            return this.hash == nThat.hash && this.x == nThat.x && this.y == nThat.y && this.z == nThat.z;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean inOpenSet() {
        return this.heapIdx >= 0;
    }

    public String toString() {
        return this.x + ", " + this.y + ", " + this.z;
    }
}

