/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.season;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.SeasonFall;
import net.minecraft.core.world.season.SeasonNull;
import net.minecraft.core.world.season.SeasonOverworldHell;
import net.minecraft.core.world.season.SeasonParadiseGold;
import net.minecraft.core.world.season.SeasonParadiseSilver;
import net.minecraft.core.world.season.SeasonSpring;
import net.minecraft.core.world.season.SeasonSummer;
import net.minecraft.core.world.season.SeasonWinter;
import net.minecraft.core.world.weather.Weathers;

public abstract class Seasons {
    private static final Map<String, Season> SEASONS_MAP = new HashMap<String, Season>();
    public static final Season NULL = Seasons.register(new SeasonNull("null"));
    public static final Season OVERWORLD_SPRING = Seasons.register(new SeasonSpring("overworld.spring").allowWeather(Weathers.OVERWORLD_RAIN, 0.3f).allowWeather(Weathers.OVERWORLD_FOG, 0.3f).setDayLength(0.5f).setCropGrowthFactor(1.5f).setGrowFlowers().setSaplingDropFactor(2.0f));
    public static final Season OVERWORLD_SUMMER = Seasons.register(new SeasonSummer("overworld.summer").allowWeather(Weathers.OVERWORLD_RAIN, 0.1f).allowWeather(Weathers.OVERWORLD_STORM, 0.1f).setDayLength(0.6f));
    public static final Season OVERWORLD_FALL = Seasons.register(new SeasonFall("overworld.fall").allowWeather(Weathers.OVERWORLD_RAIN, 0.2f).allowWeather(Weathers.OVERWORLD_STORM, 0.05f).allowWeather(Weathers.OVERWORLD_FOG, 0.5f).setDayLength(0.5f).setSaplingDropFactor(0.5f));
    public static final Season OVERWORLD_WINTER = Seasons.register(new SeasonWinter("overworld.winter").allowWeather(Weathers.OVERWORLD_SNOW, 0.5f).allowWeather(Weathers.OVERWORLD_FOG, 0.25f).setLetWeatherCleanUpSnow(false).setDayLength(0.3f).setCropGrowthFactor(0.25f).setKillFlowers().setSaplingDropFactor(0.1f));
    public static final Season OVERWORLD_HELL = Seasons.register(new SeasonOverworldHell("overworld.hell"));
    public static final Season OVERWORLD_WINTER_ENDLESS = Seasons.register(new SeasonWinter("overworld.winter.endless").allowWeather(Weathers.OVERWORLD_WINTER_SNOW, 1.0f).setLetWeatherCleanUpSnow(false).setDayLength(0.3f).setCropGrowthFactor(0.25f).setKillFlowers().setSaplingDropFactor(0.1f));
    public static final Season PARADISE_GOLD = Seasons.register(new SeasonParadiseGold("paradise.gold").setLetWeatherCleanUpSnow(false));
    public static final Season PARADISE_SILVER = Seasons.register(new SeasonParadiseSilver("paradise.silver").setLetWeatherCleanUpSnow(false));

    public static Season getSeason(String key) {
        return SEASONS_MAP.getOrDefault(key, NULL);
    }

    public static Season register(Season season) {
        if (SEASONS_MAP.containsKey(season.getId())) {
            throw new IllegalArgumentException("Season with ID \"" + season.getId() + "\" is already registered!");
        }
        SEASONS_MAP.put(season.getId(), season);
        return season;
    }

    public static List<Season> getAllSeasons() {
        ArrayList<String> seasonNames = new ArrayList<String>(SEASONS_MAP.keySet());
        seasonNames.sort(String.CASE_INSENSITIVE_ORDER);
        ArrayList<Season> seasons = new ArrayList<Season>();
        for (int i = 0; i < seasonNames.size(); ++i) {
            seasons.add(Seasons.getSeason((String)seasonNames.get(i)));
        }
        return seasons;
    }
}

