/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type.overworld;

import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderOverworld;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.perlin.overworld.ChunkGeneratorOverworld;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.weather.Weather;

public class WorldTypeOverworld
extends WorldType {
    public WorldTypeOverworld(WorldType.Properties properties) {
        super(properties);
    }

    @Override
    public void onWorldCreation(World world) {
        super.onWorldCreation(world);
        world.setWorldTime(75000L);
    }

    public static WorldType.Properties defaultProperties(String translationKey) {
        return WorldType.Properties.of(translationKey).brightnessRamp(WorldTypeOverworld.createLightRamp()).seasonConfig(SeasonConfig.builder().withSeasonInCycle(Seasons.OVERWORLD_SPRING, 14).withSeasonInCycle(Seasons.OVERWORLD_SUMMER, 14).withSeasonInCycle(Seasons.OVERWORLD_FALL, 14).withSeasonInCycle(Seasons.OVERWORLD_WINTER, 14).build()).oceanBlock(Blocks.FLUID_WATER_STILL).fillerBlock(Blocks.STONE).allowRespawn().withAurora();
    }

    public static float[] createLightRamp() {
        float[] brightnessRamp = new float[32];
        float f = 0.05f;
        for (int i = 0; i <= 31; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            if (i > 15) {
                f1 = 0.0f;
            }
            brightnessRamp[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
        return brightnessRamp;
    }

    @Override
    public BiomeProvider createBiomeProvider(World world) {
        return new BiomeProviderOverworld(world.getRandomSeed(), this);
    }

    @Override
    public ChunkGenerator createChunkGenerator(World world) {
        return new ChunkGeneratorOverworld(world);
    }

    @Override
    public boolean isValidSpawn(World world, int x, int y, int z) {
        return world.getBlockId(x, y, z) == Blocks.SAND.id;
    }

    @Override
    public float getCelestialAngle(World world, long tick, float partialTick) {
        return this.getTimeOfDay(world, tick, partialTick);
    }

    @Override
    public float[] getSunriseColor(float timeOfDay, float partialTick) {
        float middle;
        float[] sunriseCol = new float[4];
        float sunriseMinimum = 0.4f;
        float sunrisePresence = MathHelper.cos(timeOfDay * (float)Math.PI * 2.0f);
        if (sunrisePresence >= (middle = 0.0f) - sunriseMinimum && sunrisePresence <= middle + sunriseMinimum) {
            float c = (sunrisePresence - middle) / sunriseMinimum * 0.5f + 0.5f;
            float a = 1.0f - (1.0f - MathHelper.sin(c * (float)Math.PI)) * 0.99f;
            a *= a;
            sunriseCol[0] = c * 0.3f + 0.7f;
            sunriseCol[1] = c * c * 0.7f + 0.2f;
            sunriseCol[2] = c * c * 0.0f + 0.2f;
            sunriseCol[3] = a;
            return sunriseCol;
        }
        return null;
    }

    @Override
    public int getSkyDarken(World world, long tick, float partialTick) {
        float f1 = this.getCelestialAngle(world, tick, partialTick);
        float f2 = 1.0f - (MathHelper.cos(f1 * (float)Math.PI * 2.0f) * 2.0f + 0.5f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float weatherOffset = 0.0f;
        Weather currentWeather = world.getCurrentWeather();
        if (currentWeather != null) {
            weatherOffset = (float)currentWeather.subtractLightLevel * world.weatherManager.getWeatherIntensity() * world.weatherManager.getWeatherPower();
        }
        return (int)(f2 * (11.0f - weatherOffset) + weatherOffset);
    }

    @Override
    public Vec3 getFogColor(World world, double x, double y, double z, float celestialAngle, float partialTick) {
        float b;
        float g;
        float r;
        float dayProgress = MathHelper.cos(celestialAngle * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        dayProgress = MathHelper.clamp(dayProgress, 0.0f, 1.0f);
        if (Colorizers.fog.isEnabled()) {
            int x1 = MathHelper.floor(x);
            int y1 = MathHelper.floor(y);
            int z1 = MathHelper.floor(z);
            int color = Colorizers.fog.getColor(world, x1, y1, z1);
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        } else {
            r = 0.7529412f;
            g = 0.8470588f;
            b = 1.0f;
        }
        return Vec3.getTempVec3(r *= dayProgress * 0.94f + 0.06f, g *= dayProgress * 0.94f + 0.06f, b *= dayProgress * 0.91f + 0.09f);
    }
}

