/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.handler;

import java.io.IOException;
import java.net.Socket;
import java.security.Key;
import java.util.Random;
import net.minecraft.core.Global;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.AESSendKeyPacket;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.core.net.packet.DisconnectPacket;
import net.minecraft.core.net.packet.GameRulePacket;
import net.minecraft.core.net.packet.LoginPacket;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PhotoModePacket;
import net.minecraft.core.net.packet.PingHandshakePacket;
import net.minecraft.core.net.packet.PlayerGamemodePacket;
import net.minecraft.core.net.packet.PreLoginPacket;
import net.minecraft.core.net.packet.RecipeSyncPacket;
import net.minecraft.core.net.packet.SetSpawnPositionPacket;
import net.minecraft.core.net.packet.SetTimePacket;
import net.minecraft.core.net.packet.SyncIDsPacket;
import net.minecraft.core.net.packet.UpdatePlayerProfilePacket;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.RSA;
import net.minecraft.core.util.helper.RestHandler;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;
import net.minecraft.server.net.handler.ServerPacketHandler;
import net.minecraft.server.net.thread.ThreadLoginVerifier;
import net.minecraft.server.world.WorldServer;
import org.apache.log4j.Logger;

public class LoginPacketHandler
extends PacketHandler {
    public static String kickMessage = null;
    public static Logger logger = Logger.getLogger((String)"Minecraft");
    private static Random rand = new Random();
    public NetworkManager netManager;
    public boolean finishedProcessing = false;
    private MinecraftServer mcServer;
    private int loginTimer = 0;
    private String username = null;
    private LoginPacket loginPacket = null;
    private String serverId = "";

    public LoginPacketHandler(MinecraftServer minecraftserver, Socket socket, String s) throws IOException {
        this.mcServer = minecraftserver;
        this.netManager = new NetworkManager(socket, s, this);
        this.netManager.fakeLag = 0;
    }

    public void tryLogin() {
        if (this.loginPacket != null) {
            this.doLogin(this.loginPacket);
            this.loginPacket = null;
        }
        if (this.loginTimer++ == 600) {
            this.kickUser("Took too long to log in");
        } else {
            this.netManager.processReadPackets();
        }
    }

    public void kickUser(String s) {
        this.kickUser(s, false);
    }

    public void kickUser(String s, boolean silent) {
        try {
            if (!silent) {
                logger.info((Object)("Disconnecting " + this.getUserAndIPString() + ": " + s));
            }
            this.netManager.addToSendQueue(new DisconnectPacket(s));
            this.netManager.serverShutdown();
            this.finishedProcessing = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void handleHandshake(PreLoginPacket preLoginPacket) {
        if (this.mcServer.onlineMode) {
            this.serverId = Long.toHexString(rand.nextLong());
            this.netManager.addToSendQueue(new PreLoginPacket(this.serverId));
        } else {
            this.netManager.addToSendQueue(new PreLoginPacket("-"));
        }
    }

    @Override
    public void handleLogin(LoginPacket loginPacket) {
        this.username = loginPacket.username;
        if (loginPacket.playerEntityIdAndProtocolVersion != 29184) {
            if (loginPacket.playerEntityIdAndProtocolVersion > 29184) {
                this.kickUser("Outdated server!");
            } else {
                this.kickUser("Outdated client!");
            }
            return;
        }
        if (!this.mcServer.onlineMode) {
            this.doLogin(loginPacket);
        } else {
            new ThreadLoginVerifier(this, loginPacket).start();
        }
    }

    public void doLogin(LoginPacket loginPacket) {
        ServerPlayer entityplayermp = this.mcServer.playerList.getPlayerForLogin(this, loginPacket.username);
        if (entityplayermp != null) {
            this.mcServer.playerList.load(entityplayermp);
            entityplayermp.setWorld(this.mcServer.getDimensionWorld(entityplayermp.dimension));
            logger.info((Object)(this.getUserAndIPString() + " logged in with entity id " + entityplayermp.id + " at (" + entityplayermp.x + ", " + entityplayermp.y + ", " + entityplayermp.z + ")"));
            WorldServer worldserver = this.mcServer.getDimensionWorld(entityplayermp.dimension);
            ChunkCoordinates chunkcoordinates = worldserver.getSpawnPoint();
            ServerPacketHandler netserverhandler = new ServerPacketHandler(this.mcServer, this.netManager, entityplayermp);
            try {
                netserverhandler.sendPacket(new LoginPacket("", entityplayermp.id, worldserver.getRandomSeed(), (byte)worldserver.dimension.id, (byte)Registries.WORLD_TYPES.getNumericIdOfItem(worldserver.dimensionData.getWorldType()), NetworkManager.PACKET_DELAY, RSA.getPublicKey(RSA.RSAKeyChain.getPublic())));
                Key aesKey = AES.generateKey();
                netserverhandler.sendPacket(new AESSendKeyPacket(RSA.encrypt(AES.getKey(aesKey), RSA.getPublicKey(loginPacket.publicKey))));
                AES.keyChain.put(entityplayermp.username, aesKey);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            netserverhandler.sendPacket(new SetSpawnPositionPacket(chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z));
            this.mcServer.playerList.func_28170_a(entityplayermp, worldserver);
            this.mcServer.playerList.sendPacketToAllPlayers(new ChatPacket(TextFormatting.YELLOW + entityplayermp.getDisplayName() + TextFormatting.YELLOW + " joined the game."));
            this.mcServer.playerList.sendPacketToAllPlayers(new UpdatePlayerProfilePacket(entityplayermp.username, entityplayermp.nickname, entityplayermp.score, entityplayermp.chatColor, true, entityplayermp.isOperator()));
            if (this.mcServer.joinMessage != null && this.mcServer.joinMessage.length() > 0) {
                entityplayermp.playerNetServerHandler.sendPacket(new ChatPacket(this.mcServer.joinMessage));
            }
            this.mcServer.playerList.playerLoggedIn(entityplayermp);
            netserverhandler.teleportAndRotate(entityplayermp.x, entityplayermp.y, entityplayermp.z, entityplayermp.yRot, entityplayermp.xRot);
            this.mcServer.networkServer.addPlayer(netserverhandler);
            this.mcServer.playerList.sendPacketToAllPlayers(new PlayerGamemodePacket(entityplayermp.id, entityplayermp.gamemode.getId()));
            netserverhandler.sendPacket(new SetTimePacket(worldserver.getWorldTime()));
            entityplayermp.func_20057_k();
            if (MinecraftServer.statsStatus) {
                RestHandler.post("https://api.betterthanadventure.net/stats?serverToken=" + MinecraftServer.statsToken + "&count=" + this.mcServer.playerList.playerEntities.size());
            }
            entityplayermp.playerNetServerHandler.sendPacket(new PhotoModePacket(this.mcServer.disablePhotoMode));
            entityplayermp.playerNetServerHandler.sendPacket(new GameRulePacket(this.mcServer.getDimensionWorld(0).getLevelData().getGameRules()));
            for (RecipeEntryBase<?, ?, ?> recipe : Registries.RECIPES.getAllSerializableRecipes()) {
                entityplayermp.playerNetServerHandler.sendPacket(new RecipeSyncPacket(recipe, Registries.RECIPES.getAllSerializableRecipes().size()));
            }
            entityplayermp.playerNetServerHandler.sendPacket(new SyncIDsPacket());
        }
        this.finishedProcessing = true;
    }

    @Override
    public void handleErrorMessage(String s, Object[] aobj) {
        logger.info((Object)(this.getUserAndIPString() + " lost connection"));
        this.finishedProcessing = true;
    }

    @Override
    public void handlePingHandshake(PingHandshakePacket packet) {
        String msg = "";
        if (packet.pingHostString.equals("MC|PingHost")) {
            msg = "\u00a71\u00000\u0000BTA " + Global.VERSION + '\u0000' + this.mcServer.motd + '\u0000' + 0 + '\u0000' + 0;
        } else if (packet.pingHostString.equals("BTAPingHost")) {
            msg = "\u00a71\u000029184\u0000" + Global.VERSION + '\u0000' + this.mcServer.motd + '\u0000' + this.mcServer.playerList.playerEntities.size() + '\u0000' + this.mcServer.maxPlayers;
        }
        this.kickUser(msg, true);
    }

    @Override
    public void handleInvalidPacket(Packet packet) {
        if (kickMessage != null) {
            this.kickUser(kickMessage);
            kickMessage = null;
        } else {
            this.kickUser("Protocol error");
        }
    }

    public String getUserAndIPString() {
        if (this.username != null) {
            return this.username + " [" + this.netManager.getRemoteAddress().toString() + "]";
        }
        return this.netManager.getRemoteAddress().toString();
    }

    @Override
    public boolean isServerHandler() {
        return true;
    }

    public static String getServerId(LoginPacketHandler netloginhandler) {
        return netloginhandler.serverId;
    }

    public static LoginPacket setLoginPacket(LoginPacketHandler netloginhandler, LoginPacket loginPacket) {
        netloginhandler.loginPacket = loginPacket;
        return netloginhandler.loginPacket;
    }
}

