/*
 * Decompiled with CFR 0.152.
 */
package net.betterthanadventure.utils;

import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.chunk.provider.ChunkProviderDynamic;
import net.minecraft.core.Global;
import net.minecraft.core.MinecraftAccessor;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.SkinVariantList;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.SpawnerMobs;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderOverworld;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.save.SaveHandlerClientMP;
import net.minecraft.core.world.save.mcregion.SaveFormat19134;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypes;
import org.slf4j.Logger;

public class BiomeFinder
implements MinecraftAccessor {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static long seed = 0L;
    public static int renderRes = 1024;
    public static int renderScale = 4;
    public static int posX = 0;
    public static int posY = 128;
    public static int posZ = 0;
    public static boolean highlightLoaded = false;
    private Color bg;
    private final Set<Biome> allBiomes = new HashSet<Biome>();
    private long lastProgress = 0L;
    private final Map<Biome, Integer> biomeCounts = new HashMap<Biome, Integer>();
    private File worldFolder;
    private final JFrame frame;
    private final String title = "Biome Finder";

    public static void main(String[] args) {
        File worldFolder = null;
        Boolean highlight = null;
        block22: for (String arg : args) {
            int i = arg.indexOf(61);
            if (i == -1) {
                LOGGER.warn("Skipping argument '{}'", (Object)arg);
                continue;
            }
            String key = arg.substring(0, i);
            String value = arg.substring(i + 1);
            switch (key) {
                case "world": {
                    worldFolder = new File(value);
                    continue block22;
                }
                case "world-client": {
                    worldFolder = new File(Minecraft.getMinecraft(Minecraft.class).getMinecraftDir(), "saves/" + value);
                    continue block22;
                }
                case "seed": {
                    seed = BiomeFinder.parseSeed(value);
                    continue block22;
                }
                case "render-scale": {
                    renderScale = Integer.parseInt(value);
                    continue block22;
                }
                case "render-res": {
                    renderRes = Integer.parseInt(value);
                    continue block22;
                }
                case "x": {
                    posX = Integer.parseInt(value);
                    continue block22;
                }
                case "y": {
                    posY = Integer.parseInt(value);
                    continue block22;
                }
                case "z": {
                    posZ = Integer.parseInt(value);
                    continue block22;
                }
                case "highlight": {
                    highlight = Boolean.parseBoolean(value);
                    continue block22;
                }
                default: {
                    LOGGER.warn("Unknown argument '{}'.", (Object)arg);
                }
            }
        }
        if (worldFolder == null) {
            LOGGER.info("No world specified");
        }
        highlightLoaded = highlight == null ? worldFolder != null : highlight;
        new BiomeFinder(worldFolder);
    }

    public static long parseSeed(String input) {
        try {
            return Long.parseLong(input);
        }
        catch (NumberFormatException e) {
            return input.hashCode();
        }
    }

    public BiomeFinder(File worldFolder) {
        File worldDirectory;
        int insetAmount = 10;
        this.worldFolder = worldFolder;
        try {
            worldDirectory = new File(Minecraft.getMinecraft(Minecraft.class).getMinecraftDir(), "saves");
        }
        catch (Exception e2) {
            worldDirectory = new File("");
        }
        this.frame = new JFrame("Biome Finder");
        if (Global.accessor != null) {
            this.frame.setDefaultCloseOperation(2);
        } else {
            this.frame.setDefaultCloseOperation(3);
            Global.accessor = this;
        }
        Blocks.init();
        Items.init();
        BiomeProviderOverworld.init();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e3) {
            throw new RuntimeException(e3);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.insets = new Insets(10, 10, 10, 10);
        constraints.gridx = 1;
        BufferedImage biomeImage = new BufferedImage(renderRes, renderRes, 1);
        JLabel imageLabel = new JLabel(new ImageIcon(biomeImage));
        panel.add((Component)imageLabel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 11;
        JLabel legendLabel = new JLabel(new ImageIcon(this.drawBiomeList(biomeImage)));
        panel.add((Component)legendLabel, constraints);
        JPanel controlPanel = new JPanel(new GridBagLayout());
        GridBagConstraints controlConstraints = new GridBagConstraints();
        controlConstraints.anchor = 18;
        final JTextField seedField = new JTextField(String.valueOf(seed), 18);
        seedField.setFont(seedField.getFont().deriveFont(20.0f));
        seedField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                seed = BiomeFinder.parseSeed(seedField.getText());
            }

            @Override
            public void keyPressed(KeyEvent e) {
                seed = BiomeFinder.parseSeed(seedField.getText());
            }

            @Override
            public void keyReleased(KeyEvent e) {
                seed = BiomeFinder.parseSeed(seedField.getText());
            }
        });
        seedField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Enter Seed"));
        controlConstraints.gridx = 0;
        controlConstraints.gridy = 0;
        controlConstraints.gridwidth = 2;
        controlPanel.add((Component)seedField, controlConstraints);
        JPanel posPanel = new JPanel(new GridBagLayout());
        GridBagConstraints posConstraints = new GridBagConstraints();
        posConstraints.anchor = 18;
        final JTextField xField = new JTextField(String.valueOf(posX), 5);
        xField.setFont(xField.getFont().deriveFont(20.0f));
        xField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                this.setRes(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                this.setRes(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.setRes(e);
            }

            private void setRes(KeyEvent e) {
                int _x = posX;
                try {
                    posX = Integer.parseInt(xField.getText());
                }
                catch (NumberFormatException nfe) {
                    posX = _x;
                }
            }
        });
        xField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "X"));
        posConstraints.gridx = 0;
        posPanel.add((Component)xField, posConstraints);
        final JTextField yField = new JTextField(String.valueOf(posY), 5);
        yField.setFont(yField.getFont().deriveFont(20.0f));
        yField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                this.setRes(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                this.setRes(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.setRes(e);
            }

            private void setRes(KeyEvent e) {
                int _y = posY;
                try {
                    posY = Integer.parseInt(yField.getText());
                }
                catch (NumberFormatException nfe) {
                    posY = _y;
                }
            }
        });
        yField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Y"));
        posConstraints.gridx = 1;
        posPanel.add((Component)yField, posConstraints);
        final JTextField zField = new JTextField(String.valueOf(posZ), 5);
        zField.setFont(zField.getFont().deriveFont(20.0f));
        zField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                this.setRes(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                this.setRes(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.setRes(e);
            }

            private void setRes(KeyEvent e) {
                int _z = posZ;
                try {
                    posZ = Integer.parseInt(zField.getText());
                }
                catch (NumberFormatException nfe) {
                    posZ = _z;
                }
            }
        });
        zField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Z"));
        posConstraints.gridx = 2;
        posPanel.add((Component)zField, posConstraints);
        posPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Position"));
        ++controlConstraints.gridy;
        controlConstraints.gridwidth = 3;
        controlPanel.add((Component)posPanel, controlConstraints);
        controlConstraints.gridwidth = 1;
        final JTextField renderResField = new JTextField(String.valueOf(renderRes), 8);
        renderResField.setFont(renderResField.getFont().deriveFont(20.0f));
        renderResField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                this.setRes(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                this.setRes(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.setRes(e);
            }

            private void setRes(KeyEvent e) {
                int _renderRes = renderRes;
                try {
                    renderRes = Integer.parseInt(renderResField.getText());
                }
                catch (NumberFormatException nfe) {
                    renderRes = _renderRes;
                }
            }
        });
        renderResField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Render Resolution"));
        controlConstraints.gridx = 0;
        ++controlConstraints.gridy;
        controlConstraints.gridwidth = 1;
        controlPanel.add((Component)renderResField, controlConstraints);
        final JTextField renderScaleField = new JTextField(String.valueOf(renderScale), 8);
        renderScaleField.setFont(renderScaleField.getFont().deriveFont(20.0f));
        renderScaleField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                this.setRes(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                this.setRes(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.setRes(e);
            }

            private void setRes(KeyEvent e) {
                int _renderScale = renderRes;
                try {
                    renderScale = Integer.parseInt(renderScaleField.getText());
                }
                catch (NumberFormatException nfe) {
                    renderScale = _renderScale;
                }
            }
        });
        renderScaleField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Render Scale"));
        controlConstraints.gridx = 1;
        controlPanel.add((Component)renderScaleField, controlConstraints);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.anchor = 18;
        JButton reloadButton = new JButton("Reload");
        reloadButton.addActionListener(e -> {
            BufferedImage _img = this.createBiomePreview();
            imageLabel.setIcon(new ImageIcon(_img));
            legendLabel.setIcon(new ImageIcon(this.drawBiomeList(_img)));
            this.frame.pack();
        });
        buttonConstraints.gridx = 0;
        buttonConstraints.gridy = 0;
        buttonPanel.add((Component)reloadButton, buttonConstraints);
        JButton closeWorldButton = new JButton("Close World");
        closeWorldButton.setEnabled(worldFolder != null);
        closeWorldButton.addActionListener(e -> {
            this.worldFolder = null;
            closeWorldButton.setEnabled(worldFolder != null);
            seedField.setEnabled(worldFolder == null);
        });
        buttonConstraints.gridx += 2;
        buttonPanel.add((Component)closeWorldButton, buttonConstraints);
        JButton selectWorldButton = new JButton("Select World");
        File finalWorldDirectory = worldDirectory;
        selectWorldButton.addActionListener(e -> {
            JFileChooser worldSelector = new JFileChooser(finalWorldDirectory);
            worldSelector.setDialogTitle("Select World");
            worldSelector.setFileSelectionMode(1);
            worldSelector.setAcceptAllFileFilterUsed(false);
            int result = worldSelector.showOpenDialog(this.frame);
            if (result == 0) {
                File selectedFile = worldSelector.getSelectedFile();
                LOGGER.info("Selected file: {}", (Object)selectedFile.getAbsolutePath());
                this.worldFolder = selectedFile;
                seedField.setEnabled(false);
                closeWorldButton.setEnabled(true);
            } else {
                this.worldFolder = null;
                seedField.setEnabled(true);
                closeWorldButton.setEnabled(false);
            }
        });
        --buttonConstraints.gridx;
        buttonPanel.add((Component)selectWorldButton, buttonConstraints);
        ++controlConstraints.gridy;
        controlConstraints.gridx = 0;
        controlConstraints.gridwidth = 3;
        controlPanel.add((Component)buttonPanel, controlConstraints);
        controlConstraints.gridwidth = 1;
        JCheckBox highlightBox = new JCheckBox("Highlight Generated Chunks", highlightLoaded);
        highlightBox.addItemListener(e -> {
            highlightLoaded = e.getStateChange() == 1;
        });
        ++controlConstraints.gridy;
        controlConstraints.gridx = 0;
        controlPanel.add((Component)highlightBox, controlConstraints);
        controlPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Controls", 2, 2));
        constraints.gridx = 2;
        constraints.gridy = 0;
        panel.add((Component)controlPanel, constraints);
        this.frame.getContentPane().add(panel);
        this.frame.pack();
        this.frame.setVisible(true);
        biomeImage = this.createBiomePreview();
        imageLabel.setIcon(new ImageIcon(biomeImage));
        legendLabel.setIcon(new ImageIcon(this.drawBiomeList(biomeImage)));
    }

    private BufferedImage createBiomePreview() {
        World world;
        BiomeProvider biomeProvider;
        LOGGER.info("Seed: {} | World?: {}", (Object)seed, (Object)(this.worldFolder != null ? 1 : 0));
        BiomeProviderOverworld.init();
        this.biomeCounts.clear();
        WorldType worldType = WorldTypes.OVERWORLD_EXTENDED;
        Dimension dimension = Dimension.overworld;
        if (this.worldFolder == null) {
            biomeProvider = worldType.createBiomeProvider(new World(new SaveHandlerClientMP(), "", dimension, worldType, seed));
            world = null;
        } else {
            SaveFormat19134 saveFormat = new SaveFormat19134(this.worldFolder.getParentFile());
            LevelStorage saveHandler = saveFormat.getSaveHandler(this.worldFolder.getName(), false);
            world = new World(saveHandler, saveHandler.getLevelData().getWorldName(), saveHandler.getLevelData().getRandomSeed(), null, null, new SpawnerMobs.SpawnerConfig());
            biomeProvider = worldType.createBiomeProvider(world);
        }
        this.allBiomes.clear();
        BufferedImage biomeImage = new BufferedImage(renderRes, renderRes, 1);
        int areaSize = renderRes * renderScale;
        LOGGER.info("Render Area: {} x {}", (Object)areaSize, (Object)areaSize);
        int offsetX = -areaSize / 2 + posX;
        int offsetZ = -areaSize / 2 + posZ;
        LOGGER.info("Offset: {}, {}", (Object)offsetX, (Object)offsetZ);
        int lastChunkX = Integer.MIN_VALUE;
        int lastChunkZ = Integer.MIN_VALUE;
        Chunk chunk = null;
        for (int i = 0; i < biomeImage.getWidth(); ++i) {
            for (int j = 0; j < biomeImage.getHeight(); ++j) {
                int x = offsetX + i * renderScale;
                int z = offsetZ + j * renderScale;
                Biome biome = null;
                if (world != null && world.getChunkProvider() instanceof ChunkProviderDynamic) {
                    try {
                        if (lastChunkX != Math.floorDiv(x, 16) || lastChunkZ != Math.floorDiv(z, 16)) {
                            lastChunkX = Math.floorDiv(x, 16);
                            lastChunkZ = Math.floorDiv(z, 16);
                            chunk = ((ChunkProviderDynamic)world.getChunkProvider()).getChunkLoader().loadChunk(world, lastChunkX, lastChunkZ);
                        }
                        if (chunk != null) {
                            biome = chunk.getBlockBiome(x & 0xF, posY, z & 0xF);
                        }
                    }
                    catch (Exception e) {
                        chunk = null;
                        LOGGER.error("Failed to load chunk at X:{}, Z:{}", Math.floorDiv(x, 16), Math.floorDiv(z, 16), e);
                    }
                }
                if (biome == null) {
                    biome = biomeProvider.getBiome(x, posY, z);
                }
                this.biomeCounts.put(biome, this.biomeCounts.getOrDefault(biome, 0) + 1);
                int color = this.getBiomeColor(biome);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color >> 0 & 0xFF;
                if (chunk == null && highlightLoaded) {
                    r /= 2;
                    g /= 2;
                    b /= 2;
                }
                biomeImage.setRGB(i, j, r << 16 | g << 8 | b);
                this.allBiomes.add(biome);
            }
            if (System.currentTimeMillis() <= this.lastProgress + 100L) continue;
            this.lastProgress = System.currentTimeMillis();
            float percent = (float)i / (float)biomeImage.getHeight();
            String progress = (int)(percent * 100.0f) + "%";
            LOGGER.info(progress);
            this.frame.setTitle("Biome Finder | loading " + progress);
        }
        this.bg = new Color(0, 0, 0, 240);
        Graphics g = biomeImage.getGraphics();
        int guiScale = Math.max(1, renderRes / 1024);
        g.setFont(new Font("Monospaced", 1, 13 * guiScale));
        g.setColor(this.bg);
        g.fillRect(biomeImage.getWidth() / 4, 0, biomeImage.getWidth() / 2, 16 * guiScale);
        g.setColor(Color.white);
        g.drawString(areaSize / 2 + " Blocks", biomeImage.getWidth() / 4, 14 * guiScale);
        this.drawCenterMarker(biomeImage, g, guiScale * 2);
        g.dispose();
        this.frame.setTitle("Biome Finder");
        return biomeImage;
    }

    private void drawCenterMarker(BufferedImage image, Graphics g, int w) {
        g.setColor(Color.black);
        g.fillRect(image.getWidth() / 2 - w * 2, image.getHeight() / 2 - w * 2, w * 4, w * 4);
        g.setColor(Color.red);
        g.fillRect(image.getWidth() / 2 - w * 1, image.getHeight() / 2 - w * 1, w * 2, w * 2);
    }

    private BufferedImage drawBiomeList(BufferedImage biomeImage) {
        int guiScale = Math.max(1, renderRes / 1024);
        ArrayList<Biome> biomeList = new ArrayList<Biome>(this.allBiomes);
        biomeList.sort(Comparator.comparingInt(Registries.BIOMES::getNumericIdOfItem));
        int lineHeight = 16 * guiScale;
        int w = 192 * guiScale;
        int h = biomeList.size() * lineHeight;
        int x = 0;
        int y = 0;
        BufferedImage image = new BufferedImage(w, Math.max(h, 1), 1);
        Graphics g = image.getGraphics();
        g.setColor(this.bg);
        g.fillRect(x, y, w, h);
        g.setFont(new Font("Monospaced", 1, 13 * guiScale));
        for (int i = 0; i < biomeList.size(); ++i) {
            int y1 = y + i * lineHeight;
            Biome biome = (Biome)biomeList.get(i);
            g.setColor(new Color(this.getBiomeColor(biome)));
            g.fillRect(x + 2 * guiScale, y1 + 2 * guiScale, 12 * guiScale, 12 * guiScale);
            String biomeName = Registries.BIOMES.getKey(biome);
            if (biomeName.startsWith("minecraft:")) {
                biomeName = biomeName.substring(10);
            }
            if (biomeName.startsWith("overworld.")) {
                biomeName = biomeName.substring(10);
            }
            float pctg = (float)this.biomeCounts.get(biome).intValue() / (float)(biomeImage.getWidth() * biomeImage.getHeight());
            biomeName = biomeName + " (" + (int)(pctg * 100.0f) + "%)";
            g.drawString(biomeName, x + 16 * guiScale, y1 + 12 * guiScale);
        }
        g.dispose();
        return image;
    }

    public int getBiomeColor(Biome biome) {
        return biome.color;
    }

    @Override
    public File getMinecraftDir() {
        return null;
    }

    @Override
    public IChunkProvider createChunkProvider(World world, IChunkLoader chunkLoader) {
        return new ChunkProviderDynamic(world, chunkLoader, world.getWorldType().createChunkGenerator(world));
    }

    @Override
    public int getAutosaveTimer() {
        return 0;
    }

    @Override
    public SkinVariantList getSkinVariantList() {
        return null;
    }

    @Override
    public String getMinecraftVersion() {
        return null;
    }
}

