/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.world.World;

public class HeartParticle
extends Particle {
    private final float oSize;

    public HeartParticle(World world, double x, double y, double z, double xa, double ya, double za) {
        this(world, x, y, z, xa, ya, za, 2.0f);
    }

    public HeartParticle(World world, double x, double y, double z, double xa, double ya, double za, float scale) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.xd *= 0.01;
        this.yd *= 0.01;
        this.zd *= 0.01;
        this.yd += 0.1;
        this.size *= 0.75f;
        this.size *= scale;
        this.oSize = this.size;
        this.lifetime = 16;
        this.noPhysics = false;
        this.tex = TextureRegistry.getTexture("minecraft:particle/heart");
    }

    @Override
    public void render(Tessellator t, float partialTick, double xOff, double yOff, double zOff, float xa, float ya, float za, float xa2, float za2) {
        float l = ((float)this.age + partialTick) / (float)this.lifetime * 32.0f;
        if (l < 0.0f) {
            l = 0.0f;
        }
        if (l > 1.0f) {
            l = 1.0f;
        }
        this.size = this.oSize * l;
        super.render(t, partialTick, xOff, yOff, zOff, xa, ya, za, xa2, za2);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.move(this.xd, this.yd, this.zd);
        if (this.y == this.yo) {
            this.xd *= 1.1;
            this.zd *= 1.1;
        }
        this.xd *= 0.86;
        this.yd *= 0.86;
        this.zd *= 0.86;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }
}

