/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.player;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.CompoundTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.particle.TakeAnimationParticle;
import net.minecraft.client.gui.LabelEditorScreen;
import net.minecraft.client.gui.MobPickerScreen;
import net.minecraft.client.gui.PaintingPickerScreen;
import net.minecraft.client.gui.SignEditorScreen;
import net.minecraft.client.gui.WandMobPickerScreen;
import net.minecraft.client.gui.container.ContainerScreen;
import net.minecraft.client.gui.container.CraftingScreen;
import net.minecraft.client.gui.container.DispenserScreen;
import net.minecraft.client.gui.container.FlagEditorScreen;
import net.minecraft.client.gui.container.FurnaceScreen;
import net.minecraft.client.gui.container.TrommelScreen;
import net.minecraft.client.gui.guidebook.GuidebookScreen;
import net.minecraft.client.gui.toasts.AchievementToast;
import net.minecraft.client.input.PlayerInput;
import net.minecraft.core.achievement.Achievement;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.PortalBlock;
import net.minecraft.core.block.entity.DispenserBlockEntity;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.block.entity.FurnaceBlockEntity;
import net.minecraft.core.block.entity.MobSpawnerBlockEntity;
import net.minecraft.core.block.entity.SignBlockEntity;
import net.minecraft.core.block.entity.TrommelBlockEntity;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.ClientCommandHandler;
import net.minecraft.core.net.command.ClientPlayerCommandSender;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.Commands;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.Session;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.menu.InventoryMenu;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.GetSkinUrlThread;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import org.slf4j.Logger;

public class LocalPlayer
extends Player {
    private static final Logger LOGGER = LogUtils.getLogger();
    public PlayerInput input;
    protected Minecraft mc;
    public final ClientPlayerCommandSender sender;
    protected int sprintTimer;

    public LocalPlayer(Minecraft minecraft, World world, Session session, int dimension) {
        super(world);
        this.mc = minecraft;
        this.sender = new ClientPlayerCommandSender(minecraft, this);
        this.dimension = dimension;
        this.username = session.username;
        this.uuid = session.uuid;
        new GetSkinUrlThread(this);
        LOGGER.info("logged in with session name: {}", (Object)this.username);
    }

    public float getFovModifier() {
        float f = 1.0f;
        return f *= (this.speed * 1.0f / this.baseSpeed + 1.0f) / 2.0f;
    }

    @Override
    public AABB getBb() {
        if (this.noPhysics) {
            return null;
        }
        return super.getBb();
    }

    @Override
    public void updateAI() {
        super.updateAI();
        this.moveStrafing = this.input.moveStrafe;
        this.moveForward = this.input.moveForward;
        this.isJumping = this.input.jump;
    }

    @Override
    public void setGamemode(Gamemode gamemode) {
        this.gamemode = gamemode;
        InventoryMenu newContainer = gamemode.getContainer(this.inventory, !this.world.isClientSide);
        if (this.craftingInventory == this.inventorySlots) {
            this.craftingInventory = newContainer;
        }
        this.inventorySlots = newContainer;
        if (!gamemode.canPlayerFly()) {
            this.noPhysics = false;
        }
        this.fireImmune = gamemode.isImmuneToFire();
    }

    @Override
    public void onLivingUpdate() {
        boolean canSprint;
        float f;
        if (this.sprintTimer > 0) {
            --this.sprintTimer;
        }
        AchievementToast invToast = new AchievementToast(Achievements.OPEN_INVENTORY, true);
        AchievementToast guideToast = new AchievementToast(Achievements.OPEN_GUIDEBOOK, true);
        if (!this.mc.statsCounter.isUnlocked(Achievements.OPEN_INVENTORY) && !this.mc.guiToasts.isDisplayingToast(invToast)) {
            this.mc.guiToasts.addToast(invToast);
        }
        if (!this.mc.statsCounter.isUnlocked(Achievements.OPEN_GUIDEBOOK) && !this.mc.guiToasts.isDisplayingToast(guideToast)) {
            this.mc.guiToasts.addToast(guideToast);
        }
        this.prevTimeInPortal = this.timeInPortal;
        if (this.inPortal) {
            if (!this.world.isClientSide && this.vehicle != null) {
                this.startRiding(null);
            }
            if (this.mc.currentScreen != null) {
                this.mc.displayScreen(null);
            }
            if (this.timeInPortal == 0.0f) {
                this.mc.sndManager.playSound("portal.trigger", SoundCategory.WORLD_SOUNDS, 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
            }
            this.timeInPortal += 0.0125f;
            if (this.timeInPortal >= 1.0f || this.getGamemode().instantPortalTravel()) {
                this.timeInPortal = 1.0f;
                if (!this.world.isClientSide) {
                    this.timeUntilPortal = 10;
                    this.mc.sndManager.playSound("portal.travel", SoundCategory.WORLD_SOUNDS, 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
                    int targetDim = ((PortalBlock)Block.blocksList[this.portalID]).targetDimension;
                    if (this.dimension == targetDim) {
                        this.mc.usePortal(0);
                    } else {
                        this.mc.usePortal(targetDim);
                    }
                }
            }
            this.inPortal = false;
        } else {
            if (this.timeInPortal > 0.0f) {
                this.timeInPortal -= 0.05f;
            }
            if (this.timeInPortal < 0.0f) {
                this.timeInPortal = 0.0f;
            }
        }
        if (this.timeUntilPortal > 0) {
            --this.timeUntilPortal;
        }
        boolean forwardInput = this.input.moveForward >= (f = 0.8f);
        this.input.tick(this);
        if (this.input.sneak && this.ySlideOffset < 0.45f) {
            this.ySlideOffset = 0.45f;
        }
        this.checkInTile(this.x - (double)this.bbWidth * 0.35, this.bb.minY + 0.5, this.z + (double)this.bbWidth * 0.35);
        this.checkInTile(this.x - (double)this.bbWidth * 0.35, this.bb.minY + 0.5, this.z - (double)this.bbWidth * 0.35);
        this.checkInTile(this.x + (double)this.bbWidth * 0.35, this.bb.minY + 0.5, this.z - (double)this.bbWidth * 0.35);
        this.checkInTile(this.x + (double)this.bbWidth * 0.35, this.bb.minY + 0.5, this.z + (double)this.bbWidth * 0.35);
        boolean bl = canSprint = this.world.getGameRuleValue(GameRules.ALLOW_SPRINTING) != false && !this.noPhysics;
        if (this.onGround && !forwardInput && this.input.moveForward >= f && !this.isSprinting() && canSprint) {
            if (this.sprintTimer == 0) {
                this.sprintTimer = 7;
            } else {
                this.setSprinting(true);
                this.sprintTimer = 0;
            }
        }
        if (this.onGround && canSprint && this.mc.gameSettings.keySprint.isPressed()) {
            this.setSprinting(true);
        }
        if (this.isSprinting() && (this.input.moveForward < f || this.horizontalCollision || !canSprint)) {
            this.setSprinting(false);
        }
        super.onLivingUpdate();
        if (this.mc != null) {
            this.mc.ppm.update();
        }
    }

    @Override
    public void wakeUpPlayer(boolean flag, boolean flag1) {
        super.wakeUpPlayer(flag, flag1);
        this.mc.displayScreen(null);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Score", this.score);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.score = tag.getInteger("Score");
    }

    @Override
    public void closeScreen() {
        super.closeScreen();
        this.mc.displayScreen(null);
    }

    @Override
    public void displaySignEditorScreen(SignBlockEntity blockEntity) {
        this.mc.displayScreen(new SignEditorScreen(blockEntity));
    }

    @Override
    public void displayFlagEditorScreen(FlagBlockEntity blockEntity) {
        this.mc.displayScreen(new FlagEditorScreen(this, blockEntity));
    }

    @Override
    public void displayContainerScreen(Container container) {
        this.mc.displayScreen(new ContainerScreen(this.inventory, container));
    }

    @Override
    public void displayWorkbenchScreen(int x, int y, int z) {
        this.mc.displayScreen(new CraftingScreen(this.inventory, this.world, x, y, z));
    }

    @Override
    public void displayLabelEditorScreen(ItemStack itemStack, int slot) {
        this.mc.displayScreen(new LabelEditorScreen(itemStack, slot));
    }

    @Override
    public void displayPaintingPickerScreen() {
        this.mc.displayScreen(new PaintingPickerScreen(this));
    }

    @Override
    public void displayMobPickerScreen(int x, int y, int z) {
        String currentMobId = ((MobSpawnerBlockEntity)this.world.getBlockEntity(x, y, z)).getMobId();
        this.mc.displayScreen(new MobPickerScreen(currentMobId, x, y, z));
    }

    @Override
    public void displayWandMobPickerScreen(ItemStack itemStack) {
        String currentMobId = itemStack.getData().getStringOrDefault("monster", "Pig");
        this.mc.displayScreen(new WandMobPickerScreen(currentMobId, itemStack));
    }

    @Override
    public void displayFurnaceScreen(FurnaceBlockEntity blockEntity) {
        this.mc.displayScreen(new FurnaceScreen(this.inventory, blockEntity));
    }

    @Override
    public void displayTrommelScreen(TrommelBlockEntity blockEntity) {
        this.mc.displayScreen(new TrommelScreen(this.inventory, blockEntity));
    }

    @Override
    public void displayDispenserScreen(DispenserBlockEntity blockEntity) {
        this.mc.displayScreen(new DispenserScreen(this.inventory, blockEntity));
    }

    @Override
    public void displayGuidebookScreen() {
        this.mc.displayScreen(new GuidebookScreen());
    }

    @Override
    public void onItemPickup(Entity entity, ItemStack item) {
        this.addStat(item.getItem().getStat("stat_picked_up"), 1);
        this.mc.particleEngine.add(new TakeAnimationParticle(this.mc.theWorld, entity, this, -0.5f));
    }

    public int getPlayerProtectionAmount() {
        return this.inventory.getTotalArmourPoints();
    }

    public void sendChatMessage(String s) {
        this.addToSendHistory(s);
        if (s.startsWith("/")) {
            try {
                String[] args = s.substring(1).split(" ");
                String[] args1 = new String[args.length - 1];
                System.arraycopy(args, 1, args1, 0, args.length - 1);
                ClientCommandHandler handler = this.mc.commandHandler;
                for (Command command : Commands.commands) {
                    if (!command.isName(args[0])) continue;
                    if (!this.sender.isAdmin() && command.opRequired(args1)) {
                        this.sender.sendMessage("You don't have permission to use this command!");
                        return;
                    }
                    try {
                        boolean success = command.execute(handler, this.sender, args1);
                        if (!success) {
                            command.sendCommandSyntax(handler, this.sender);
                        }
                    }
                    catch (CommandError e) {
                        this.sender.sendMessage(TextFormatting.RED + e.getMessage());
                    }
                    return;
                }
                this.sender.sendMessage(TextFormatting.RED + "Command '" + args[0] + "' does not exist!");
            }
            catch (Exception e) {
                LOGGER.error("Exception while trying to perform command '" + s + "'!", e);
                this.mc.ingameHud.addChatMessage(TextFormatting.RED + "Error!");
                this.mc.ingameHud.addChatMessage(TextFormatting.RED + e.getMessage());
            }
        } else {
            this.mc.ingameHud.addChatMessage("<" + this.getDisplayName() + TextFormatting.RESET + "> " + TextFormatting.WHITE + s);
        }
    }

    public void addToSendHistory(String msg) {
        if (msg == null || msg.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.messageHistory.size(); ++i) {
            if (!((String)this.messageHistory.get(i)).equals(msg)) continue;
            this.messageHistory.remove(i--);
        }
        this.messageHistory.add(msg);
        if (this.messageHistory.size() > 100) {
            this.messageHistory.remove(0);
        }
    }

    @Override
    public boolean isSneaking() {
        return this.input.sneak && !this.sleeping;
    }

    public void setHealth(int i) {
        int j = this.getHealth() - i;
        if (j <= 0) {
            this.setHealthRaw(i);
            if (j < 0) {
                this.heartsFlashTime = this.heartsHalvesLife / 2;
            }
        } else {
            this.lastDamage = j;
            this.prevHealth = this.getHealth();
            this.heartsFlashTime = this.heartsHalvesLife;
            this.damageEntity(j, null);
            this.maxHurtTime = 10;
            this.hurtTime = 10;
        }
    }

    @Override
    public void respawnPlayer() {
        this.mc.respawn(false, 0);
    }

    @Override
    public void animate4() {
    }

    @Override
    public void addStat(Stat stat, int i) {
        if (stat == null) {
            return;
        }
        if (stat.isAchievement()) {
            Achievement achievement = (Achievement)stat;
            if (achievement.parent == null || this.mc.statsCounter.isUnlocked(achievement.parent)) {
                if (!this.mc.statsCounter.isUnlocked(achievement)) {
                    this.mc.guiToasts.addToast(new AchievementToast(achievement, false));
                }
                this.mc.statsCounter.add(stat, i);
            }
        } else {
            this.mc.statsCounter.add(stat, i);
        }
    }

    @Override
    public int getStat(Stat stat) {
        return this.mc.statsCounter.readStat(stat);
    }

    private boolean isBlockTranslucent(int i, int j, int k) {
        return this.world.isBlockNormalCube(i, j, k);
    }

    @Override
    protected boolean checkInTile(double d, double d1, double d2) {
        if (this.noPhysics) {
            return false;
        }
        int i = MathHelper.floor(d);
        int j = MathHelper.floor(d1);
        int k = MathHelper.floor(d2);
        double d3 = d - (double)i;
        double d4 = d2 - (double)k;
        if (this.isBlockTranslucent(i, j, k) || this.isBlockTranslucent(i, j + 1, k) && !this.isDwarf) {
            boolean flag = !this.isBlockTranslucent(i - 1, j, k) && !this.isBlockTranslucent(i - 1, j + 1, k);
            boolean flag1 = !this.isBlockTranslucent(i + 1, j, k) && !this.isBlockTranslucent(i + 1, j + 1, k);
            boolean flag2 = !this.isBlockTranslucent(i, j, k - 1) && !this.isBlockTranslucent(i, j + 1, k - 1);
            boolean flag3 = !this.isBlockTranslucent(i, j, k + 1) && !this.isBlockTranslucent(i, j + 1, k + 1);
            int byte0 = -1;
            double d5 = 9999.0;
            if (flag && d3 < d5) {
                d5 = d3;
                byte0 = 0;
            }
            if (flag1 && 1.0 - d3 < d5) {
                d5 = 1.0 - d3;
                byte0 = 1;
            }
            if (flag2 && d4 < d5) {
                d5 = d4;
                byte0 = 4;
            }
            if (flag3 && 1.0 - d4 < d5) {
                double d6 = 1.0 - d4;
                byte0 = 5;
            }
            float f = 0.1f;
            if (byte0 == 0) {
                this.xd = -f;
            }
            if (byte0 == 1) {
                this.xd = f;
            }
            if (byte0 == 4) {
                this.zd = -f;
            }
            if (byte0 == 5) {
                this.zd = f;
            }
        }
        return false;
    }

    public void syncPlacementMode() {
        this.placementModeOverride = (PlacementMode)this.mc.gameSettings.placementMode.value;
    }

    @Override
    public void sendMessage(String message) {
        this.mc.ingameHud.addChatMessage(message);
    }

    @Override
    public void sendStatusMessage(String message) {
        this.mc.ingameHud.heldItemTooltipElement.setString(message);
    }
}

