/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatScreen;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.render.Scissor;
import net.minecraft.core.net.ChatEmotes;
import net.minecraft.core.util.helper.MathHelper;

public class ChatEmotePickerElement
extends Gui {
    private static final int CELL_WIDTH = 16;
    private static final int CELL_HEIGHT = 16;
    private final Minecraft mc;
    private final ChatScreen parent;
    private final int width;
    private final int height;
    private final int yCellsInner;
    private final int heightInner;
    private final int maxScroll;
    private final Map.Entry<String, Character>[][] emotes;
    private int scroll = 0;

    public ChatEmotePickerElement(Minecraft mc, ChatScreen parent, int xCells, int yCells) {
        this.mc = mc;
        this.parent = parent;
        this.width = xCells * 16;
        this.height = yCells * 16;
        this.yCellsInner = (int)Math.ceil((double)ChatEmotes.getEmotes().size() / (double)xCells);
        this.heightInner = this.yCellsInner * 16;
        this.maxScroll = this.heightInner - this.height;
        this.emotes = new Map.Entry[this.yCellsInner][xCells];
        int i = 0;
        for (Map.Entry<String, Character> entry : ChatEmotes.getEmotes().entrySet()) {
            int x = i % xCells;
            int y = i / xCells;
            this.emotes[y][x] = entry;
            ++i;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void scrollTo(int y) {
        this.scroll = y = MathHelper.clamp(y, 0, this.maxScroll);
    }

    public void scrollOffset(int offset) {
        this.scrollTo(this.scroll + offset);
    }

    public void draw(int x, int y, int mouseX, int mouseY) {
        this.drawOuter(x, y);
        Scissor.enable(x, y, this.width, this.height);
        this.drawInner(x, y, mouseX, mouseY);
        Scissor.disable();
    }

    public Character click(int mouseX, int mouseY) {
        int cellX = mouseX / 16;
        int cellY = (mouseY + this.scroll) / 16;
        if (cellY < 0 || cellY >= this.emotes.length || mouseY < 0 || mouseY >= this.height) {
            return null;
        }
        Map.Entry<String, Character>[] row = this.emotes[cellY];
        if (cellX < 0 || cellX >= row.length || mouseX < 0 || mouseX >= this.width) {
            return null;
        }
        if (row[cellX] != null) {
            return row[cellX].getValue();
        }
        return null;
    }

    private void drawOuter(int x, int y) {
        this.drawRect(x, y, x + this.width + 2, y + this.height, -16777216);
        int scrollbarHeight = this.height * this.height / this.heightInner;
        int scrollbarY = y + this.scroll * (this.height - scrollbarHeight) / this.maxScroll;
        this.drawRect(x + this.width, scrollbarY, x + this.width + 2, scrollbarY + scrollbarHeight, -8355712);
    }

    private void drawInner(int x, int y, int mouseX, int mouseY) {
        int cellX = (mouseX -= x) / 16;
        int cellY = ((mouseY -= y) + this.scroll) / 16;
        for (int cy = 0; cy < this.emotes.length; ++cy) {
            Map.Entry<String, Character>[] row = this.emotes[cy];
            for (int cx = 0; cx < row.length; ++cx) {
                int drawX = x + cx * 16;
                int drawY = y + cy * 16 - this.scroll;
                boolean mouseOver = cellX == cx && cellY == cy;
                Map.Entry<String, Character> entry = row[cx];
                if (entry == null) continue;
                this.drawCell(drawX, drawY, entry.getValue().charValue(), mouseOver);
            }
        }
    }

    private void drawCell(int x, int y, char c, boolean mouseOver) {
        int color = -1;
        if (mouseOver) {
            this.drawRect(x, y, x + 16, y + 16, -2130706433);
            color = -96;
        }
        this.drawStringCentered(this.mc.font, String.valueOf(c), x + 8, y + 4, color);
    }
}

