/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.ChatEmotePickerElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.SleepScreenMP;
import net.minecraft.client.gui.text.ITextField;
import net.minecraft.client.gui.text.TextFieldEditor;
import net.minecraft.core.net.ChatEmotes;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ChatScreen
extends Screen
implements ITextField {
    protected String message;
    private int currentIndex = 0;
    private String originalMessage;
    private int updateCounter;
    private final TextFieldEditor editor;
    protected ChatEmotePickerElement emotePicker;
    protected boolean showEmotePicker = false;

    public ChatScreen() {
        this("");
    }

    public ChatScreen(String initialMessage) {
        this.message = initialMessage;
        this.updateCounter = 0;
        this.editor = new TextFieldEditor(this);
        this.editor.setCursor(10000);
    }

    @Override
    public void init() {
        Keyboard.enableRepeatEvents(true);
        int emotePickerYCells = (int)MathHelper.clamp(Math.ceil((double)ChatEmotes.getEmotes().size() / 5.0), 0.0, 4.0);
        this.emotePicker = new ChatEmotePickerElement(this.mc, this, 5, emotePickerYCells);
        this.showEmotePicker = false;
    }

    @Override
    public void removed() {
        Keyboard.enableRepeatEvents(false);
        this.mc.ingameHud.chatScroll = 0;
    }

    @Override
    public void tick() {
        ++this.updateCounter;
        int dWheel = Mouse.getDWheel();
        if (dWheel != 0) {
            if (this.showEmotePicker) {
                this.emotePicker.scrollOffset((int)((float)(-dWheel) / 0.1f));
            } else {
                this.mc.ingameHud.chatScroll += dWheel / 1;
            }
        }
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_UP && this.mc.thePlayer.messageHistory.size() > 0) {
            if (this.currentIndex == 0) {
                this.originalMessage = this.getText();
            }
            if (this.currentIndex < this.mc.thePlayer.messageHistory.size()) {
                ++this.currentIndex;
                this.setText(this.getMessage(this.currentIndex));
                this.editor.setCursor(10000);
            }
            this.editor.setCursor(10000);
            return;
        }
        if (eventKey == Keyboard.KEY_DOWN && this.currentIndex > 0) {
            if (this.currentIndex - 1 == 0) {
                --this.currentIndex;
                this.setText(this.originalMessage);
                this.editor.setCursor(10000);
            } else {
                --this.currentIndex;
                this.setText(this.getMessage(this.currentIndex));
                this.editor.setCursor(10000);
            }
            this.editor.setCursor(10000);
            return;
        }
        if (eventKey == Keyboard.KEY_ESCAPE && !(this instanceof SleepScreenMP)) {
            this.mc.displayScreen(null);
            return;
        }
        if (eventKey == Keyboard.KEY_RETURN) {
            String s = this.message.trim();
            if (s.length() > 0) {
                String s1 = this.message.trim();
                this.mc.thePlayer.sendChatMessage(s1);
            }
            this.mc.displayScreen(null);
            return;
        }
        this.editor.handleInput(eventKey, eventCharacter);
    }

    @Override
    public void render(int xm, int ym, float partialTick) {
        int emotePickerButtonColor = Integer.MIN_VALUE;
        int emotePickerTextColor = 0xE0E0E0;
        if (xm >= 2 && xm < 14 && ym >= this.height - 14 && ym < this.height - 2) {
            emotePickerButtonColor = -2130706433;
            emotePickerTextColor = -96;
        }
        this.drawRect(2, this.height - 14, 14, this.height - 2, emotePickerButtonColor);
        this.drawStringCentered(this.font, Character.toString('\u263a'), 8, this.height - 12, emotePickerTextColor);
        this.drawRect(16, this.height - 14, this.width - 2, this.height - 2, Integer.MIN_VALUE);
        boolean drawCursor = this.updateCounter / 6 % 2 == 0;
        int cursor = this.editor.getCursor();
        this.drawString(this.font, this.message, 18, this.height - 12, 0xE0E0E0);
        if (drawCursor) {
            int width = this.font.getStringWidth(this.message);
            if (cursor < this.message.length()) {
                width = this.font.getStringWidth(this.message.substring(0, cursor));
            }
            this.drawString(this.font, "_", 18 + width, this.height - 12, 0xE0E0E0);
        }
        if (this.showEmotePicker) {
            this.emotePicker.draw(2, this.height - 16 - this.emotePicker.getHeight(), xm, ym);
        }
        super.render(xm, ym, partialTick);
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        if (buttonNum == 0) {
            Character c;
            if (mx >= 2 && mx < 14 && my >= this.height - 14 && my < this.height - 2) {
                this.showEmotePicker = !this.showEmotePicker;
                return;
            }
            if (this.showEmotePicker && (c = this.emotePicker.click(mx - 2, my - (this.height - 16 - this.emotePicker.getHeight()))) != null) {
                this.editor.handleInput(0, c.charValue());
                if (!Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) && !Keyboard.isKeyDown(Keyboard.KEY_RSHIFT)) {
                    this.showEmotePicker = false;
                }
                return;
            }
        }
    }

    @Override
    public void setText(String text) {
        this.message = text;
    }

    @Override
    public String getText() {
        return this.message;
    }

    @Override
    public int maxLength() {
        return 256;
    }

    private String getMessage(int currentIndex) {
        return (String)this.mc.thePlayer.messageHistory.get(this.mc.thePlayer.messageHistory.size() - currentIndex);
    }
}

