/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.MainMenuScreen;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.elements.ListenerButtonElement;
import net.minecraft.client.render.Scissor;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;

public class CreditsScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TOP_SPACING = 24;
    private static final int BUTTON_SPACING = 4;
    private static final String[] SONGS = new String[]{"record.cat", "record.blocks", "record.chirp", "record.far", "record.mall", "record.mellohi", "record.stal", "record.strad", "record.ward", "record.dog"};
    protected int top;
    protected int bottom;
    private float scrollAmount = 0.0f;
    private Float oldScrollAmount;
    private int scrollRegionHeight;
    private Integer clickX;
    private Integer clickY;
    private boolean playing = false;
    private List<String> lines;
    private float hue = 0.0f;

    public CreditsScreen(Screen parent) {
        super(parent);
        try (InputStream stream = MainMenuScreen.class.getResourceAsStream("/credits.txt");){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                line = line.trim();
                lines.add(line);
            }
            this.lines = lines;
        }
        catch (Exception e) {
            LOGGER.error("Exception when trying to load 'credits.txt'", e);
            this.lines = new ArrayList<String>();
            this.lines.add("An error occurred while loading the credits.");
        }
    }

    @Override
    public void init() {
        this.top = 24;
        this.bottom = this.height - 28;
        this.scrollRegionHeight = this.bottom - this.top;
        this.add(new ListenerButtonElement(0, this.width / 2 - 100, this.height - 24, 200, 20, I18n.getInstance().translateKey("gui.credits.button.done")).setActionListener(() -> {
            this.removed();
            this.mc.displayScreen(null);
        }));
        this.onScroll();
    }

    @Override
    public void tick() {
        if (!this.playing) {
            this.mc.sndManager.playMusic(SONGS[(int)(Math.random() * (double)SONGS.length)], 0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
            this.playing = true;
        }
    }

    @Override
    public void removed() {
        this.mc.sndManager.stopMusic();
    }

    @Override
    public void render(int xm, int ym, float partialTick) {
        if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL)) {
            this.scroll((float)Mouse.getDWheel() * -0.01f);
        } else {
            this.scroll((float)Mouse.getDWheel() / -0.05f);
        }
        this.renderBackground();
        this.overlayBackground(0, this.width, 0, this.top);
        this.overlayBackground(0, this.width, this.bottom, this.height);
        this.drawScrollBar(xm, ym);
        super.render(xm, ym, partialTick);
        this.font.drawCenteredString(I18n.getInstance().translateKey("gui.credits.label.title"), this.width / 2, 5, 0xFFFFFF);
        Scissor.enable(0, this.top, this.width, this.bottom - this.top);
        this.drawContent();
        Scissor.disable();
        this.hue = (this.hue + 1.0f) % 360.0f;
    }

    private void drawContent() {
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/title/mclogo.png").bind();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(this.width / 2 - 137, 30 - (int)this.scrollAmount, 0, 0, 274, 50, 0.0036496350364963502, 0.02);
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            if (line.startsWith("*")) {
                line = TextFormatting.BOLD + line.substring(1);
                int lineWidth = this.font.getStringWidth(line) + line.length();
                this.font.drawString(line, this.width / 2 - lineWidth / 2, 100 + i * 12 - (int)this.scrollAmount, 0xFFFFFF);
                continue;
            }
            if (line.startsWith("!")) {
                int rgb = Color.HSBtoRGB(this.hue / 360.0f, 1.0f, 1.0f);
                line = TextFormatting.BOLD + line.substring(1);
                int lineWidth = this.font.getStringWidth(line) + line.length();
                this.font.drawString(line, this.width / 2 - lineWidth / 2, 100 + i * 12 - (int)this.scrollAmount, rgb);
                continue;
            }
            this.font.drawString(line, this.width / 2 - this.font.getStringWidth(line) / 2, 100 + i * 12 - (int)this.scrollAmount, 0x7F7F7F);
        }
    }

    protected void drawScrollBar(int mouseX, int mouseY) {
        float totalPageHeight = this.getTotalPageHeight();
        float scrollBarHeightPercent = (float)this.scrollRegionHeight / totalPageHeight;
        if (scrollBarHeightPercent > 1.0f) {
            return;
        }
        GL11.glDisable((int)3553);
        int scrollBarX = this.width - 6;
        int scrollBarHeightPx = (int)(scrollBarHeightPercent * (float)this.scrollRegionHeight);
        if (scrollBarHeightPx < 32) {
            scrollBarHeightPx = 32;
        }
        float scrollPercent = this.scrollAmount / (totalPageHeight - (float)this.scrollRegionHeight);
        int scrollBarY = (int)((float)this.top + (float)(this.scrollRegionHeight - scrollBarHeightPx) * scrollPercent);
        Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.setColorOpaque(0, 0, 0);
        t.drawRectangle(scrollBarX, this.top, 6, this.scrollRegionHeight);
        t.setColorRGBA_I(0x808080, 255);
        t.drawRectangle(scrollBarX, scrollBarY, 6, scrollBarHeightPx);
        t.setColorRGBA_I(0xC0C0C0, 255);
        t.drawRectangle(scrollBarX + 1, scrollBarY, 5, scrollBarHeightPx - 1);
        t.draw();
        GL11.glEnable((int)3553);
        if (this.clickX != null && this.clickY != null) {
            if (this.clickX >= scrollBarX && this.clickY >= this.top && this.clickX <= scrollBarX + 6 && this.clickY < this.bottom) {
                if (this.oldScrollAmount == null) {
                    this.oldScrollAmount = Float.valueOf(this.scrollAmount);
                }
                this.scrollAmount = this.oldScrollAmount.floatValue() + (float)(this.clickY - mouseY) * (1.0f / scrollBarHeightPercent) * -1.0f;
                this.onScroll();
            }
        } else {
            this.oldScrollAmount = null;
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        this.clickX = mx;
        this.clickY = my;
    }

    @Override
    public void renderBackground() {
        super.renderBackground();
        Tessellator tessellator = Tessellator.instance;
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float scale = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x202020);
        tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, (float)(this.bottom + (int)this.scrollAmount) / scale);
        tessellator.addVertexWithUV(this.width, this.bottom, 0.0, (float)this.width / scale, (float)(this.bottom + (int)this.scrollAmount) / scale);
        tessellator.addVertexWithUV(this.width, this.top, 0.0, (float)this.width / scale, (float)(this.top + (int)this.scrollAmount) / scale);
        tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, (float)(this.top + (int)this.scrollAmount) / scale);
        tessellator.draw();
    }

    private void overlayBackground(int minX, int maxX, int minY, int maxY) {
        if (this.mc.theWorld == null) {
            Tessellator tessellator = Tessellator.instance;
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float scale = 32.0f;
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0x404040);
            tessellator.addVertexWithUV(minX, maxY, 0.0, (float)minX / scale, (float)maxY / scale);
            tessellator.addVertexWithUV(maxX, maxY, 0.0, (float)maxX / scale, (float)maxY / scale);
            tessellator.setColorOpaque_I(0x404040);
            tessellator.addVertexWithUV(maxX, minY, 0.0, (float)maxX / scale, (float)minY / scale);
            tessellator.addVertexWithUV(minX, minY, 0.0, (float)minX / scale, (float)minY / scale);
            tessellator.draw();
        }
    }

    private void scroll(float amount) {
        if (amount == 0.0f) {
            return;
        }
        this.scrollAmount += amount;
        this.onScroll();
    }

    private void onScroll() {
        int totalPageHeight = this.getTotalPageHeight();
        if (this.scrollAmount < 0.0f || this.scrollRegionHeight > totalPageHeight) {
            this.scrollAmount = 0.0f;
        } else if (this.scrollAmount > (float)(totalPageHeight - this.scrollRegionHeight)) {
            this.scrollAmount = totalPageHeight - this.scrollRegionHeight;
        }
    }

    private int getTotalPageHeight() {
        return 100 + this.lines.size() * 12;
    }

    @Override
    public void mouseReleased(int mx, int my, int buttonNum) {
        super.mouseReleased(mx, my, buttonNum);
        if (buttonNum >= 0) {
            this.clickX = null;
            this.clickY = null;
        }
    }
}

