/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.SetItemNamePacket;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class LabelEditorScreen
extends Screen {
    private static final String allowedCharacters = ChatAllowedCharacters.ALLOWED_CHARACTERS;
    protected String screenTitle = I18n.getInstance().translateKey("gui.edit_label.label.title");
    protected ItemStack item;
    protected String text;
    protected byte color;
    protected int xSize;
    protected int ySize;
    protected int slot;

    public LabelEditorScreen(ItemStack item, int slot) {
        this.item = item;
        this.text = item.hasCustomName() ? item.getCustomName() : "";
        this.color = item.getDisplayColor();
        this.xSize = 176;
        this.ySize = 166;
        this.slot = slot;
    }

    @Override
    protected void buttonClicked(ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 0) {
            this.item.setCustomName(this.text);
            this.mc.displayScreen(null);
            if (this.mc.theWorld.isClientSide) {
                this.mc.getSendQueue().addToSendQueue(new SetItemNamePacket(this.slot, this.text));
            }
        }
    }

    @Override
    public void render(int xm, int ym, float f) {
        this.renderBackground();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/scroll.png").bind();
        int widthBG = this.width / 2 - 56;
        int heightBG = 89;
        this.drawTexturedModalRect(widthBG, 89, 0, 0, 113, 34);
        this.drawStringCentered(this.font, this.screenTitle, this.width / 2, 40, 0xFFFFFF);
        this.drawStringCentered(this.font, TextFormatting.get(this.color) + "> " + this.text + " <", this.width / 2, 100, 0xFFFFFF);
        super.render(xm, ym, f);
    }

    @Override
    public void init() {
        this.buttons.clear();
        Keyboard.enableRepeatEvents(true);
        this.buttons.add(new ButtonElement(0, this.width / 2 - 100, this.height / 4 + 120, I18n.getInstance().translateKey("gui.edit_label.button.done")));
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_BACK && this.text.length() > 0) {
            this.text = this.text.substring(0, this.text.length() - 1);
        }
        if (allowedCharacters.indexOf(eventCharacter) >= 0 && this.text.length() < 15) {
            this.text = this.text + eventCharacter;
        }
        if (eventKey == Keyboard.KEY_RETURN || eventKey == Keyboard.KEY_ESCAPE) {
            this.buttonClicked((ButtonElement)this.buttons.get(0));
        }
    }

    @Override
    public void removed() {
        Keyboard.enableRepeatEvents(false);
    }
}

