/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookScreen;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.GuidebookSections;
import net.minecraft.client.gui.guidebook.PageManager;
import net.minecraft.client.gui.guidebook.RecipePage;
import net.minecraft.client.gui.guidebook.search.SearchPage;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.TextureManager;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCrafting;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShaped;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShapeless;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.slot.GuidebookSlot;
import net.minecraft.core.player.inventory.slot.Slot;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class CraftingPage
extends RecipePage<RecipeEntryCrafting<?, ?>> {
    public static final int RECIPES_PER_PAGE = 3;
    public List<GuidebookSlot> slots;
    public Map<RecipeEntryCrafting<?, ?>, List<GuidebookSlot>> map;
    private final TooltipElement tooltipElement;
    private final ItemElement itemElement;
    private static final Minecraft mc = Minecraft.getMinecraft(GuidebookPage.class);
    private static Player player;
    private static long ticks;

    public CraftingPage(GuidebookSection section, List<RecipeEntryCrafting<?, ?>> recipes) {
        super(section);
        this.recipes = recipes;
        this.slots = new ArrayList<GuidebookSlot>();
        this.map = new HashMap();
        player = CraftingPage.mc.thePlayer;
        player.addStat(Achievements.OPEN_GUIDEBOOK, 1);
        this.tooltipElement = new TooltipElement(mc);
        this.itemElement = new ItemElement(mc);
        int recipeAmount = 0;
        int xOffset = 32;
        int yOffset = 12;
        for (RecipeEntryCrafting<?, ?> recipe : recipes) {
            int centerY;
            int i;
            int slotsAmount;
            RecipeEntryCrafting r;
            ArrayList<GuidebookSlot> recipeSlots = new ArrayList<GuidebookSlot>();
            if (recipe instanceof RecipeEntryCraftingShaped) {
                RecipeSymbol stack;
                int slotY;
                r = (RecipeEntryCraftingShaped)recipe;
                if (((RecipeEntryCraftingShaped)r).recipeHeight > 2 || ((RecipeEntryCraftingShaped)r).recipeWidth > 2) {
                    slotsAmount = 10;
                    for (i = 0; i < slotsAmount - 1; ++i) {
                        int slotX = i % 3;
                        slotY = i / 3;
                        if (slotX >= ((RecipeEntryCraftingShaped)r).recipeWidth || slotY >= ((RecipeEntryCraftingShaped)r).recipeHeight) {
                            recipeSlots.add(new GuidebookSlot(i, 1 + 18 * (i % 3) + xOffset, 1 + 18 * (i / 3 + recipeAmount * 3) + yOffset, null, false, recipe));
                            continue;
                        }
                        stack = ((RecipeSymbol[])r.getInput())[slotX + slotY * ((RecipeEntryCraftingShaped)r).recipeWidth];
                        recipeSlots.add(new GuidebookSlot(i, 1 + 18 * (i % 3) + xOffset, 1 + 18 * (i / 3 + recipeAmount * 3) + yOffset, stack, false, recipe));
                    }
                    centerY = (((GuidebookSlot)recipeSlots.get((int)(recipeSlots.size() - 1))).y + ((GuidebookSlot)recipeSlots.get((int)(recipeSlots.size() - 8))).y) / 2;
                    recipeSlots.add(new GuidebookSlot(slotsAmount - 1, 81 + xOffset, centerY, new RecipeSymbol(((ItemStack)r.getOutput()).copy()), false, recipe).setAsOutput());
                    this.map.put(recipe, recipeSlots);
                    this.slots.addAll(recipeSlots);
                    yOffset += 10;
                } else {
                    slotsAmount = 5;
                    for (i = 0; i < slotsAmount - 1; ++i) {
                        int slotX = i % 2;
                        slotY = i / 2;
                        if (slotX >= ((RecipeEntryCraftingShaped)r).recipeWidth || slotY >= ((RecipeEntryCraftingShaped)r).recipeHeight) {
                            recipeSlots.add(new GuidebookSlot(i, 13 + 18 * (i % 2) + xOffset, 10 + 18 * (i / 2 + recipeAmount * 3) + yOffset, null, false, recipe));
                            continue;
                        }
                        stack = ((RecipeSymbol[])r.getInput())[slotX + slotY * ((RecipeEntryCraftingShaped)r).recipeWidth];
                        recipeSlots.add(new GuidebookSlot(i, 13 + 18 * (i % 2) + xOffset, 10 + 18 * (i / 2 + recipeAmount * 3) + yOffset, stack, false, recipe));
                    }
                    centerY = (((GuidebookSlot)recipeSlots.get((int)(recipeSlots.size() - 1))).y + ((GuidebookSlot)recipeSlots.get((int)(recipeSlots.size() - 3))).y) / 2;
                    recipeSlots.add(new GuidebookSlot(slotsAmount - 1, 81 + xOffset, centerY, new RecipeSymbol((ItemStack)r.getOutput()), false, recipe).setAsOutput());
                    this.map.put(recipe, recipeSlots);
                    this.slots.addAll(recipeSlots);
                    yOffset += 10;
                }
                ++recipeAmount;
                continue;
            }
            if (!(recipe instanceof RecipeEntryCraftingShapeless)) continue;
            r = (RecipeEntryCraftingShapeless)recipe;
            slotsAmount = 0;
            if (((List)r.getInput()).size() > 4) {
                slotsAmount = 10;
                for (i = 0; i < Math.max(((List)r.getInput()).size(), 9); ++i) {
                    if (i >= ((List)r.getInput()).size()) {
                        recipeSlots.add(new GuidebookSlot(i, 1 + 18 * (i % 3) + xOffset, 1 + 18 * (i / 3 + recipeAmount * 3) + yOffset, null, false, recipe));
                        continue;
                    }
                    RecipeSymbol stack = (RecipeSymbol)((List)r.getInput()).get(i);
                    recipeSlots.add(new GuidebookSlot(i, 1 + 18 * (i % 3) + xOffset, 1 + 18 * (i / 3 + recipeAmount * 3) + yOffset, stack, false, recipe));
                }
                centerY = (((GuidebookSlot)recipeSlots.get((int)(recipeSlots.size() - 1))).y + ((GuidebookSlot)recipeSlots.get((int)(recipeSlots.size() - 8))).y) / 2;
                recipeSlots.add(new GuidebookSlot(slotsAmount - 1, 81 + xOffset, centerY, new RecipeSymbol((ItemStack)r.getOutput()), false, recipe).setAsOutput());
                this.map.put(recipe, recipeSlots);
                this.slots.addAll(recipeSlots);
                yOffset += 10;
            } else {
                slotsAmount = 5;
                for (i = 0; i < Math.max(((List)r.getInput()).size(), 4); ++i) {
                    if (i >= ((List)r.getInput()).size()) {
                        recipeSlots.add(new GuidebookSlot(i, 13 + 18 * (i % 2) + xOffset, 10 + 18 * (i / 2 + recipeAmount * 3) + yOffset, null, false, recipe));
                        continue;
                    }
                    RecipeSymbol stack = (RecipeSymbol)((List)r.getInput()).get(i);
                    recipeSlots.add(new GuidebookSlot(i, 13 + 18 * (i % 2) + xOffset, 10 + 18 * (i / 2 + recipeAmount * 3) + yOffset, stack, false, recipe));
                }
                centerY = (((GuidebookSlot)recipeSlots.get((int)(recipeSlots.size() - 1))).y + ((GuidebookSlot)recipeSlots.get((int)(recipeSlots.size() - 3))).y) / 2;
                recipeSlots.add(new GuidebookSlot(slotsAmount - 1, 81 + xOffset, centerY, new RecipeSymbol((ItemStack)r.getOutput()), false, recipe).setAsOutput());
                this.map.put(recipe, recipeSlots);
                this.slots.addAll(recipeSlots);
                yOffset += 10;
            }
            ++recipeAmount;
        }
    }

    @Override
    protected void renderForeground(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.recipes.isEmpty()) {
            this.drawStringCenteredNoShadow(fr, "No recipes found :(", x + 79, y + 110, -8355712);
        }
        GuidebookSlot mouseOverSlot = null;
        ++ticks;
        for (GuidebookSlot slot : this.slots) {
            if (slot.item != null && !slot.isOutput) {
                slot.item.stackSize = 1;
            }
            if (ticks > 150L) {
                slot.showRandomItem();
                if (this.slots.get(this.slots.size() - 1) == slot) {
                    ticks = 0L;
                }
            }
            this.drawSlot(x + slot.x - 1, y + slot.y - 1, -1);
            if (this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            this.itemElement.render(slot.getItem(), x + slot.x, y + slot.y, mouseOverSlot == slot, slot);
        }
    }

    public boolean getIsMouseOverSlot(Slot slot, int x, int y, int mouseX, int mouseY) {
        return mouseX >= x + slot.x - 1 && mouseX < x + slot.x + 16 + 1 && mouseY >= y + slot.y - 1 && mouseY < y + slot.y + 16 + 1;
    }

    @Override
    public void keyTyped(char c, int key, int x, int y, int mouseX, int mouseY) {
        super.keyTyped(c, key, x, y, mouseX, mouseY);
        if (CraftingPage.mc.gameSettings.keyShowRecipe.isKeyboardKey(key)) {
            GuidebookSlot hoveringSlot = null;
            for (GuidebookSlot slot : this.slots) {
                if (!this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "r:" + hoveringSlot.getItem().getDisplayName() + "!";
                PageManager.searchQuery = SearchQuery.resolve(query);
                SearchPage.searchField.setText(query);
                GuidebookScreen.getPageManager().updatePages();
                GuidebookScreen.getPageManager().setCurrentPage(GuidebookScreen.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
            }
        } else if (CraftingPage.mc.gameSettings.keyShowUsage.isKeyboardKey(key)) {
            GuidebookSlot hoveringSlot = null;
            for (GuidebookSlot slot : this.slots) {
                if (!this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "u:" + hoveringSlot.getItem().getDisplayName() + "!";
                PageManager.searchQuery = SearchQuery.resolve(query);
                SearchPage.searchField.setText(query);
                GuidebookScreen.getPageManager().updatePages();
                GuidebookScreen.getPageManager().setCurrentPage(GuidebookScreen.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
            }
        }
    }

    @Override
    public void render(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.render(re, fr, x, y, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderBackground(TextureManager re, int x, int y) {
        super.renderBackground(re, x, y);
        re.bindTexture(re.loadTexture("/assets/minecraft/textures/gui/container/guidebook/guidebook.png"));
        for (int i = 1; i <= this.recipes.size(); ++i) {
            RecipeEntryCrafting recipe = (RecipeEntryCrafting)this.recipes.get(i - 1);
            List<GuidebookSlot> list = this.map.get(recipe);
            this.drawTexturedModalRect(x + list.get((int)(list.size() - 1)).x - 25, y + list.get((int)(list.size() - 1)).y, 234, 0, 22, 15);
        }
    }

    @Override
    protected void renderOverlay(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.renderOverlay(re, fr, x, y, mouseX, mouseY, partialTicks);
        GuidebookSlot mouseOverSlot = null;
        for (GuidebookSlot slot : this.slots) {
            boolean showDescription;
            if (this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (mouseOverSlot == null || !mouseOverSlot.hasItem()) continue;
            boolean bl = showDescription = Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL) || (Boolean)CraftingPage.mc.gameSettings.alwaysShowDescriptions.value != false;
            String str = this.tooltipElement.getTooltipText(mouseOverSlot.getItem(), showDescription, mouseOverSlot);
            if (str.isEmpty()) continue;
            this.tooltipElement.render(str, mouseX, mouseY, 8, -8);
        }
    }

    static {
        ticks = 0L;
    }
}

