/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.SliderElement;
import net.minecraft.client.gui.options.components.ButtonComponent;
import net.minecraft.client.option.FloatOption;

public class FloatOptionComponent
extends ButtonComponent {
    private final FloatOption option;
    private final SliderElement slider;

    public FloatOptionComponent(FloatOption option) {
        super("options." + option.name);
        this.option = option;
        this.slider = new SliderElement(0, 0, 0, 150, 20, this.option.getDisplayStringValue(), ((Float)this.option.value).floatValue());
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.slider.mouseClicked(mc, this.slider.xPosition + relativeMouseX, this.slider.yPosition + relativeMouseY);
        this.option.set(Float.valueOf(this.slider.sliderValue));
        this.slider.displayString = this.option.getDisplayStringValue();
        this.option.onUpdate();
    }

    @Override
    protected void buttonDragged(int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.option.set(Float.valueOf(this.slider.sliderValue));
        this.slider.displayString = this.option.getDisplayStringValue();
        this.option.onUpdate();
    }

    @Override
    protected void buttonReleased(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.slider.mouseReleased(this.slider.xPosition + relativeMouseX, this.slider.yPosition + relativeMouseY);
        this.option.set(Float.valueOf(this.slider.sliderValue));
        this.slider.displayString = this.option.getDisplayStringValue();
        this.option.onUpdate();
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.slider.xPosition = x + relativeButtonX;
        this.slider.yPosition = y + relativeButtonY;
        this.slider.width = buttonWidth;
        this.slider.height = buttonHeight;
        this.slider.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
    }

    @Override
    public void resetValue() {
        this.option.set((Float)this.option.getDefaultValue());
        this.slider.sliderValue = ((Float)this.option.value).floatValue();
        this.slider.displayString = this.option.getDisplayStringValue();
        this.option.onUpdate();
    }

    @Override
    public void init(Minecraft mc) {
        this.slider.sliderValue = ((Float)this.option.value).floatValue();
        this.slider.displayString = this.option.getDisplayStringValue();
    }

    @Override
    public boolean isDefault() {
        return ((Float)this.option.value).equals(this.option.getDefaultValue());
    }
}

