/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.TextFieldElement;
import net.minecraft.client.gui.options.components.OptionsCategory;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.gui.options.data.OptionsPage;
import net.minecraft.client.gui.options.data.OptionsPageRegistry;
import net.minecraft.client.gui.text.TextFieldEditor;
import net.minecraft.core.sound.SoundCategory;
import org.lwjgl.input.Keyboard;

public class SearchFieldComponent
implements OptionsComponent,
TextFieldElement.ITextChangeListener {
    private static final Minecraft mc = Minecraft.getMinecraft(SearchFieldComponent.class);
    private static final int PADDING = 4;
    private final TextFieldElement textField;
    private final TextFieldEditor editor;
    private final List<OptionsComponent> components = new ArrayList<OptionsComponent>();
    private OptionsComponent clickedComponent = null;
    private int clickedComponentY = 0;
    private ButtonElement clearButton;

    public SearchFieldComponent() {
        this.textField = new TextFieldElement(null, SearchFieldComponent.mc.font, 0, 0, 150, 18, "", "Search...");
        this.textField.setMaxStringLength(20);
        this.textField.setTextChangeListener(this);
        this.editor = new TextFieldEditor(this.textField);
        this.clearButton = new ButtonElement(0, 0, 0, 12, 20, "X");
    }

    @Override
    public void tick() {
        this.textField.updateCursorCounter();
        for (OptionsComponent component : this.components) {
            component.tick();
        }
    }

    @Override
    public int getHeight() {
        int height = 4 + this.textField.height + 4;
        for (OptionsComponent component : this.components) {
            height += component.getHeight();
        }
        return height;
    }

    @Override
    public void render(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        this.textField.xPosition = x + width / 2 - this.textField.width / 2;
        this.textField.yPosition = y + 4;
        this.textField.drawTextBox();
        this.clearButton.xPosition = x + width / 2 + this.textField.width / 2 + 1;
        this.clearButton.yPosition = y + 4 - 1;
        this.clearButton.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
        int componentY = 4 + this.textField.height + 4;
        for (OptionsComponent component : this.components) {
            component.render(x, y + componentY, width, relativeMouseX, relativeMouseY - componentY);
            componentY += component.getHeight();
        }
    }

    @Override
    public void onMouseClick(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        this.textField.mouseClicked(x + relativeMouseX, y + relativeMouseY, 0);
        if (this.clearButton.mouseClicked(mc, x + relativeMouseX, y + relativeMouseY)) {
            SearchFieldComponent.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
            this.textField.setText("");
            this.updateSearchResults("");
            return;
        }
        int componentY = 4 + this.textField.height + 4;
        for (OptionsComponent component : this.components) {
            if (relativeMouseX >= 0 && relativeMouseX < width && relativeMouseY >= componentY && relativeMouseY < componentY + component.getHeight()) {
                component.onMouseClick(mouseButton, x, componentY, width, relativeMouseX, relativeMouseY - componentY);
                this.clickedComponent = component;
                this.clickedComponentY = componentY;
                return;
            }
            componentY += component.getHeight();
        }
    }

    @Override
    public void onMouseMove(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (this.clickedComponent != null) {
            this.clickedComponent.onMouseMove(x, this.clickedComponentY, width, relativeMouseX, relativeMouseY - this.clickedComponentY);
        }
    }

    @Override
    public void onMouseRelease(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (this.clickedComponent != null) {
            this.clickedComponent.onMouseRelease(mouseButton, x, this.clickedComponentY, width, relativeMouseX, relativeMouseY - this.clickedComponentY);
        }
    }

    @Override
    public void onKeyPress(int keyCode, char character) {
        if (this.textField.isFocused && keyCode != Keyboard.KEY_ESCAPE) {
            this.textField.textboxKeyTyped(character, keyCode);
        } else if (keyCode == Keyboard.KEY_ESCAPE) {
            this.textField.setFocused(false);
        } else {
            for (OptionsComponent component : this.components) {
                component.onKeyPress(keyCode, character);
            }
        }
    }

    @Override
    public boolean matchesSearchTerm(String term) {
        return false;
    }

    @Override
    public void textChanged(TextFieldElement textField) {
        this.updateSearchResults(textField.getText());
    }

    private void updateSearchResults(String searchTerm) {
        this.components.clear();
        if (searchTerm.isEmpty()) {
            return;
        }
        for (OptionsPage page : OptionsPageRegistry.getInstance().getPages()) {
            OptionsCategory pageCategory = new OptionsCategory(page.getTranslationKey(), page.getIcon());
            boolean hasComponents = false;
            for (OptionsComponent component : page.getComponents()) {
                if (component instanceof OptionsCategory) {
                    OptionsCategory category = (OptionsCategory)component;
                    OptionsCategory filtered = category.filter(searchTerm);
                    if (filtered == null) continue;
                    pageCategory.withComponent(filtered);
                    hasComponents = true;
                    continue;
                }
                if (!component.matchesSearchTerm(searchTerm)) continue;
                pageCategory.withComponent(component);
                hasComponents = true;
            }
            if (!hasComponents) continue;
            this.components.add(pageCategory);
        }
    }
}

