/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.GLAllocation;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.command.TextFormatting;

public class FlagRenderer {
    public final int CANVAS_WIDTH = 24;
    public final int CANVAS_HEIGHT = 16;
    private final TextureManager textureManager;
    private final int texture;

    public FlagRenderer(TextureManager textureManager) {
        this.textureManager = textureManager;
        this.texture = textureManager.createTexture(24, 16);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        GLAllocation.deleteTexture(this.texture);
    }

    public void updateTexture(FlagBlockEntity tileEntity) {
        byte[] flagColors = tileEntity.flagColors;
        int[] rgbFlagColors = this.flagDataToRGB(tileEntity, flagColors);
        this.textureManager.updateTextureData(rgbFlagColors, 24, 16, this.texture);
    }

    public int getTexture() {
        return this.texture;
    }

    private int[] flagDataToRGB(FlagBlockEntity tileEntity, byte[] colorData) {
        int[] data = new int[384];
        for (int i = 0; i < 384; ++i) {
            byte color = colorData[i];
            int col = this.getColorMap(tileEntity, color);
            int alpha = col >> 24 & 0xFF;
            int red = col >> 16 & 0xFF;
            int green = col >> 8 & 0xFF;
            int blue = col >> 0 & 0xFF;
            data[i] = alpha << 24 | red << 16 | green << 8 | blue << 0;
        }
        return data;
    }

    private int getColorMap(FlagBlockEntity tileEntity, int index) {
        ItemStack stack;
        int col = 0xFFFFFF;
        if (index > 0 && index <= 3 && (stack = tileEntity.getItem(35 + index)) != null && stack.getItem() == Items.DYE) {
            col = Colors.allFlagColors[TextFormatting.get((int)(15 - stack.getMetadata())).id].getARGB();
        }
        return col;
    }
}

