/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.nio.FloatBuffer;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.PhotoModeScreen;
import net.minecraft.client.gui.modelviewer.ModelViewerScreen;
import net.minecraft.client.option.enums.RenderDistance;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.camera.CameraUtil;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class FogManager {
    public static final int FOG_MODE_SKY = -1;
    public static final int FOG_MODE_NORMAL = 0;
    public final Minecraft mc;
    public float fogRed;
    public float fogGreen;
    public float fogBlue;
    public float fogBrightnessOld;
    public float fogBrightness;
    private final FloatBuffer fogColorBuffer = GLAllocation.createDirectFloatBuffer(16);

    public FogManager(Minecraft mc) {
        this.mc = mc;
    }

    public void updateBrightness() {
        this.fogBrightnessOld = this.fogBrightness;
        float fogModifier = this.mc.theWorld.getCurrentWeather() != null ? this.mc.theWorld.getCurrentWeather().fogDistance : 1.0f;
        fogModifier = 1.0f - (1.0f - fogModifier) * this.mc.theWorld.weatherManager.getWeatherIntensity() * this.mc.theWorld.weatherManager.getWeatherPower();
        float brightnessAtCamera = this.mc.theWorld.getLightBrightness(MathHelper.floor(this.mc.activeCamera.getX(1.0f)), MathHelper.floor(this.mc.activeCamera.getY(1.0f)), MathHelper.floor(this.mc.activeCamera.getZ(1.0f)));
        if (this.mc.fullbright) {
            brightnessAtCamera = 1.0f;
        }
        float renderDistanceModifier = (float)(this.mc.gameSettings.renderDistance.highest - (Integer)this.mc.gameSettings.renderDistance.value) * fogModifier / (float)this.mc.gameSettings.renderDistance.highest;
        float newBrightness = brightnessAtCamera * (1.0f - renderDistanceModifier) + renderDistanceModifier;
        this.fogBrightness += (newBrightness - this.fogBrightness) * 0.1f;
    }

    public void setupFog(int fogMode, float farPlaneDistance, float partialTick) {
        GL11.glFogfv((int)2918, (FloatBuffer)this.buffer(this.fogRed, this.fogGreen, this.fogBlue, 0.5f));
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.theWorld, Material.water, partialTick)) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)0.1f);
        } else if (CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.theWorld, Material.lava, partialTick)) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)2.0f);
        } else {
            float maxFogDistance = RenderDistance.EXTREME.chunks * 16;
            float fogDistance = farPlaneDistance;
            float fogModifier = this.mc.theWorld.getCurrentWeather() != null ? this.mc.theWorld.getCurrentWeather().fogDistance : 1.0f;
            if (fogDistance > maxFogDistance * (fogModifier = 1.0f - (1.0f - fogModifier) * this.mc.theWorld.weatherManager.getWeatherIntensity() * this.mc.theWorld.weatherManager.getWeatherPower())) {
                fogDistance = maxFogDistance * fogModifier;
            }
            if (this.mc.currentScreen instanceof PhotoModeScreen) {
                fogDistance = farPlaneDistance * ((PhotoModeScreen)this.mc.currentScreen).getFog(partialTick);
            }
            GL11.glFogi((int)2917, (int)9729);
            GL11.glFogf((int)2915, (float)(fogDistance * 0.25f));
            GL11.glFogf((int)2916, (float)fogDistance);
            GL11.glFogf((int)2914, (float)1.0f);
            if (fogMode == -1) {
                GL11.glFogf((int)2915, (float)0.0f);
                GL11.glFogf((int)2916, (float)(fogDistance * 0.8f));
            }
            if (OpenGLHelper.enableSphericalFog) {
                GL11.glFogi((int)34138, (int)34139);
            }
            if (this.mc.theWorld.dimension == Dimension.nether) {
                GL11.glFogf((int)2915, (float)0.0f);
            }
        }
        GL11.glEnable((int)2903);
        GL11.glColorMaterial((int)1028, (int)4608);
    }

    public void updateFogColor(float partialTick) {
        World world = this.mc.theWorld;
        float renderDistanceScale = 1.0f / (float)(this.mc.gameSettings.renderDistance.highest + 1 - (Integer)this.mc.gameSettings.renderDistance.value);
        renderDistanceScale = 1.0f - (float)Math.pow(renderDistanceScale, 0.25);
        Vec3 skyColor = world.getSkyColor(this.mc.activeCamera, partialTick);
        float rSky = (float)skyColor.x;
        float gSky = (float)skyColor.y;
        float bSky = (float)skyColor.z;
        Vec3 worldColor = world.getFogColor(this.mc.activeCamera, partialTick);
        this.fogRed = (float)worldColor.x;
        this.fogGreen = (float)worldColor.y;
        this.fogBlue = (float)worldColor.z;
        this.fogRed += (rSky - this.fogRed) * renderDistanceScale;
        this.fogGreen += (gSky - this.fogGreen) * renderDistanceScale;
        this.fogBlue += (bSky - this.fogBlue) * renderDistanceScale;
        if (world.getCurrentWeather() != null) {
            float[] out = world.getCurrentWeather().modifyFogColor(this.fogRed, this.fogGreen, this.fogBlue, world.weatherManager.getWeatherIntensity() * world.weatherManager.getWeatherPower());
            this.fogRed = out[0];
            this.fogGreen = out[1];
            this.fogBlue = out[2];
        }
        if (CameraUtil.isUnderLiquid(this.mc.activeCamera, world, Material.water, partialTick)) {
            this.fogRed = 0.02f;
            this.fogGreen = 0.02f;
            this.fogBlue = 0.2f;
            if (((Boolean)this.mc.gameSettings.biomeWater.value).booleanValue()) {
                int x = MathHelper.floor(this.mc.activeCamera.getX(partialTick));
                int z = MathHelper.floor(this.mc.activeCamera.getZ(partialTick));
                double temp = world.getBlockTemperature(x, z);
                double humid = world.getBlockHumidity(x, z);
                int waterColor = Colorizers.water.getColor(temp, humid);
                float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
                float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(waterColor & 0xFF) / 255.0f;
                red = MathHelper.clamp(red, 0.0f, 1.0f);
                green = MathHelper.clamp(green, 0.0f, 1.0f);
                blue = MathHelper.clamp(blue, 0.0f, 1.0f);
                this.fogRed = red * 0.5f;
                this.fogGreen = green * 0.5f;
                this.fogBlue = blue * 0.5f;
            }
        } else if (CameraUtil.isUnderLiquid(this.mc.activeCamera, world, Material.lava, partialTick)) {
            this.fogRed = 0.6f;
            this.fogGreen = 0.1f;
            this.fogBlue = 0.0f;
        }
        float brightness = this.fogBrightnessOld + (this.fogBrightness - this.fogBrightnessOld) * partialTick;
        this.fogRed *= brightness;
        this.fogGreen *= brightness;
        this.fogBlue *= brightness;
        if (this.mc.currentScreen instanceof ModelViewerScreen) {
            float[] color = ((ModelViewerScreen)this.mc.currentScreen).getBackgroundFogColor();
            this.fogRed = color[0];
            this.fogGreen = color[1];
            this.fogBlue = color[2];
        }
        GL11.glClearColor((float)this.fogRed, (float)this.fogGreen, (float)this.fogBlue, (float)0.0f);
    }

    private FloatBuffer buffer(float r, float g, float b, float a) {
        this.fogColorBuffer.clear();
        this.fogColorBuffer.put(r).put(g).put(b).put(a);
        this.fogColorBuffer.flip();
        return this.fogColorBuffer;
    }
}

