/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.logic.PistonDirections;
import net.minecraft.core.block.piston.BasePistonBlock;
import net.minecraft.core.util.helper.Side;
import org.jetbrains.annotations.Nullable;

public class PistonBlockModel<T extends BasePistonBlock>
extends StandardBlockModel<T> {
    private final IconCoordinate faceTexture;
    protected IconCoordinate sideTexture = TextureRegistry.getTexture("minecraft:block/piston_side");
    protected IconCoordinate topTexture = TextureRegistry.getTexture("minecraft:block/piston_top");
    protected IconCoordinate bottomTexture = TextureRegistry.getTexture("minecraft:block/piston_bottom");

    public PistonBlockModel(Block block, IconCoordinate faceTexture) {
        super(block);
        this.faceTexture = faceTexture;
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        ((BasePistonBlock)this.block).setBlockBoundsBasedOnState(PistonBlockModel.renderBlocks.blockAccess, x, y, z);
        return this.renderPistonBase(tessellator, x, y, z, false);
    }

    @Override
    public boolean renderNoCulling(Tessellator tessellator, int x, int y, int z) {
        PistonBlockModel.renderBlocks.renderAllFaces = true;
        boolean result = this.renderPistonBase(tessellator, x, y, z, true);
        PistonBlockModel.renderBlocks.renderAllFaces = false;
        return result;
    }

    protected boolean renderPistonBase(Tessellator tessellator, int i, int j, int k, boolean flag) {
        int l = PistonBlockModel.renderBlocks.blockAccess.getBlockMetadata(i, j, k);
        boolean flag1 = flag || (l & 8) != 0;
        int i1 = BasePistonBlock.getDirection(l);
        if (flag1) {
            switch (i1) {
                case 0: {
                    PistonBlockModel.renderBlocks.uvRotateEast = 3;
                    PistonBlockModel.renderBlocks.uvRotateWest = 3;
                    PistonBlockModel.renderBlocks.uvRotateSouth = 3;
                    PistonBlockModel.renderBlocks.uvRotateNorth = 3;
                    ((BasePistonBlock)this.block).setBlockBounds(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case 1: {
                    ((BasePistonBlock)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
                    break;
                }
                case 2: {
                    PistonBlockModel.renderBlocks.uvRotateSouth = 1;
                    PistonBlockModel.renderBlocks.uvRotateNorth = 2;
                    ((BasePistonBlock)this.block).setBlockBounds(0.0, 0.0, 0.25, 1.0, 1.0, 1.0);
                    break;
                }
                case 3: {
                    PistonBlockModel.renderBlocks.uvRotateSouth = 2;
                    PistonBlockModel.renderBlocks.uvRotateNorth = 1;
                    PistonBlockModel.renderBlocks.uvRotateTop = 3;
                    PistonBlockModel.renderBlocks.uvRotateBottom = 3;
                    ((BasePistonBlock)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.75);
                    break;
                }
                case 4: {
                    PistonBlockModel.renderBlocks.uvRotateEast = 1;
                    PistonBlockModel.renderBlocks.uvRotateWest = 2;
                    PistonBlockModel.renderBlocks.uvRotateTop = 2;
                    PistonBlockModel.renderBlocks.uvRotateBottom = 1;
                    ((BasePistonBlock)this.block).setBlockBounds(0.25, 0.0, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case 5: {
                    PistonBlockModel.renderBlocks.uvRotateEast = 2;
                    PistonBlockModel.renderBlocks.uvRotateWest = 1;
                    PistonBlockModel.renderBlocks.uvRotateTop = 1;
                    PistonBlockModel.renderBlocks.uvRotateBottom = 2;
                    ((BasePistonBlock)this.block).setBlockBounds(0.0, 0.0, 0.0, 0.75, 1.0, 1.0);
                }
            }
            this.renderStandardBlock(tessellator, this.block, i, j, k);
            this.resetRenderBlocks();
            ((BasePistonBlock)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        } else {
            switch (i1) {
                case 0: {
                    PistonBlockModel.renderBlocks.uvRotateEast = 3;
                    PistonBlockModel.renderBlocks.uvRotateWest = 3;
                    PistonBlockModel.renderBlocks.uvRotateSouth = 3;
                    PistonBlockModel.renderBlocks.uvRotateNorth = 3;
                    break;
                }
                case 2: {
                    PistonBlockModel.renderBlocks.uvRotateSouth = 1;
                    PistonBlockModel.renderBlocks.uvRotateNorth = 2;
                    break;
                }
                case 3: {
                    PistonBlockModel.renderBlocks.uvRotateSouth = 2;
                    PistonBlockModel.renderBlocks.uvRotateNorth = 1;
                    PistonBlockModel.renderBlocks.uvRotateTop = 3;
                    PistonBlockModel.renderBlocks.uvRotateBottom = 3;
                    break;
                }
                case 4: {
                    PistonBlockModel.renderBlocks.uvRotateEast = 1;
                    PistonBlockModel.renderBlocks.uvRotateWest = 2;
                    PistonBlockModel.renderBlocks.uvRotateTop = 2;
                    PistonBlockModel.renderBlocks.uvRotateBottom = 1;
                    break;
                }
                case 5: {
                    PistonBlockModel.renderBlocks.uvRotateEast = 2;
                    PistonBlockModel.renderBlocks.uvRotateWest = 1;
                    PistonBlockModel.renderBlocks.uvRotateTop = 1;
                    PistonBlockModel.renderBlocks.uvRotateBottom = 2;
                }
            }
            this.renderStandardBlock(tessellator, this.block, i, j, k);
            this.resetRenderBlocks();
        }
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        super.renderBlockOnInventory(tessellator, 1, brightness, alpha, lightmapCoordinate);
    }

    public IconCoordinate getFaceTexture() {
        return this.faceTexture;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int direction = BasePistonBlock.getDirection(data);
        if (direction > 5) {
            return this.atlasIndices[0];
        }
        if (side.getId() == direction) {
            if (BasePistonBlock.isPowered(data) || ((BasePistonBlock)this.block).minX > 0.0 || ((BasePistonBlock)this.block).minY > 0.0 || ((BasePistonBlock)this.block).minZ > 0.0 || ((BasePistonBlock)this.block).maxX < 1.0 || ((BasePistonBlock)this.block).maxY < 1.0 || ((BasePistonBlock)this.block).maxZ < 1.0) {
                return this.topTexture;
            }
            return this.atlasIndices[0];
        }
        return side.getId() != PistonDirections.directionMap[direction] ? this.sideTexture : this.bottomTexture;
    }
}

