/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.PhotoModeScreen;
import net.minecraft.client.render.shader.ShaderProvider;
import net.minecraft.client.render.shader.ShaderProviderInternal;
import net.minecraft.client.render.shader.Shaders;
import net.minecraft.client.render.shader.ShadersRenderer;

public class PhotoModeRenderer
extends ShadersRenderer {
    public static final String[] shaders = new String[]{null, "blur", "silhouette", "vignette", "tiltshift", "outline", "outline2", "eerie", "sepia", "inverted", "distantblur"};
    public final PhotoModeScreen screen;
    private int selectedShader = 0;

    public PhotoModeRenderer(Minecraft minecraft, PhotoModeScreen screen) {
        super(minecraft);
        this.screen = screen;
        if (!Shaders.enableShaders) {
            throw new RuntimeException("Shaders disabled!");
        }
    }

    @Override
    public ShaderProvider getShader() {
        if (this.selectedShader > 0) {
            return new ShaderProviderInternal("/shaders/photo/" + this.getActiveShader() + "/");
        }
        return this.internal;
    }

    public void next() {
        this.selectedShader = (this.selectedShader + 1) % shaders.length;
        this.reload();
    }

    public void first() {
        this.selectedShader = 0;
        this.reload();
    }

    public String getActiveShader() {
        return shaders[this.selectedShader];
    }
}

