/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import com.b100.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.ToolShearsItem;
import net.minecraft.core.item.block.BlockItem;
import net.minecraft.core.sound.BlockSound;
import net.minecraft.core.sound.BlockSounds;
import net.minecraft.core.util.HardIllegalArgumentException;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.BoundingVolume;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Block
implements ITaggable<Block>,
IItemConvertible {
    public static final @Nullable Block @NotNull [] blocksList = new Block[16384];
    public static final Map<NamespaceID, Block> blockMap = new LinkedHashMap<NamespaceID, Block>();
    public static final boolean[] shouldTick = new boolean[blocksList.length];
    public static final boolean[] solid = new boolean[blocksList.length];
    public static final boolean[] isEntityTile = new boolean[blocksList.length];
    public static final int[] lightBlock = new int[blocksList.length];
    public static final boolean[] translucent = new boolean[blocksList.length];
    public static final int[] lightEmission = new int[blocksList.length];
    public static final boolean[] neighborNotifyOnMetadataChangeDisabled = new boolean[blocksList.length];
    public static final Map<String, Integer> keyToIdMap = new HashMap<String, Integer>();
    public static int highestBlockId = 0;
    public final int id;
    public final NamespaceID namespaceID;
    protected float blockHardness;
    protected float blastResistance;
    protected boolean blockConstructorCalled = true;
    protected boolean enableStats = true;
    protected boolean isLitInteriorSurface;
    public double minX;
    public double minY;
    public double minZ;
    public double maxX;
    public double maxY;
    public double maxZ;
    public float blockParticleGravity = 1.0f;
    public final Material blockMaterial;
    public float friction = 0.6f;
    protected String key;
    public int dropOverride = -1;
    public boolean immovable = false;
    public MaterialColor overrideColor;
    private BlockSound blockSound = BlockSounds.DEFAULT;
    @Nullable Supplier<@NotNull IItemConvertible> statParent = null;
    @NotNull
    public Supplier<Item> blockItemSupplier = () -> new BlockItem(this);

    public Block(String translationKey, String namespaceId, int id, Material material) {
        this.id = id;
        try {
            this.namespaceID = new NamespaceID(namespaceId);
        }
        catch (HardIllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        if (blocksList[id] != null) {
            throw new IllegalArgumentException("Block slot '" + id + "' is already occupied by '" + blocksList[id] + "' when adding " + this);
        }
        if (blockMap.containsKey(this.namespaceID)) {
            throw new IllegalArgumentException("Block id '" + this.namespaceID + "' is already used by '" + blockMap.get(this.namespaceID) + "' when adding " + this);
        }
        this.blockMaterial = material;
        Block.blocksList[id] = this;
        blockMap.put(this.namespaceID, this);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        Block.solid[id] = this.isSolidRender();
        Block.lightBlock[id] = this.isSolidRender() || this.blocksLight() ? 255 : 0;
        Block.translucent[id] = !material.blocksLight();
        Block.isEntityTile[id] = false;
        this.setKey(translationKey);
        if (highestBlockId < id) {
            highestBlockId = id;
        }
    }

    public Block withDisabledNeighborNotifyOnMetadataChange() {
        Block.neighborNotifyOnMetadataChangeDisabled[this.id] = true;
        return this;
    }

    protected void initializeBlock() {
    }

    public Block withLightBlock(int blockAmount) {
        Block.lightBlock[this.id] = blockAmount;
        return this;
    }

    public Block withLightEmission(float lightEmission) {
        Block.lightEmission[this.id] = (int)(15.0f * lightEmission);
        return this;
    }

    public Block withLightEmission(int lightEmission) {
        Block.lightEmission[this.id] = lightEmission & 0xF;
        return this;
    }

    public Block withImmovableFlagSet() {
        this.immovable = true;
        return this;
    }

    public Block withBlastResistance(float blastResistance) {
        this.blastResistance = blastResistance * 3.0f;
        return this;
    }

    public Block withSound(BlockSound sound) {
        this.blockSound = sound;
        return this;
    }

    public BlockSound getSound() {
        return this.blockSound;
    }

    public boolean isCubeShaped() {
        return true;
    }

    public boolean canPlaceOnSurface() {
        return this.isCubeShaped();
    }

    public boolean canPlaceOnSurfaceOnCondition(World world, int x, int y, int z) {
        return this.canPlaceOnSurface();
    }

    public boolean renderAsNormalBlockOnCondition(World world, int x, int y, int z) {
        return this.isCubeShaped();
    }

    public boolean canPlaceOnSurfaceOfBlock(World world, int x, int y, int z) {
        return this.canPlaceOnSurface();
    }

    public Block withHardness(float blockHardness) {
        this.blockHardness = blockHardness;
        if (this.blastResistance < blockHardness * 5.0f) {
            this.blastResistance = blockHardness * 5.0f;
        }
        return this;
    }

    public Block setDropOverride(int dropId) {
        this.dropOverride = dropId;
        return this;
    }

    public Block withLitInteriorSurface(boolean isLit) {
        this.isLitInteriorSurface = isLit;
        return this;
    }

    public Block withSetUnbreakable() {
        this.withHardness(-1.0f);
        return this;
    }

    public Block setBlockItem(@NotNull Supplier<Item> itemSupplier) {
        this.blockItemSupplier = itemSupplier;
        return this;
    }

    public Block setBlockItem(@NotNull Function<Block, Item> itemSupplier) {
        this.blockItemSupplier = () -> (Item)itemSupplier.apply(this);
        return this;
    }

    public Block withOverrideColor(MaterialColor color) {
        this.overrideColor = color;
        return this;
    }

    public Block setStatParent(@NotNull @NotNull Supplier<@NotNull IItemConvertible> icon) {
        this.statParent = icon;
        return this;
    }

    public float getHardness() {
        return this.blockHardness;
    }

    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        if (dropCause != EnumDropCause.IMPROPER_TOOL) {
            return new ItemStack[]{new ItemStack(this)};
        }
        return null;
    }

    public Block setTicking(boolean tick) {
        Block.shouldTick[this.id] = tick;
        return this;
    }

    public void setBlockBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public float getBlockBrightness(WorldSource blockAccess, int x, int y, int z) {
        return blockAccess.getBrightness(x, y, z, lightEmission[this.id]);
    }

    public int getLightmapCoord(WorldSource blockAccess, int x, int y, int z) {
        return blockAccess.getLightmapCoord(x, y, z, lightEmission[this.id]);
    }

    public float getAmbientOcclusionStrength(WorldSource blockAccess, int x, int y, int z) {
        return this.isSolidRender() ? 1.0f : 0.0f;
    }

    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        Side side1 = Side.getSideById(side);
        if (side1 == Side.BOTTOM && this.minY > 0.0) {
            return true;
        }
        if (side1 == Side.TOP && this.maxY < 1.0) {
            return true;
        }
        if (side1 == Side.NORTH && this.minZ > 0.0) {
            return true;
        }
        if (side1 == Side.SOUTH && this.maxZ < 1.0) {
            return true;
        }
        if (side1 == Side.WEST && this.minX > 0.0) {
            return true;
        }
        if (side1 == Side.EAST && this.maxX < 1.0) {
            return true;
        }
        return !blockAccess.isBlockOpaqueCube(x, y, z);
    }

    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side, int meta) {
        return this.shouldSideBeRendered(blockAccess, x, y, z, side);
    }

    public boolean getIsBlockSolid(WorldSource blockAccess, int x, int y, int z, Side side) {
        return blockAccess.getBlockMaterial(x, y, z).isSolid();
    }

    public AABB getSelectedBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return AABB.getTemporaryBB((double)x + this.minX, (double)y + this.minY, (double)z + this.minZ, (double)x + this.maxX, (double)y + this.maxY, (double)z + this.maxZ);
    }

    public BoundingVolume getBoundingVolume(World world, int x, int y, int z) {
        return null;
    }

    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AABB aabb, ArrayList<AABB> aabbList) {
        AABB aabbFromPool = this.getCollisionBoundingBoxFromPool(world, x, y, z);
        if (aabbFromPool != null && aabb.intersects(aabbFromPool)) {
            aabbList.add(aabbFromPool);
        }
    }

    public boolean collidesWithEntity(Entity entity, World world, int x, int y, int z) {
        return true;
    }

    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return AABB.getTemporaryBB((double)x + this.minX, (double)y + this.minY, (double)z + this.minZ, (double)x + this.maxX, (double)y + this.maxY, (double)z + this.maxZ);
    }

    public MaterialColor getMaterialColor() {
        if (this.overrideColor != null) {
            return this.overrideColor;
        }
        return this.blockMaterial.color;
    }

    public boolean isSolidRender() {
        return true;
    }

    public boolean blocksLight() {
        return false;
    }

    public boolean canCollideCheck(int meta, boolean shouldCollideWithFluids) {
        return this.isCollidable();
    }

    public boolean isCollidable() {
        return true;
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
    }

    public void animationTick(World world, int x, int y, int z, Random rand) {
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
    }

    public int tickDelay() {
        return 10;
    }

    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
    }

    public void onBlockRemoved(World world, int x, int y, int z, int data) {
    }

    public void onBlockDestroyedByPlayer(World world, int x, int y, int z, Side side, int meta, Player player, Item item) {
    }

    public boolean renderFullbright() {
        return false;
    }

    public float blockStrength(Player player) {
        if (this.blockHardness < 0.0f) {
            return 0.0f;
        }
        if (!player.canHarvestBlock(this)) {
            return 1.0f / this.blockHardness / 100.0f;
        }
        return player.getCurrentPlayerStrVsBlock(this) / this.blockHardness / 30.0f;
    }

    public boolean getImmovable() {
        return this.immovable;
    }

    public float getBlastResistance(Entity entity) {
        return this.blastResistance / 5.0f;
    }

    public HitResult collisionRayTrace(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        start = start.add(-x, -y, -z);
        end = end.add(-x, -y, -z);
        Vec3 vec32 = start.clipX(end, this.minX);
        Vec3 vec3d3 = start.clipX(end, this.maxX);
        Vec3 vec34 = start.clipY(end, this.minY);
        Vec3 vec35 = start.clipY(end, this.maxY);
        Vec3 vec36 = start.clipZ(end, this.minZ);
        Vec3 vec37 = start.clipZ(end, this.maxZ);
        if (!this.isVecInsideYZBounds(vec32)) {
            vec32 = null;
        }
        if (!this.isVecInsideYZBounds(vec3d3)) {
            vec3d3 = null;
        }
        if (!this.isVecInsideXZBounds(vec34)) {
            vec34 = null;
        }
        if (!this.isVecInsideXZBounds(vec35)) {
            vec35 = null;
        }
        if (!this.isVecInsideXYBounds(vec36)) {
            vec36 = null;
        }
        if (!this.isVecInsideXYBounds(vec37)) {
            vec37 = null;
        }
        Vec3 vec38 = null;
        if (vec32 != null && (vec38 == null || start.distanceToSquared(vec32) < start.distanceToSquared(vec38))) {
            vec38 = vec32;
        }
        if (vec3d3 != null && (vec38 == null || start.distanceToSquared(vec3d3) < start.distanceToSquared(vec38))) {
            vec38 = vec3d3;
        }
        if (vec34 != null && (vec38 == null || start.distanceToSquared(vec34) < start.distanceToSquared(vec38))) {
            vec38 = vec34;
        }
        if (vec35 != null && (vec38 == null || start.distanceToSquared(vec35) < start.distanceToSquared(vec38))) {
            vec38 = vec35;
        }
        if (vec36 != null && (vec38 == null || start.distanceToSquared(vec36) < start.distanceToSquared(vec38))) {
            vec38 = vec36;
        }
        if (vec37 != null && (vec38 == null || start.distanceToSquared(vec37) < start.distanceToSquared(vec38))) {
            vec38 = vec37;
        }
        if (vec38 == null) {
            return null;
        }
        Side side = Side.NONE;
        if (vec38 == vec32) {
            side = Side.WEST;
        }
        if (vec38 == vec3d3) {
            side = Side.EAST;
        }
        if (vec38 == vec34) {
            side = Side.BOTTOM;
        }
        if (vec38 == vec35) {
            side = Side.TOP;
        }
        if (vec38 == vec36) {
            side = Side.NORTH;
        }
        if (vec38 == vec37) {
            side = Side.SOUTH;
        }
        return new HitResult(x, y, z, side, vec38.add(x, y, z));
    }

    private boolean isVecInsideYZBounds(Vec3 vec3) {
        if (vec3 == null) {
            return false;
        }
        return vec3.y >= this.minY && vec3.y <= this.maxY && vec3.z >= this.minZ && vec3.z <= this.maxZ;
    }

    private boolean isVecInsideXZBounds(Vec3 vec3) {
        if (vec3 == null) {
            return false;
        }
        return vec3.x >= this.minX && vec3.x <= this.maxX && vec3.z >= this.minZ && vec3.z <= this.maxZ;
    }

    private boolean isVecInsideXYBounds(Vec3 vec3) {
        if (vec3 == null) {
            return false;
        }
        return vec3.x >= this.minX && vec3.x <= this.maxX && vec3.y >= this.minY && vec3.y <= this.maxY;
    }

    public void onBlockDestroyedByExplosion(World world, int x, int y, int z) {
    }

    public int getRenderLayer() {
        return 0;
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, Side side) {
        return this.canPlaceBlockAt(world, x, y, z);
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.canPlaceInsideBlock(x, y, z);
    }

    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        return false;
    }

    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
    }

    public void onBlockLeftClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
    }

    public void handleEntityInside(World world, int x, int y, int z, Entity entity, Vec3 entityVelocity) {
    }

    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
    }

    public void setBlockBoundsBasedOnSide(WorldSource world, int x, int y, int z, Side side) {
    }

    public boolean getSignal(WorldSource blockAccess, int x, int y, int z, Side side) {
        return false;
    }

    public boolean isSignalSource() {
        return false;
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
    }

    public boolean getDirectSignal(World world, int x, int y, int z, Side side) {
        return false;
    }

    public void harvestBlock(World world, Player player, int x, int y, int z, int meta, BlockEntity blockEntity) {
        Item heldItem;
        player.addStat(this.getStat("stat_mined"), 1);
        ItemStack heldItemStack = player.inventory.getCurrentItem();
        Item item = heldItem = heldItemStack != null ? Item.itemsList[heldItemStack.itemID] : null;
        if (heldItem != null) {
            if (heldItem.isSilkTouch() && player.canHarvestBlock(this)) {
                this.dropBlockWithCause(world, EnumDropCause.SILK_TOUCH, x, y, z, meta, blockEntity, player);
                return;
            }
            if (heldItem instanceof ToolShearsItem && (this.hasTag(BlockTags.SHEARS_DO_SILK_TOUCH) || this.hasTag(BlockTags.MINEABLE_BY_SHEARS))) {
                ToolShearsItem heldShears = (ToolShearsItem)heldItem;
                this.dropBlockWithCause(world, EnumDropCause.SILK_TOUCH, x, y, z, meta, blockEntity, player);
                heldShears.onBlockSheared(player, heldItemStack);
                return;
            }
        }
        if (player.canHarvestBlock(this)) {
            this.dropBlockWithCause(world, EnumDropCause.PROPER_TOOL, x, y, z, meta, blockEntity, player);
        } else {
            this.dropBlockWithCause(world, EnumDropCause.IMPROPER_TOOL, x, y, z, meta, blockEntity, player);
        }
    }

    @Nullable
    public Stat getStat(String statID) {
        return this.asItem().getStat(statID);
    }

    public void dropBlockWithCause(World world, EnumDropCause cause, int x, int y, int z, int meta, BlockEntity blockEntity, Player player) {
        if (world.isClientSide) {
            return;
        }
        ItemStack[] drops = this.getBreakResult(world, cause, x, y, z, meta, blockEntity);
        if (this.dropOverride > 0) {
            drops = new ItemStack[]{Item.itemsList[this.dropOverride].getDefaultStack()};
        }
        if (drops != null && drops.length > 0) {
            for (ItemStack drop : drops) {
                if (drop == null) continue;
                if (this.hasTag(BlockTags.INSTANT_PICKUP) && player != null) {
                    player.inventory.insertItem(drop, true);
                    if (drop.stackSize <= 0) continue;
                }
                if (ItemEntity.enableItemClumping) {
                    world.dropItem(x, y, z, drop.copy());
                    continue;
                }
                for (int i = 0; i < drop.stackSize; ++i) {
                    ItemStack drop1 = drop.copy();
                    drop1.stackSize = 1;
                    world.dropItem(x, y, z, drop1);
                }
            }
        }
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        return true;
    }

    public void onBlockPlacedByMob(World world, int x, int y, int z, Side side, Mob mob, double sideHeight) {
    }

    public void setKey(String key) {
        this.key = "tile." + key;
        keyToIdMap.put(this.key, this.id);
    }

    public String getKey() {
        return this.key;
    }

    public String getLanguageKey(int meta) {
        return this.getKey();
    }

    public void triggerEvent(World world, int x, int y, int z, int index, int data) {
    }

    public boolean getEnableStats() {
        return this.enableStats && this.getHardness() >= 0.0f;
    }

    public Block withDisabledStats() {
        this.enableStats = false;
        return this;
    }

    public int getPistonPushReaction() {
        return this.blockMaterial.getPushReaction();
    }

    public int getPlacedBlockMetadata(Player player, ItemStack stack, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        return 0;
    }

    public static boolean isBuried(World world, int x, int y, int z) {
        boolean buried = true;
        if (lightBlock[world.getBlockId(x + 1, y, z)] <= 2) {
            buried = false;
        }
        if (lightBlock[world.getBlockId(x - 1, y, z)] <= 2) {
            buried = false;
        }
        if (lightBlock[world.getBlockId(x, y, z + 1)] <= 2) {
            buried = false;
        }
        if (lightBlock[world.getBlockId(x, y, z - 1)] <= 2) {
            buried = false;
        }
        if (lightBlock[world.getBlockId(x, y + 1, z)] <= 2) {
            buried = false;
        }
        if (lightBlock[world.getBlockId(x, y - 1, z)] <= 2) {
            buried = false;
        }
        return buried;
    }

    public static boolean getIsLitInteriorSurface(World world, int x, int y, int z) {
        int l = world.getBlockId(x, y, z);
        return l != 0 && blocksList[l] != null && Block.blocksList[l].isLitInteriorSurface;
    }

    @SafeVarargs
    public final Block withTags(Tag<Block> ... tags) {
        for (Tag<Block> tag : tags) {
            tag.tag(this);
        }
        return this;
    }

    public boolean hasTag(Tag<Block> tag) {
        return tag.appliesTo(this);
    }

    public static boolean hasTag(int id, Tag<Block> tag) {
        if (id < 0) {
            return false;
        }
        Block block = blocksList[id];
        if (block == null) {
            return false;
        }
        return block.hasTag(tag);
    }

    public boolean isClimbable(World world, int x, int y, int z) {
        return false;
    }

    @Nullable
    public static Block getBlock(int id) {
        return blocksList[Math.max(id, 0)];
    }

    public static Block getBlockByName(String name) {
        Utils.requireNonNull(name);
        if (name.startsWith("tile.")) {
            name = name.substring(5);
        }
        for (Block block : blocksList) {
            String otherName;
            if (block == null || !name.equalsIgnoreCase(otherName = block.key.substring(5))) continue;
            return block;
        }
        return null;
    }

    @Override
    public boolean isIn(Tag<Block> tag) {
        return tag.appliesTo(this);
    }

    @Override
    public Item asItem() {
        return Item.itemsList[this.id];
    }

    @Override
    public ItemStack getDefaultStack() {
        return new ItemStack(this);
    }
}

