/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.BedBlock;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.chunk.ChunkPosition;

public class RedstoneWireBlock
extends Block {
    private boolean wiresProvidePower = true;
    private final Set<ChunkPosition> chunkPositionSet = new HashSet<ChunkPosition>();

    public RedstoneWireBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.decoration);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z);
    }

    private void updateAndPropagateCurrentStrength(World world, int x, int y, int z) {
        this.func_21030_a(world, x, y, z, x, y, z);
        ArrayList<ChunkPosition> arraylist = new ArrayList<ChunkPosition>(this.chunkPositionSet);
        this.chunkPositionSet.clear();
        for (ChunkPosition chunkposition : arraylist) {
            world.notifyBlocksOfNeighborChange(chunkposition.x, chunkposition.y, chunkposition.z, this.id);
        }
    }

    private void func_21030_a(World world, int x, int y, int z, int l, int i1, int j1) {
        int meta = world.getBlockMetadata(x, y, z);
        int l1 = 0;
        this.wiresProvidePower = false;
        boolean flag = world.isBlockIndirectlyGettingPowered(x, y, z);
        this.wiresProvidePower = true;
        if (flag) {
            l1 = 15;
        } else {
            for (int i2 = 0; i2 < 4; ++i2) {
                int k2 = x;
                int i3 = z;
                if (i2 == 0) {
                    --k2;
                }
                if (i2 == 1) {
                    ++k2;
                }
                if (i2 == 2) {
                    --i3;
                }
                if (i2 == 3) {
                    ++i3;
                }
                if (k2 != l || y != i1 || i3 != j1) {
                    l1 = this.getMaxCurrentStrength(world, k2, y, i3, l1);
                }
                if (world.isBlockNormalCube(k2, y, i3) && !world.isBlockNormalCube(x, y + 1, z)) {
                    if (k2 == l && y + 1 == i1 && i3 == j1) continue;
                    l1 = this.getMaxCurrentStrength(world, k2, y + 1, i3, l1);
                    continue;
                }
                if (world.isBlockNormalCube(k2, y, i3) || k2 == l && y - 1 == i1 && i3 == j1) continue;
                l1 = this.getMaxCurrentStrength(world, k2, y - 1, i3, l1);
            }
            l1 = l1 > 0 ? --l1 : 0;
        }
        if (meta != l1) {
            world.editingBlocks = true;
            world.setBlockMetadataWithNotify(x, y, z, l1);
            world.markBlocksDirty(x, y, z, x, y, z);
            world.editingBlocks = false;
            for (int j2 = 0; j2 < 4; ++j2) {
                int l2 = x;
                int j3 = z;
                int k3 = y - 1;
                if (j2 == 0) {
                    --l2;
                }
                if (j2 == 1) {
                    ++l2;
                }
                if (j2 == 2) {
                    --j3;
                }
                if (j2 == 3) {
                    ++j3;
                }
                if (world.isBlockNormalCube(l2, y, j3)) {
                    k3 += 2;
                }
                int l3 = 0;
                l3 = this.getMaxCurrentStrength(world, l2, y, j3, -1);
                l1 = world.getBlockMetadata(x, y, z);
                if (l1 > 0) {
                    --l1;
                }
                if (l3 >= 0 && l3 != l1) {
                    this.func_21030_a(world, l2, y, j3, x, y, z);
                }
                l3 = this.getMaxCurrentStrength(world, l2, k3, j3, -1);
                l1 = world.getBlockMetadata(x, y, z);
                if (l1 > 0) {
                    --l1;
                }
                if (l3 < 0 || l3 == l1) continue;
                this.func_21030_a(world, l2, k3, j3, x, y, z);
            }
            if (meta == 0 || l1 == 0) {
                this.chunkPositionSet.add(new ChunkPosition(x, y, z));
                this.chunkPositionSet.add(new ChunkPosition(x - 1, y, z));
                this.chunkPositionSet.add(new ChunkPosition(x + 1, y, z));
                this.chunkPositionSet.add(new ChunkPosition(x, y - 1, z));
                this.chunkPositionSet.add(new ChunkPosition(x, y + 1, z));
                this.chunkPositionSet.add(new ChunkPosition(x, y, z - 1));
                this.chunkPositionSet.add(new ChunkPosition(x, y, z + 1));
            }
        }
    }

    private void notifyWireNeighborsOfNeighborChange(World world, int x, int y, int z) {
        if (world.getBlockId(x, y, z) == this.id) {
            world.notifyBlocksOfNeighborChange(x, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
            world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
        }
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        super.onBlockPlacedByWorld(world, x, y, z);
        if (world.isClientSide) {
            return;
        }
        this.updateAndPropagateCurrentStrength(world, x, y, z);
        world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
        world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
        this.notifyWireNeighborsOfNeighborChange(world, x - 1, y, z);
        this.notifyWireNeighborsOfNeighborChange(world, x + 1, y, z);
        this.notifyWireNeighborsOfNeighborChange(world, x, y, z - 1);
        this.notifyWireNeighborsOfNeighborChange(world, x, y, z + 1);
        if (world.isBlockNormalCube(x - 1, y, z)) {
            this.notifyWireNeighborsOfNeighborChange(world, x - 1, y + 1, z);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, x - 1, y - 1, z);
        }
        if (world.isBlockNormalCube(x + 1, y, z)) {
            this.notifyWireNeighborsOfNeighborChange(world, x + 1, y + 1, z);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, x + 1, y - 1, z);
        }
        if (world.isBlockNormalCube(x, y, z - 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, x, y + 1, z - 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, x, y - 1, z - 1);
        }
        if (world.isBlockNormalCube(x, y, z + 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, x, y + 1, z + 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, x, y - 1, z + 1);
        }
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        super.onBlockRemoved(world, x, y, z, data);
        if (world.isClientSide) {
            return;
        }
        world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
        world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
        this.updateAndPropagateCurrentStrength(world, x, y, z);
        this.notifyWireNeighborsOfNeighborChange(world, x - 1, y, z);
        this.notifyWireNeighborsOfNeighborChange(world, x + 1, y, z);
        this.notifyWireNeighborsOfNeighborChange(world, x, y, z - 1);
        this.notifyWireNeighborsOfNeighborChange(world, x, y, z + 1);
        if (world.isBlockNormalCube(x - 1, y, z)) {
            this.notifyWireNeighborsOfNeighborChange(world, x - 1, y + 1, z);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, x - 1, y - 1, z);
        }
        if (world.isBlockNormalCube(x + 1, y, z)) {
            this.notifyWireNeighborsOfNeighborChange(world, x + 1, y + 1, z);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, x + 1, y - 1, z);
        }
        if (world.isBlockNormalCube(x, y, z - 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, x, y + 1, z - 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, x, y - 1, z - 1);
        }
        if (world.isBlockNormalCube(x, y, z + 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, x, y + 1, z + 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, x, y - 1, z + 1);
        }
    }

    private int getMaxCurrentStrength(World world, int x, int y, int z, int inputMeta) {
        if (world.getBlockId(x, y, z) != this.id) {
            return inputMeta;
        }
        int meta = world.getBlockMetadata(x, y, z);
        return Math.max(meta, inputMeta);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (world.isClientSide) {
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        boolean flag = this.canPlaceBlockAt(world, x, y, z);
        if (!flag) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, meta, null, null);
            world.setBlockWithNotify(x, y, z, 0);
        } else {
            this.updateAndPropagateCurrentStrength(world, x, y, z);
        }
        super.onNeighborBlockChange(world, x, y, z, blockId);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        return new ItemStack[]{new ItemStack(Items.DUST_REDSTONE)};
    }

    @Override
    public boolean getDirectSignal(World world, int x, int y, int z, Side side) {
        if (!this.wiresProvidePower) {
            return false;
        }
        return this.getSignal(world, x, y, z, side);
    }

    @Override
    public boolean getSignal(WorldSource blockAccess, int x, int y, int z, Side side) {
        boolean flag3;
        if (!this.wiresProvidePower) {
            return false;
        }
        if (blockAccess.getBlockMetadata(x, y, z) == 0) {
            return false;
        }
        if (side == Side.TOP) {
            return true;
        }
        boolean flag = RedstoneWireBlock.isPowerProviderOrWire(blockAccess, x - 1, y, z, 1) || !blockAccess.isBlockNormalCube(x - 1, y, z) && RedstoneWireBlock.isPowerProviderOrWire(blockAccess, x - 1, y - 1, z, -1);
        boolean flag1 = RedstoneWireBlock.isPowerProviderOrWire(blockAccess, x + 1, y, z, 3) || !blockAccess.isBlockNormalCube(x + 1, y, z) && RedstoneWireBlock.isPowerProviderOrWire(blockAccess, x + 1, y - 1, z, -1);
        boolean flag2 = RedstoneWireBlock.isPowerProviderOrWire(blockAccess, x, y, z - 1, 2) || !blockAccess.isBlockNormalCube(x, y, z - 1) && RedstoneWireBlock.isPowerProviderOrWire(blockAccess, x, y - 1, z - 1, -1);
        boolean bl = flag3 = RedstoneWireBlock.isPowerProviderOrWire(blockAccess, x, y, z + 1, 0) || !blockAccess.isBlockNormalCube(x, y, z + 1) && RedstoneWireBlock.isPowerProviderOrWire(blockAccess, x, y - 1, z + 1, -1);
        if (!blockAccess.isBlockNormalCube(x, y + 1, z)) {
            if (blockAccess.isBlockNormalCube(x - 1, y, z) && RedstoneWireBlock.isPowerProviderOrWire(blockAccess, x - 1, y + 1, z, -1)) {
                flag = true;
            }
            if (blockAccess.isBlockNormalCube(x + 1, y, z) && RedstoneWireBlock.isPowerProviderOrWire(blockAccess, x + 1, y + 1, z, -1)) {
                flag1 = true;
            }
            if (blockAccess.isBlockNormalCube(x, y, z - 1) && RedstoneWireBlock.isPowerProviderOrWire(blockAccess, x, y + 1, z - 1, -1)) {
                flag2 = true;
            }
            if (blockAccess.isBlockNormalCube(x, y, z + 1) && RedstoneWireBlock.isPowerProviderOrWire(blockAccess, x, y + 1, z + 1, -1)) {
                flag3 = true;
            }
        }
        if (!(flag2 || flag1 || flag || flag3 || side.getAxis() == Axis.Y)) {
            return true;
        }
        if (side == Side.NORTH && flag2 && !flag && !flag1) {
            return true;
        }
        if (side == Side.SOUTH && flag3 && !flag && !flag1) {
            return true;
        }
        if (side == Side.WEST && flag && !flag2 && !flag3) {
            return true;
        }
        return side == Side.EAST && flag1 && !flag2 && !flag3;
    }

    @Override
    public boolean isSignalSource() {
        return this.wiresProvidePower;
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 0) {
            return;
        }
        double px = (double)x + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double py = (double)y + 0.0625;
        double pz = (double)z + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        int redstoneBrightness = meta & 0xF;
        Color color = Colors.allRedstoneColors[redstoneBrightness];
        if (color == null) {
            return;
        }
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        world.spawnParticle("reddust", px, py, pz, red, green, blue, redstoneBrightness);
    }

    public static boolean isPowerProviderOrWire(WorldSource worldSource, int x, int y, int z, int l) {
        int blockId = worldSource.getBlockId(x, y, z);
        if (blockId == Blocks.WIRE_REDSTONE.id) {
            return true;
        }
        if (blockId <= 0) {
            return false;
        }
        if (Block.blocksList[blockId].isSignalSource()) {
            return true;
        }
        if (blockId == Blocks.PUMPKIN_REDSTONE.id) {
            if (l < 0 || l > 3) {
                return false;
            }
            Side[] lookup = new Side[]{Side.NORTH, Side.EAST, Side.SOUTH, Side.WEST};
            Side side = Side.getSideById(worldSource.getBlockMetadata(x, y, z));
            return side == lookup[l];
        }
        if (blockId == Blocks.REPEATER_IDLE.id || blockId == Blocks.REPEATER_ACTIVE.id) {
            int meta = worldSource.getBlockMetadata(x, y, z);
            return l == BedBlock.footToHeadMap[meta & 3];
        }
        return false;
    }
}

