/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.FireBlock;
import net.minecraft.core.block.FluidBlock;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class StillFluidBlock
extends FluidBlock {
    public StillFluidBlock(String key, String namespaceId, int id, Material material) {
        super(key, namespaceId, id, material);
        this.setTicking(false);
        if (material == Material.lava) {
            this.setTicking(true);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        super.onNeighborBlockChange(world, x, y, z, blockId);
        if (blockId == Side.TOP.getId()) {
            return;
        }
        if (world.getBlockId(x, y, z) == this.id) {
            this.setFlowing(world, x, y, z);
        }
    }

    private void setFlowing(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        world.editingBlocks = true;
        world.setBlockAndMetadata(i, j, k, this.id - 1, l);
        world.markBlocksDirty(i, j, k, i, j, k);
        world.scheduleBlockUpdate(i, j, k, this.id - 1, this.tickDelay());
        world.editingBlocks = false;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (this.blockMaterial == Material.lava) {
            int l = rand.nextInt(3);
            for (int i1 = 0; i1 < l; ++i1) {
                int blockId = world.getBlockId(x += rand.nextInt(3) - 1, ++y, z += rand.nextInt(3) - 1);
                if (blockId == 0) {
                    if (!this.isFlammable(world, x - 1, y, z) && !this.isFlammable(world, x + 1, y, z) && !this.isFlammable(world, x, y, z - 1) && !this.isFlammable(world, x, y, z + 1) && !this.isFlammable(world, x, y - 1, z) && !this.isFlammable(world, x, y + 1, z)) continue;
                    world.setBlockWithNotify(x, y, z, Blocks.FIRE.id);
                    return;
                }
                if (!Block.blocksList[blockId].blockMaterial.blocksMotion()) continue;
                return;
            }
        }
    }

    private boolean isFlammable(World world, int x, int y, int z) {
        return FireBlock.canBurn(world, x, y, z);
    }
}

