/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.LadderBlock;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class TrapDoorBlock
extends Block {
    private boolean isIron;

    public TrapDoorBlock(String key, String namespaceId, int id, Material material, boolean isIron) {
        super(key, namespaceId, id, material);
        float f = 0.5f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f1, 0.5f + f);
        this.isIron = isIron;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        return super.getSelectedBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        this.setBlockBoundsForBlockRender(world.getBlockMetadata(x, y, z));
    }

    public void setBlockBoundsForBlockRender(int i) {
        float f = 0.1875f;
        if (TrapDoorBlock.isTrapdoorOpen(i)) {
            if ((i & 3) == 0) {
                this.setBlockBounds(0.0, 0.0, 1.0f - f, 1.0, 1.0, 1.0);
            }
            if ((i & 3) == 1) {
                this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, f);
            }
            if ((i & 3) == 2) {
                this.setBlockBounds(1.0f - f, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
            if ((i & 3) == 3) {
                this.setBlockBounds(0.0, 0.0, 0.0, f, 1.0, 1.0);
            }
        } else if (TrapDoorBlock.isUpperHalf(i)) {
            this.setBlockBounds(0.0, 1.0f - f, 0.0, 1.0, 1.0, 1.0);
        } else {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, f, 1.0);
        }
    }

    @Override
    public void onBlockLeftClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        if (!Item.hasTag(player.getCurrentEquippedItem(), ItemTags.PREVENT_LEFT_CLICK_INTERACTIONS)) {
            this.onBlockRightClicked(world, x, y, z, player, null, 0.0, 0.0);
        }
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (this.blockMaterial != Material.metal) {
            int l = world.getBlockMetadata(x, y, z);
            world.setBlockMetadataWithNotify(x, y, z, l ^ 4);
            world.playSoundEffect(player, 1003, x, y, z, 0);
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean isPowered;
        int meta;
        boolean isOpened;
        if (world.isClientSide) {
            return;
        }
        if ((this.isIron || blockId > 0 && Block.getBlock(blockId).isSignalSource()) && (isOpened = TrapDoorBlock.isTrapdoorOpen(meta = world.getBlockMetadata(x, y, z))) != (isPowered = world.isBlockIndirectlyGettingPowered(x, y, z))) {
            world.setBlockMetadataWithNotify(x, y, z, meta ^ 4);
            world.playSoundEffect(null, 1003, x, y, z, 0);
        }
    }

    @Override
    public HitResult collisionRayTrace(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        return super.collisionRayTrace(world, x, y, z, start, end);
    }

    @Override
    public int getPlacedBlockMetadata(Player player, ItemStack stack, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        int meta = this.getMetaForDirection(player.getHorizontalPlacementDirection(side, PlacementMode.SIDE));
        if (player.getVerticalPlacementDirection(side, yPlaced) == Direction.UP) {
            meta |= 8;
        }
        return meta;
    }

    @Override
    public boolean isClimbable(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y - 1, z);
        int meta = world.getBlockMetadata(x, y, z);
        if (TrapDoorBlock.isTrapdoorOpen(meta) && block instanceof LadderBlock) {
            LadderBlock ladder = (LadderBlock)block;
            Side ladderSide = ladder.getSideFromMeta(world.getBlockMetadata(x, y - 1, z));
            Direction trapdoorDirection = this.getDirectionForMeta(meta);
            return ladderSide.getDirection().getOpposite() == trapdoorDirection;
        }
        return false;
    }

    public static boolean isTrapdoorOpen(int metadata) {
        return (metadata & 4) != 0;
    }

    public static boolean isUpperHalf(int meta) {
        return (meta & 8) != 0;
    }

    public int getMetaForDirection(Direction dir) {
        if (dir == Direction.NORTH) {
            return 1;
        }
        if (dir == Direction.EAST) {
            return 2;
        }
        if (dir == Direction.SOUTH) {
            return 0;
        }
        if (dir == Direction.WEST) {
            return 3;
        }
        return 0;
    }

    public Direction getDirectionForMeta(int meta) {
        if ((meta &= 3) == 0) {
            return Direction.SOUTH;
        }
        if (meta == 1) {
            return Direction.NORTH;
        }
        if (meta == 2) {
            return Direction.EAST;
        }
        if (meta == 3) {
            return Direction.WEST;
        }
        return Direction.NONE;
    }
}

