/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.CompoundTag;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BasketBlockEntity;
import net.minecraft.core.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.core.block.entity.ChestBlockEntity;
import net.minecraft.core.block.entity.DispenserBlockEntity;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.block.entity.FlowerJarBlockEntity;
import net.minecraft.core.block.entity.FurnaceBlockEntity;
import net.minecraft.core.block.entity.GoldMeshBlockEntity;
import net.minecraft.core.block.entity.JukeboxBlockEntity;
import net.minecraft.core.block.entity.MobSpawnerBlockEntity;
import net.minecraft.core.block.entity.NoteBlockEntity;
import net.minecraft.core.block.entity.SeatBlockEntity;
import net.minecraft.core.block.entity.SensorBlockEntity;
import net.minecraft.core.block.entity.SignBlockEntity;
import net.minecraft.core.block.entity.TrommelBlockEntity;
import net.minecraft.core.block.piston.MovingPistonBlockEntity;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.world.World;
import org.slf4j.Logger;

public class BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, Class<? extends BlockEntity>> nameToClassMap = new HashMap<String, Class<? extends BlockEntity>>();
    private static final Map<Class<? extends BlockEntity>, String> classToNameMap = new HashMap<Class<? extends BlockEntity>, String>();
    public World worldObj;
    public int x;
    public int y;
    public int z;
    protected boolean tileEntityInvalid;

    private static void addMapping(Class<? extends BlockEntity> entityClass, String name) {
        if (nameToClassMap.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate id: " + name);
        }
        nameToClassMap.put(name, entityClass);
        classToNameMap.put(entityClass, name);
    }

    public void readFromNBT(CompoundTag nbttagcompound) {
        this.x = nbttagcompound.getInteger("x");
        this.y = nbttagcompound.getInteger("y");
        this.z = nbttagcompound.getInteger("z");
    }

    public void writeToNBT(CompoundTag nbttagcompound) {
        String name = classToNameMap.get(this.getClass());
        if (name == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        nbttagcompound.putString("id", name);
        nbttagcompound.putInt("x", this.x);
        nbttagcompound.putInt("y", this.y);
        nbttagcompound.putInt("z", this.z);
    }

    public void tick() {
    }

    public static BlockEntity createAndLoadEntity(CompoundTag nbttagcompound) {
        BlockEntity blockEntity = null;
        Class<? extends BlockEntity> entityClass = nameToClassMap.get(nbttagcompound.getString("id"));
        try {
            if (entityClass != null) {
                blockEntity = entityClass.newInstance();
            }
        }
        catch (Exception exception) {
            LOGGER.error("Exception when instancing class '{}'!", (Object)entityClass.getSimpleName(), (Object)exception);
        }
        if (blockEntity != null) {
            blockEntity.readFromNBT(nbttagcompound);
        } else {
            LOGGER.warn("Skipping BlockEntity with id {}", (Object)nbttagcompound.getString("id"));
        }
        return blockEntity;
    }

    public static Class<? extends BlockEntity> getClassFromID(String id) {
        return nameToClassMap.get(id);
    }

    public int getMovedData() {
        return this.worldObj.getBlockMetadata(this.x, this.y, this.z);
    }

    public void setChanged() {
        if (this.worldObj != null) {
            this.worldObj.updateTileEntityChunkAndSendToPlayer(this.x, this.y, this.z, this);
        }
    }

    public Packet getDescriptionPacket() {
        return null;
    }

    public double getDistanceFrom(double d, double d1, double d2) {
        double d3 = (double)this.x + 0.5 - d;
        double d4 = (double)this.y + 0.5 - d1;
        double d5 = (double)this.z + 0.5 - d2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public Block getBlockType() {
        return Block.blocksList[this.worldObj.getBlockId(this.x, this.y, this.z)];
    }

    public boolean isInvalid() {
        return this.tileEntityInvalid;
    }

    public void invalidate() {
        this.tileEntityInvalid = true;
    }

    public void validate() {
        this.tileEntityInvalid = false;
    }

    static {
        BlockEntity.addMapping(FurnaceBlockEntity.class, "Furnace");
        BlockEntity.addMapping(ChestBlockEntity.class, "Chest");
        BlockEntity.addMapping(JukeboxBlockEntity.class, "RecordPlayer");
        BlockEntity.addMapping(DispenserBlockEntity.class, "Trap");
        BlockEntity.addMapping(SignBlockEntity.class, "Sign");
        BlockEntity.addMapping(MobSpawnerBlockEntity.class, "MobSpawner");
        BlockEntity.addMapping(NoteBlockEntity.class, "Music");
        BlockEntity.addMapping(MovingPistonBlockEntity.class, "Piston");
        BlockEntity.addMapping(BlastFurnaceBlockEntity.class, "BlastFurnace");
        BlockEntity.addMapping(SensorBlockEntity.class, "Sensor");
        BlockEntity.addMapping(TrommelBlockEntity.class, "Trommel");
        BlockEntity.addMapping(BasketBlockEntity.class, "Basket");
        BlockEntity.addMapping(FlagBlockEntity.class, "Flag");
        BlockEntity.addMapping(SeatBlockEntity.class, "Seat");
        BlockEntity.addMapping(FlowerJarBlockEntity.class, "FlowerJar");
        BlockEntity.addMapping(GoldMeshBlockEntity.class, "MeshGold");
    }
}

