/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import java.util.Random;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.IDispensable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;

public class DispenserBlockEntity
extends BlockEntity
implements Container {
    private ItemStack[] dispenserContents = new ItemStack[9];
    private Random dispenserRandom = new Random();

    @Override
    public int getContainerSize() {
        return 9;
    }

    @Override
    public ItemStack getItem(int index) {
        return this.dispenserContents[index];
    }

    @Override
    public ItemStack removeItem(int index, int takeAmount) {
        if (this.dispenserContents[index] != null) {
            if (this.dispenserContents[index].stackSize <= takeAmount) {
                ItemStack itemstack = this.dispenserContents[index];
                this.dispenserContents[index] = null;
                this.setChanged();
                return itemstack;
            }
            ItemStack itemstack1 = this.dispenserContents[index].splitStack(takeAmount);
            if (this.dispenserContents[index].stackSize <= 0) {
                this.dispenserContents[index] = null;
            }
            this.setChanged();
            return itemstack1;
        }
        return null;
    }

    public ItemStack getRandomStackFromInventory() {
        int i = -1;
        int j = 1;
        for (int k = 0; k < this.dispenserContents.length; ++k) {
            if (this.dispenserContents[k] == null || this.dispenserRandom.nextInt(j++) != 0) continue;
            i = k;
        }
        if (i >= 0) {
            ItemStack stack = this.getItem(i);
            if (stack.getItem() instanceof IDispensable) {
                IDispensable dispensable = (IDispensable)((Object)stack.getItem());
                if (dispensable.isRemovedOnDispense()) {
                    return this.removeItem(i, 1);
                }
                return stack;
            }
            return this.removeItem(i, 1);
        }
        return null;
    }

    @Override
    public void setItem(int index, ItemStack itemstack) {
        this.dispenserContents[index] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getMaxStackSize()) {
            itemstack.stackSize = this.getMaxStackSize();
        }
        this.setChanged();
    }

    @Override
    public String getName() {
        return "Trap";
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        ListTag nbttaglist = nbttagcompound.getList("Items");
        this.dispenserContents = new ItemStack[this.getContainerSize()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            CompoundTag nbttagcompound1 = (CompoundTag)nbttaglist.tagAt(i);
            int j = nbttagcompound1.getByte("Slot") & 0xFF;
            if (j >= this.dispenserContents.length) continue;
            this.dispenserContents[j] = ItemStack.readItemStackFromNbt(nbttagcompound1);
        }
    }

    @Override
    public void writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < this.dispenserContents.length; ++i) {
            if (this.dispenserContents[i] == null) continue;
            CompoundTag nbttagcompound1 = new CompoundTag();
            nbttagcompound1.putByte("Slot", (byte)i);
            this.dispenserContents[i].writeToNBT(nbttagcompound1);
            nbttaglist.addTag(nbttagcompound1);
        }
        nbttagcompound.put("Items", nbttaglist);
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    @Override
    public boolean stillValid(Player entityplayer) {
        if (this.worldObj.getBlockEntity(this.x, this.y, this.z) != this) {
            return false;
        }
        return entityplayer.distanceToSqr((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) <= 64.0;
    }

    @Override
    public void sortContainer() {
    }
}

