/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.SandBlock;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class FallingBlockEntity
extends Entity {
    public int blockID;
    public int fallTime;
    public boolean hasRemovedBlock = false;

    public FallingBlockEntity(World world) {
        super(world);
        this.blockID = Blocks.SAND.id;
        this.fallTime = 0;
    }

    public FallingBlockEntity(World world, double x, double y, double z, int blockId) {
        super(world);
        this.fallTime = 0;
        this.blockID = blockId;
        this.blocksBuilding = true;
        this.setSize(0.98f, 0.98f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.setPos(x, y, z);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    @Override
    protected boolean makeStepSound() {
        return false;
    }

    @Override
    protected void defineSynchedData() {
    }

    @Override
    public boolean isPickable() {
        return !this.removed;
    }

    @Override
    public void tick() {
        if (this.blockID == 0) {
            this.remove();
            return;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        ++this.fallTime;
        this.yd -= 0.04;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.98;
        this.yd *= 0.98;
        this.zd *= 0.98;
        int i = MathHelper.floor(this.x);
        int j = MathHelper.floor(this.y);
        int k = MathHelper.floor(this.z);
        if (this.world.getBlockId(i, j, k) == this.blockID) {
            this.world.setBlockWithNotify(i, j, k, 0);
            this.hasRemovedBlock = true;
        }
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
            this.yd *= -0.5;
            this.remove();
            if (!(this.world.canBlockBePlacedAt(this.blockID, i, j, k, true, Side.TOP) && !SandBlock.canFallBelow(this.world, i, j - 1, k) && this.world.setBlockWithNotify(i, j, k, this.blockID) || this.world.isClientSide || !this.hasRemovedBlock)) {
                this.spawnAtLocation(this.blockID, 1);
            }
        } else if (this.fallTime > 100 && !this.world.isClientSide) {
            if (this.hasRemovedBlock) {
                this.spawnAtLocation(this.blockID, 1);
            }
            this.remove();
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putShort("Tile", (short)this.blockID);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        this.blockID = tag.getShort("Tile") & 0x3FFF;
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public boolean showBoundingBoxOnHover() {
        return true;
    }
}

