/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.PathfinderMob;
import net.minecraft.core.entity.animal.Creature;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.season.Seasons;

public abstract class Animal
extends PathfinderMob
implements Creature {
    public Player closestPlayer;

    public Animal(World world) {
        super(world);
        this.scoreValue = 10;
    }

    @Override
    protected void updateAI() {
        float distanceToEntity;
        if (this.target == null) {
            this.closestPlayer = this.world.getClosestPlayer(this.x, this.y, this.z, 10.0);
        }
        if (this.closestPlayer != null) {
            if (this.isFavouriteItem(this.closestPlayer.getHeldItem())) {
                this.setTarget(this.closestPlayer);
            } else {
                this.setTarget(null);
                this.closestPlayer = null;
            }
        }
        super.updateAI();
        if (this.target != null && (distanceToEntity = this.target.distanceTo(this)) < 3.0f) {
            this.moveForward = 0.0f;
        }
    }

    @Override
    public int getMaxSpawnedInChunk() {
        if (this.world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_SPRING) {
            return 8;
        }
        if (this.world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_WINTER) {
            return 1;
        }
        return 4;
    }

    @Override
    protected float getBlockPathWeight(int x, int y, int z) {
        if (this.world.getBlockId(x, y - 1, z) == Blocks.GRASS.id) {
            return 10.0f;
        }
        return this.world.getLightBrightness(x, y, z) - 0.5f;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    @Override
    public boolean canSpawnHere() {
        int z;
        int y;
        int x = MathHelper.floor(this.x);
        int id = this.world.getBlockId(x, (y = MathHelper.floor(this.bb.minY)) - 1, z = MathHelper.floor(this.z));
        if (Block.blocksList[id] != null) {
            return Block.blocksList[id].hasTag(BlockTags.PASSIVE_MOBS_SPAWN) && this.world.getFullBlockLightValue(x, y, z) > 8 && super.canSpawnHere();
        }
        return false;
    }

    @Override
    public int getAmbientSoundInterval() {
        return 120;
    }

    public boolean isFavouriteItem(ItemStack itemStack) {
        return false;
    }
}

