/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command;

import net.minecraft.client.Minecraft;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.Commands;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;

public class ClientCommandHandler
implements CommandHandler {
    public final Minecraft minecraft;

    public ClientCommandHandler(Minecraft minecraft) {
        this.minecraft = minecraft;
        Commands.initClientCommands(minecraft);
    }

    @Override
    public synchronized void sendMessageToAdmins(String msg) {
        if (this.minecraft.theWorld.getLevelData().getCheatsEnabled()) {
            this.minecraft.ingameHud.addChatMessage(msg);
        }
    }

    @Override
    public synchronized void sendMessageToAllPlayers(String msg) {
        this.minecraft.ingameHud.addChatMessage(msg);
    }

    @Override
    @Nullable
    public synchronized Player getPlayer(String name) {
        if (this.minecraft.thePlayer.username.equalsIgnoreCase(name)) {
            return this.minecraft.thePlayer;
        }
        return null;
    }

    @Override
    public synchronized void sendMessageToPlayer(Player player, String msg) {
        if (player == this.minecraft.thePlayer) {
            this.minecraft.ingameHud.addChatMessage(msg);
        }
    }

    @Override
    public synchronized boolean playerExists(String name) {
        return name.equalsIgnoreCase(this.minecraft.thePlayer.username);
    }

    @Override
    public synchronized void sendCommandFeedback(CommandSender sender, String message) {
        sender.sendMessage(message);
    }

    @Override
    public synchronized World getWorld(int dimension) {
        return this.minecraft.theWorld;
    }
}

