/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.world.World;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ServerCommandHandler
implements CommandHandler {
    public final MinecraftServer minecraftServer;

    public ServerCommandHandler(MinecraftServer minecraftServer) {
        this.minecraftServer = minecraftServer;
    }

    @Override
    public synchronized void sendMessageToAdmins(String msg) {
        this.minecraftServer.playerList.sendChatMessageToAllOps(msg);
    }

    @Override
    @Nullable
    public synchronized Player getPlayer(String name) {
        return this.minecraftServer.playerList.getPlayerEntity(name);
    }

    @Override
    public synchronized void sendMessageToAllPlayers(String msg) {
        this.minecraftServer.playerList.sendEncryptedChatToAllPlayers(msg);
    }

    @Override
    public synchronized void sendMessageToPlayer(Player player, String messsage) {
        this.minecraftServer.playerList.sendPacketToPlayer(player.username, new ChatPacket(messsage, AES.keyChain.get(player.username)));
    }

    @Override
    public synchronized boolean playerExists(String name) {
        return this.minecraftServer.playerList.getPlayerEntity(name) != null;
    }

    @Override
    public synchronized void sendCommandFeedback(CommandSender sender, String message) {
        sender.sendMessage(message);
        String message2 = "\u00a77" + sender.getName() + ": " + message;
        for (Player player : this.minecraftServer.playerList.playerEntities) {
            if (!this.minecraftServer.playerList.isOp(player.uuid) || sender.getPlayer() != null && sender.getPlayer() == player) continue;
            this.sendMessageToPlayer(player, message2);
        }
        this.minecraftServer.logInfo(message2);
    }

    @Override
    public synchronized World getWorld(int dimension) {
        return this.minecraftServer.getDimensionWorld(dimension);
    }
}

