/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import java.util.Arrays;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.PlayerCommandSender;

public class ClearCommand
extends Command {
    public ClearCommand() {
        super("clear", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        Player player = null;
        if (args.length == 0) {
            player = sender.getPlayer();
        }
        if (args.length == 1) {
            player = handler.getPlayer(args[0]);
        }
        if (player == null) {
            throw new CommandError("Must be used by a player, or define a player name!");
        }
        for (int i = 0; i < player.inventory.getContainerSize(); ++i) {
            player.inventory.setItem(i, null);
        }
        Arrays.fill(player.inventory.armorInventory, null);
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        if (sender instanceof PlayerCommandSender) {
            sender.sendMessage("/clear");
        }
        sender.sendMessage("/clear <player>");
    }
}

