/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import net.minecraft.client.entity.player.LocalPlayer;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.PlayerCommandSender;
import net.minecraft.server.entity.player.ServerPlayer;

public class GiveCommand
extends Command {
    public GiveCommand() {
        super("give", "item", "i");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        Player player;
        int count = 1;
        int meta = 0;
        int arg = 0;
        if (args.length == 0) {
            return false;
        }
        if (handler.playerExists(args[0])) {
            player = handler.getPlayer(args[0]);
            ++arg;
        } else {
            player = sender.getPlayer();
        }
        if (player == null) {
            throw new CommandError("no player");
        }
        String[] ids = args[arg].split(":");
        Item item = GiveCommand.getItem(ids[0]);
        if (item == null) {
            throw new CommandError("Item not found: \"" + ids[0] + "\"");
        }
        if (ids.length > 1) {
            meta = Integer.parseInt(ids[1]);
        }
        if (args.length > ++arg) {
            count = Integer.parseInt(args[arg]);
        }
        ItemStack itemStack = new ItemStack(item, count, meta);
        return GiveCommand.givePlayerItem(handler, sender, player, itemStack);
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/give <Player> <ID:Meta> <Count>");
        if (sender instanceof PlayerCommandSender) {
            sender.sendMessage("/give <ID:Meta> <Count>");
        }
    }

    public static Item getItem(String id) {
        try {
            int i = Integer.parseInt(id);
            return GiveCommand.getItem(i);
        }
        catch (Exception e) {
            String id2 = "tile." + id;
            String id3 = "item." + id;
            for (Item item : Item.itemsList) {
                if (item == null) continue;
                if (item.getKey().equalsIgnoreCase(id)) {
                    return item;
                }
                if (item.getKey().equalsIgnoreCase(id2)) {
                    return item;
                }
                if (!item.getKey().equalsIgnoreCase(id3)) continue;
                return item;
            }
            return null;
        }
    }

    public static Item getItem(int id) {
        return Item.itemsList[id];
    }

    public static boolean givePlayerItem(CommandHandler handler, CommandSender sender, Player player, ItemStack item) {
        if (player instanceof LocalPlayer) {
            player.inventory.insertItem(item, true);
            if (item.stackSize > 0) {
                player.dropPlayerItem(item);
            }
            return true;
        }
        if (player instanceof ServerPlayer) {
            handler.sendCommandFeedback(sender, "Gave " + item.stackSize + " of " + item.getItemKey() + " to " + player.getDisplayName());
            ServerPlayer playerMP = (ServerPlayer)player;
            playerMP.dropPlayerItem(item);
            return true;
        }
        return false;
    }
}

