/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import java.util.Locale;
import net.minecraft.core.net.command.ClientCommandHandler;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.ServerCommandHandler;
import net.minecraft.core.net.packet.PlaySoundEffectDirectPacket;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.sound.SoundTypes;

public class PlaySoundCommand
extends Command {
    public PlaySoundCommand() {
        super("playsound", "play");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        String soundPath = null;
        SoundCategory soundType = null;
        Float x = null;
        Float y = null;
        Float z = null;
        int dimension = 0;
        if (sender.getPlayer() != null) {
            x = Float.valueOf((float)sender.getPlayer().x);
            y = Float.valueOf((float)sender.getPlayer().y);
            z = Float.valueOf((float)sender.getPlayer().z);
            dimension = sender.getPlayer().dimension;
        }
        float volume = 1.0f;
        float pitch = 1.0f;
        if (args.length >= 2) {
            soundPath = args[0];
            soundType = SoundCategory.valueOf(args[1].toUpperCase(Locale.ROOT));
            if (args.length >= 5) {
                x = Float.valueOf(Float.parseFloat(args[2]));
                y = Float.valueOf(Float.parseFloat(args[3]));
                z = Float.valueOf(Float.parseFloat(args[4]));
                if (args.length >= 7) {
                    volume = Float.parseFloat(args[4]);
                    pitch = Float.parseFloat(args[5]);
                }
            }
        }
        if (soundPath != null && x != null) {
            if (handler instanceof ServerCommandHandler) {
                int soundId = SoundTypes.getSoundId(soundPath);
                if (soundId < 0) {
                    throw new CommandError("Invalid Sound: '" + soundPath + "'!");
                }
                ((ServerCommandHandler)handler).minecraftServer.playerList.sendPacketToPlayersAroundPoint(x.floatValue(), y.floatValue(), z.floatValue(), 128.0, dimension, new PlaySoundEffectDirectPacket(soundId, soundType, x.floatValue(), y.floatValue(), z.floatValue(), volume, pitch));
            } else if (handler instanceof ClientCommandHandler) {
                ((ClientCommandHandler)handler).minecraft.sndManager.playSoundAt(soundPath, soundType, x.floatValue(), y.floatValue(), z.floatValue(), volume, pitch);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        if (sender.getPlayer() != null) {
            sender.sendMessage("/playsound <SoundPath> <SoundType>");
        }
        sender.sendMessage("/playsound <SoundPath> <SoundType> <x> <y> <z>");
        sender.sendMessage("/playsound <SoundPath> <SoundType> <x> <y> <z> <Volume> <Pitch>");
    }
}

