/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.servercommands;

import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.ServerCommand;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.UpdatePlayerProfilePacket;
import net.minecraft.core.util.helper.UUIDHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;

public class DeopCommand
extends ServerCommand {
    public DeopCommand(MinecraftServer server) {
        super(server, "deop", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length == 0) {
            return false;
        }
        String name = args[0];
        ServerPlayer player = (ServerPlayer)handler.getPlayer(name);
        if (player != null) {
            boolean wasOp = player.isOperator();
            this.server.playerList.deopPlayer(player.uuid);
            if (wasOp) {
                handler.sendCommandFeedback(sender, "De-opping " + name);
                handler.sendMessageToPlayer(player, TextFormatting.YELLOW + "You are no longer op!");
                player.mcServer.playerList.sendPacketToAllPlayers(new UpdatePlayerProfilePacket(player.username, player.nickname, player.uuid, player.score, player.chatColor, true, player.isOperator()));
            }
        } else {
            UUIDHelper.runConversionAction(name, uuid -> {
                if (this.server.playerList.isOp(uuid)) {
                    this.server.playerList.deopPlayer(uuid);
                    handler.sendCommandFeedback(sender, "De-opping " + name);
                } else {
                    handler.sendCommandFeedback(sender, name + " was not an operator");
                }
            }, username -> handler.sendCommandFeedback(sender, "Could not retrieve UUID of player '" + username + "'"));
        }
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/deop <Player>");
    }
}

