/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.servercommands;

import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.ServerCommand;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.world.WorldServer;

public class SaveCommand
extends ServerCommand {
    public SaveCommand(MinecraftServer server) {
        super(server, "save", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        String subCommand;
        String senderName = sender.getName();
        if (args.length < 1) {
            return false;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "all": {
                this.sendNoticeToOps(senderName, "Forcing save..");
                if (this.server.playerList != null) {
                    this.server.playerList.savePlayerStates();
                }
                for (int i = 0; i < this.server.dimensionWorlds.length; ++i) {
                    WorldServer worldserver = this.server.dimensionWorlds[i];
                    worldserver.saveWorld(true, null, i == 0);
                }
                this.sendNoticeToOps(senderName, "Save complete.");
                return true;
            }
            case "on": {
                this.sendNoticeToOps(senderName, "Enabling level saving..");
                for (int k = 0; k < this.server.dimensionWorlds.length; ++k) {
                    WorldServer worldserver2 = this.server.dimensionWorlds[k];
                    worldserver2.levelSaving = false;
                }
                return true;
            }
            case "off": {
                this.sendNoticeToOps(senderName, "Disabling level saving..");
                for (int j = 0; j < this.server.dimensionWorlds.length; ++j) {
                    WorldServer worldserver1 = this.server.dimensionWorlds[j];
                    worldserver1.levelSaving = true;
                }
                return true;
            }
            case "interval": {
                if (args.length < 2) {
                    sender.sendMessage("Current save interval is " + this.server.propertyManager.getIntProperty("autosaveInterval", this.server.autoSaveInterval));
                    return true;
                }
                int interval = Integer.parseInt(args[1]);
                this.server.propertyManager.setProperty("autosaveInterval", interval);
                this.server.autoSaveInterval = interval;
                this.sendNoticeToOps(senderName, "Setting save interval to " + interval);
                return true;
            }
            case "amount": {
                if (args.length < 2) {
                    sender.sendMessage("Current chunks saved per autosave is " + this.server.propertyManager.getIntProperty("maxChunksSavedPerAutosave", this.server.chunksSavedPerAutosave));
                    return true;
                }
                int amount = Integer.parseInt(args[1]);
                this.server.propertyManager.setProperty("maxChunksSavedPerAutosave", amount);
                this.server.chunksSavedPerAutosave = amount;
                this.sendNoticeToOps(senderName, "Setting max chunks saved to " + amount);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/save on");
        sender.sendMessage("/save off");
        sender.sendMessage("/save all");
        sender.sendMessage("/save interval");
        sender.sendMessage("/save interval <seconds>");
        sender.sendMessage("/save amount");
        sender.sendMessage("/save amount <chunks>");
    }
}

