/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.servercommands;

import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.ServerCommand;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.server.MinecraftServer;

public class SayCommand
extends ServerCommand {
    public SayCommand(MinecraftServer server) {
        super(server, "say", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length < 1) {
            return false;
        }
        String senderName = sender.getName();
        StringBuilder messageBuilder = new StringBuilder();
        for (String arg : args) {
            messageBuilder.append(arg).append(" ");
        }
        String message = messageBuilder.toString().trim();
        MinecraftServer.LOGGER.info("[" + senderName + "] " + message);
        this.server.playerList.sendPacketToAllPlayers(new ChatPacket(TextFormatting.PINK + "[Server] " + message));
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/say <message>");
    }
}

