/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.servercommands;

import java.util.Set;
import java.util.UUID;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.ServerCommand;
import net.minecraft.core.util.helper.UUIDHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;

public class WhitelistCommand
extends ServerCommand {
    public WhitelistCommand(MinecraftServer server) {
        super(server, "whitelist", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        String subCommand;
        String senderName = sender.getName();
        if (args.length < 1) {
            return false;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "on": {
                this.sendNoticeToOps(senderName, "Turned on white-listing");
                this.server.propertyManager.setProperty("white-list", true);
                return true;
            }
            case "off": {
                this.sendNoticeToOps(senderName, "Turned off white-listing");
                this.server.propertyManager.setProperty("white-list", false);
                return true;
            }
            case "list": {
                Set<UUID> set = this.server.playerList.getWhitelist();
                StringBuilder builder = new StringBuilder();
                for (UUID uuid2 : set) {
                    builder.append("\"").append(uuid2).append("\"").append(", ");
                }
                String message = builder.toString();
                if (message.endsWith(", ")) {
                    message = message.substring(0, message.length() - 2);
                }
                sender.sendMessage("White-listed players: " + message);
                return true;
            }
            case "add": {
                if (args.length != 2) {
                    return false;
                }
                String nameToAdd = args[1].toLowerCase();
                ServerPlayer player = this.server.playerList.getPlayerEntity(nameToAdd);
                if (player != null) {
                    this.server.playerList.addToWhiteList(player.uuid);
                    this.sendNoticeToOps(senderName, "Added " + nameToAdd + " to white-list");
                } else {
                    UUIDHelper.runConversionAction(nameToAdd, uuid -> {
                        this.server.playerList.addToWhiteList(uuid);
                        this.sendNoticeToOps(senderName, "Added " + nameToAdd + " to white-list");
                    }, username -> handler.sendCommandFeedback(sender, "Could not retrieve UUID of player '" + username + "'"));
                }
                return true;
            }
            case "remove": {
                if (args.length != 2) {
                    return false;
                }
                String nameToRemove = args[1].toLowerCase();
                ServerPlayer player = this.server.playerList.getPlayerEntity(nameToRemove);
                if (player != null) {
                    this.server.playerList.removeFromWhiteList(player.uuid);
                    this.sendNoticeToOps(senderName, "Removed " + nameToRemove + " from white-list");
                } else {
                    UUIDHelper.runConversionAction(nameToRemove, uuid -> {
                        this.server.playerList.removeFromWhiteList(uuid);
                        this.sendNoticeToOps(senderName, "Removed " + nameToRemove + " from white-list");
                    }, username -> handler.sendCommandFeedback(sender, "Could not retrieve UUID of player '" + username + "'"));
                }
                return true;
            }
            case "reload": {
                this.server.playerList.reloadWhiteList();
                this.sendNoticeToOps(senderName, "Reloaded white-list from file");
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/whitelist on");
        sender.sendMessage("/whitelist off");
        sender.sendMessage("/whitelist list");
        sender.sendMessage("/whitelist add <player>");
        sender.sendMessage("/whitelist remove <player>");
        sender.sendMessage("/whitelist reload");
    }
}

