/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.NbtIo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.AESSendKeyPacket;
import net.minecraft.core.net.packet.AddEntityPacket;
import net.minecraft.core.net.packet.AddItemEntityPacket;
import net.minecraft.core.net.packet.AddMobPacket;
import net.minecraft.core.net.packet.AddPaintingPacket;
import net.minecraft.core.net.packet.AddParticlePacket;
import net.minecraft.core.net.packet.AddPlayerPacket;
import net.minecraft.core.net.packet.AnimatePacket;
import net.minecraft.core.net.packet.BedMessagePacket;
import net.minecraft.core.net.packet.BlockEntityDataPacket;
import net.minecraft.core.net.packet.BlockEventPacket;
import net.minecraft.core.net.packet.BlockRegionUpdatePacket;
import net.minecraft.core.net.packet.BlockUpdatePacket;
import net.minecraft.core.net.packet.BoatControlPacket;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.core.net.packet.ChunkBlocksUpdatePacket;
import net.minecraft.core.net.packet.ChunkVisibilityPacket;
import net.minecraft.core.net.packet.ContainerAckPacket;
import net.minecraft.core.net.packet.ContainerClickPacket;
import net.minecraft.core.net.packet.ContainerClosePacket;
import net.minecraft.core.net.packet.ContainerOpenPacket;
import net.minecraft.core.net.packet.ContainerSetContentPacket;
import net.minecraft.core.net.packet.ContainerSetDataPacket;
import net.minecraft.core.net.packet.ContainerSetSlotPacket;
import net.minecraft.core.net.packet.CustomPayloadPacket;
import net.minecraft.core.net.packet.DisconnectPacket;
import net.minecraft.core.net.packet.EnitityEventPacket;
import net.minecraft.core.net.packet.EntityNicknamePacket;
import net.minecraft.core.net.packet.EntityTagDataPacket;
import net.minecraft.core.net.packet.ExplosionPacket;
import net.minecraft.core.net.packet.FlagOpenPacket;
import net.minecraft.core.net.packet.GameRulePacket;
import net.minecraft.core.net.packet.GuidebookPacket;
import net.minecraft.core.net.packet.InteractPacket;
import net.minecraft.core.net.packet.KeepAlivePacket;
import net.minecraft.core.net.packet.LoginPacket;
import net.minecraft.core.net.packet.MapDataPacket;
import net.minecraft.core.net.packet.MoveEntityPacket;
import net.minecraft.core.net.packet.MovePlayerPacket;
import net.minecraft.core.net.packet.PhotoModePacket;
import net.minecraft.core.net.packet.PingHandshakePacket;
import net.minecraft.core.net.packet.PlaySoundEffectDirectPacket;
import net.minecraft.core.net.packet.PlaySoundEffectPacket;
import net.minecraft.core.net.packet.PlayerActionPacket;
import net.minecraft.core.net.packet.PlayerCommandPacket;
import net.minecraft.core.net.packet.PlayerGamemodePacket;
import net.minecraft.core.net.packet.PlayerListPacket;
import net.minecraft.core.net.packet.PreLoginPacket;
import net.minecraft.core.net.packet.RecipeSyncPacket;
import net.minecraft.core.net.packet.RemoveEntityPacket;
import net.minecraft.core.net.packet.RespawnPacket;
import net.minecraft.core.net.packet.SetCarriedItemPacket;
import net.minecraft.core.net.packet.SetEntityDataPacket;
import net.minecraft.core.net.packet.SetEntityMotionPacket;
import net.minecraft.core.net.packet.SetEquippedItemPacket;
import net.minecraft.core.net.packet.SetHealthPacket;
import net.minecraft.core.net.packet.SetHotbarOffsetPacket;
import net.minecraft.core.net.packet.SetItemNamePacket;
import net.minecraft.core.net.packet.SetMobSpawnerPacket;
import net.minecraft.core.net.packet.SetPaintingArtPacket;
import net.minecraft.core.net.packet.SetRidingPacket;
import net.minecraft.core.net.packet.SetSpawnPositionPacket;
import net.minecraft.core.net.packet.SetTimePacket;
import net.minecraft.core.net.packet.SignUpdatePacket;
import net.minecraft.core.net.packet.SleepPacket;
import net.minecraft.core.net.packet.StatisticPacket;
import net.minecraft.core.net.packet.SyncIDsPacket;
import net.minecraft.core.net.packet.TakeItemEntityPacket;
import net.minecraft.core.net.packet.TeleportEntityPacket;
import net.minecraft.core.net.packet.UpdateCreativeInventoryPacket;
import net.minecraft.core.net.packet.UpdatePlayerProfilePacket;
import net.minecraft.core.net.packet.UseItemPacket;
import net.minecraft.core.net.packet.WeatherEffectPacket;
import net.minecraft.core.net.packet.WeatherStatusPacket;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class Packet {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<Integer> INTERESTING_PACKETS = Arrays.asList(50, 51, 52);
    private static final Map<Integer, Class<? extends Packet>> packetIdToClassMap = new HashMap<Integer, Class<? extends Packet>>();
    private static final Map<Class<? extends Packet>, Integer> packetClassToIdMap = new HashMap<Class<? extends Packet>, Integer>();
    private static final Set<Integer> clientBoundPacketIds = new HashSet<Integer>();
    private static final Set<Integer> serverBoundPacketIds = new HashSet<Integer>();
    public final long creationTimeMillis = System.currentTimeMillis();
    public boolean isChunkDataPacket = false;

    public static void addMapping(int id, boolean clientBound, boolean serverBound, Class<? extends Packet> packetClass) {
        if (packetIdToClassMap.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate packet id:" + id);
        }
        if (packetClassToIdMap.containsKey(packetClass)) {
            throw new IllegalArgumentException("Duplicate packet class:" + packetClass);
        }
        packetIdToClassMap.put(id, packetClass);
        packetClassToIdMap.put(packetClass, id);
        if (clientBound) {
            clientBoundPacketIds.add(id);
        }
        if (serverBound) {
            serverBoundPacketIds.add(id);
        }
    }

    public static Packet getNewPacket(int id) {
        Class<? extends Packet> packetClass = packetIdToClassMap.get(id);
        try {
            if (packetClass == null) {
                return null;
            }
            return packetClass.newInstance();
        }
        catch (Exception exception) {
            LOGGER.error("Exception instancing packet class '{}'!", (Object)packetClass.getSimpleName(), (Object)exception);
            LOGGER.warn("Skipping packet with id {}", (Object)id);
            return null;
        }
    }

    public final int getId() {
        return packetClassToIdMap.get(this.getClass());
    }

    public static Packet readPacket(DataInputStream dis, boolean isServer) throws IOException {
        Packet packet;
        try {
            int id = dis.read();
            if (id == -1) {
                return null;
            }
            if (isServer && !serverBoundPacketIds.contains(id) || !isServer && !clientBoundPacketIds.contains(id)) {
                throw new IOException("Bad packet id " + id);
            }
            packet = Packet.getNewPacket(id);
            if (packet == null) {
                throw new IOException("Bad packet id " + id);
            }
            packet.read(dis);
        }
        catch (EOFException eofexception) {
            LOGGER.warn("Reached end of stream");
            return null;
        }
        return packet;
    }

    public static void writePacket(Packet packet, DataOutputStream dos) throws IOException {
        dos.write(packet.getId());
        packet.write(dos);
    }

    public static void writeString(String string, DataOutputStream dos) throws IOException {
        if (string.length() > Short.MAX_VALUE) {
            throw new IOException("String too big");
        }
        byte[] buf = string.getBytes(StandardCharsets.UTF_8);
        dos.writeShort(buf.length);
        dos.write(buf);
    }

    public static String readString(DataInputStream dis, int maxLength) throws IOException {
        short length = dis.readShort();
        if (length < 0) {
            throw new IOException("Received string length is less than zero! Weird string!");
        }
        byte[] data = new byte[length];
        dis.readFully(data);
        String result = new String(data, StandardCharsets.UTF_8);
        if (result.length() > maxLength) {
            throw new IOException("Received string length longer than maximum allowed (" + length + " > " + maxLength + ")");
        }
        return result;
    }

    public static void writeUTF16BEString(String string, DataOutputStream dos) throws IOException {
        if (string.length() > Short.MAX_VALUE) {
            throw new IOException("String too big");
        }
        byte[] buf = string.getBytes(StandardCharsets.UTF_16BE);
        dos.writeShort(string.length());
        dos.write(buf);
    }

    public static String readUTF16BEString(DataInputStream dis, int maxLength) throws IOException {
        short length = dis.readShort();
        if (length < 0) {
            throw new IOException("Received string length is less than zero! Weird string!");
        }
        byte[] data = new byte[length * 2];
        dis.readFully(data);
        String result = new String(data, StandardCharsets.UTF_16BE);
        if (result.length() > maxLength) {
            throw new IOException("Received string length longer than maximum allowed (" + length + " > " + maxLength + ")");
        }
        return result;
    }

    public static void writeCompressedCompoundTag(CompoundTag tag, DataOutputStream dos) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        NbtIo.writeCompressed(tag, baos);
        byte[] buffer = baos.toByteArray();
        dos.writeShort((short)buffer.length);
        dos.write(buffer);
    }

    public static CompoundTag readCompressedCompoundTag(DataInputStream dis) throws IOException {
        int length = Short.toUnsignedInt(dis.readShort());
        if (length == 0) {
            return null;
        }
        byte[] data = new byte[length];
        dis.readFully(data);
        return NbtIo.readCompressed(new ByteArrayInputStream(data));
    }

    public static void writeUUID(@NotNull UUID uuid, DataOutputStream dos) throws IOException {
        dos.writeLong(uuid.getMostSignificantBits());
        dos.writeLong(uuid.getLeastSignificantBits());
    }

    public static UUID readUUID(DataInputStream dis) throws IOException {
        long msb = dis.readLong();
        long lsb = dis.readLong();
        return new UUID(msb, lsb);
    }

    public static Map<Class<? extends Packet>, Integer> getPacketClassToIdMap() {
        return Collections.unmodifiableMap(packetClassToIdMap);
    }

    public static Map<Integer, Class<? extends Packet>> getPacketIdToClassMap() {
        return Collections.unmodifiableMap(packetIdToClassMap);
    }

    public abstract void read(DataInputStream var1) throws IOException;

    public abstract void write(DataOutputStream var1) throws IOException;

    public abstract void handlePacket(PacketHandler var1);

    public abstract int getEstimatedSize();

    static {
        Packet.addMapping(0, true, true, KeepAlivePacket.class);
        Packet.addMapping(1, true, true, LoginPacket.class);
        Packet.addMapping(2, true, true, PreLoginPacket.class);
        Packet.addMapping(3, true, true, ChatPacket.class);
        Packet.addMapping(4, true, false, SetTimePacket.class);
        Packet.addMapping(5, true, false, SetEquippedItemPacket.class);
        Packet.addMapping(6, true, false, SetSpawnPositionPacket.class);
        Packet.addMapping(7, false, true, InteractPacket.class);
        Packet.addMapping(8, true, false, SetHealthPacket.class);
        Packet.addMapping(9, true, true, RespawnPacket.class);
        Packet.addMapping(10, true, true, MovePlayerPacket.class);
        Packet.addMapping(11, true, true, MovePlayerPacket.Pos.class);
        Packet.addMapping(12, true, true, MovePlayerPacket.Rot.class);
        Packet.addMapping(13, true, true, MovePlayerPacket.PosRot.class);
        Packet.addMapping(14, false, true, PlayerActionPacket.class);
        Packet.addMapping(15, false, true, UseItemPacket.class);
        Packet.addMapping(16, true, true, SetCarriedItemPacket.class);
        Packet.addMapping(17, true, false, SleepPacket.class);
        Packet.addMapping(18, true, true, AnimatePacket.class);
        Packet.addMapping(19, false, true, PlayerCommandPacket.class);
        Packet.addMapping(20, true, false, AddPlayerPacket.class);
        Packet.addMapping(21, true, false, AddItemEntityPacket.class);
        Packet.addMapping(22, true, false, TakeItemEntityPacket.class);
        Packet.addMapping(23, true, false, AddEntityPacket.class);
        Packet.addMapping(24, true, false, AddMobPacket.class);
        Packet.addMapping(25, true, false, AddPaintingPacket.class);
        Packet.addMapping(26, true, true, BoatControlPacket.class);
        Packet.addMapping(28, true, false, SetEntityMotionPacket.class);
        Packet.addMapping(29, true, false, RemoveEntityPacket.class);
        Packet.addMapping(30, true, false, MoveEntityPacket.class);
        Packet.addMapping(31, true, false, MoveEntityPacket.Pos.class);
        Packet.addMapping(32, true, false, MoveEntityPacket.Rot.class);
        Packet.addMapping(33, true, false, MoveEntityPacket.PosRot.class);
        Packet.addMapping(34, true, false, TeleportEntityPacket.class);
        Packet.addMapping(35, true, true, EntityNicknamePacket.class);
        Packet.addMapping(38, true, false, EnitityEventPacket.class);
        Packet.addMapping(39, true, false, SetRidingPacket.class);
        Packet.addMapping(40, true, false, SetEntityDataPacket.class);
        Packet.addMapping(41, true, false, PlayerGamemodePacket.class);
        Packet.addMapping(42, true, false, EntityTagDataPacket.class);
        Packet.addMapping(50, true, false, ChunkVisibilityPacket.class);
        Packet.addMapping(51, true, false, BlockRegionUpdatePacket.class);
        Packet.addMapping(52, true, false, ChunkBlocksUpdatePacket.class);
        Packet.addMapping(53, true, false, BlockUpdatePacket.class);
        Packet.addMapping(54, true, false, BlockEventPacket.class);
        Packet.addMapping(60, true, false, ExplosionPacket.class);
        Packet.addMapping(61, true, false, PlaySoundEffectPacket.class);
        Packet.addMapping(62, true, false, PlaySoundEffectDirectPacket.class);
        Packet.addMapping(63, true, false, AddParticlePacket.class);
        Packet.addMapping(70, true, false, BedMessagePacket.class);
        Packet.addMapping(71, true, false, WeatherEffectPacket.class);
        Packet.addMapping(72, true, false, UpdatePlayerProfilePacket.class);
        Packet.addMapping(73, true, false, WeatherStatusPacket.class);
        Packet.addMapping(74, true, false, GameRulePacket.class);
        Packet.addMapping(75, true, false, RecipeSyncPacket.class);
        Packet.addMapping(100, true, false, ContainerOpenPacket.class);
        Packet.addMapping(101, true, true, ContainerClosePacket.class);
        Packet.addMapping(102, false, true, ContainerClickPacket.class);
        Packet.addMapping(103, true, false, ContainerSetSlotPacket.class);
        Packet.addMapping(104, true, false, ContainerSetContentPacket.class);
        Packet.addMapping(105, true, false, ContainerSetDataPacket.class);
        Packet.addMapping(106, true, true, ContainerAckPacket.class);
        Packet.addMapping(107, false, true, UpdateCreativeInventoryPacket.class);
        Packet.addMapping(108, false, true, SetHotbarOffsetPacket.class);
        Packet.addMapping(130, false, true, SignUpdatePacket.class);
        Packet.addMapping(131, true, false, MapDataPacket.class);
        Packet.addMapping(132, true, true, SetMobSpawnerPacket.class);
        Packet.addMapping(133, false, true, GuidebookPacket.class);
        Packet.addMapping(136, true, false, AESSendKeyPacket.class);
        Packet.addMapping(137, false, true, SetItemNamePacket.class);
        Packet.addMapping(138, true, false, PlayerListPacket.class);
        Packet.addMapping(139, false, true, SetPaintingArtPacket.class);
        Packet.addMapping(140, true, false, BlockEntityDataPacket.class);
        Packet.addMapping(142, true, false, FlagOpenPacket.class);
        Packet.addMapping(143, true, false, PhotoModePacket.class);
        Packet.addMapping(200, true, false, StatisticPacket.class);
        Packet.addMapping(201, true, false, SyncIDsPacket.class);
        Packet.addMapping(250, true, true, CustomPayloadPacket.class);
        Packet.addMapping(254, false, true, PingHandshakePacket.class);
        Packet.addMapping(255, true, true, DisconnectPacket.class);
    }
}

