/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.SpawnListEntry;
import net.minecraft.core.entity.animal.ChickenMob;
import net.minecraft.core.entity.animal.CowMob;
import net.minecraft.core.entity.animal.FireflyClusterMob;
import net.minecraft.core.entity.animal.PigMob;
import net.minecraft.core.entity.animal.SheepMob;
import net.minecraft.core.entity.animal.SquidMob;
import net.minecraft.core.entity.monster.CreeperMob;
import net.minecraft.core.entity.monster.SkeletonMob;
import net.minecraft.core.entity.monster.SlimeMob;
import net.minecraft.core.entity.monster.SnowmanMob;
import net.minecraft.core.entity.monster.SpiderMob;
import net.minecraft.core.entity.monster.ZombieArmoredMob;
import net.minecraft.core.entity.monster.ZombieMob;
import net.minecraft.core.enums.MobCategory;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTree;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeFancy;
import net.minecraft.core.world.weather.Weather;

public class Biome {
    public final String translationKey;
    public int color = 0xFF00FF;
    public short topBlock;
    public short fillerBlock;
    public Weather[] blockedWeathers = new Weather[0];
    protected List<SpawnListEntry> spawnableMonsterList;
    protected List<SpawnListEntry> spawnableCreatureList;
    protected List<SpawnListEntry> spawnableWaterCreatureList;
    protected List<SpawnListEntry> spawnableAmbientCreatureList;
    private boolean hasSurfaceSnow = false;

    public Biome(String key) {
        this.translationKey = "biome." + key;
        this.topBlock = (short)Blocks.GRASS.id;
        this.fillerBlock = (short)Blocks.DIRT.id;
        this.spawnableMonsterList = new ArrayList<SpawnListEntry>();
        this.spawnableCreatureList = new ArrayList<SpawnListEntry>();
        this.spawnableWaterCreatureList = new ArrayList<SpawnListEntry>();
        this.spawnableAmbientCreatureList = new ArrayList<SpawnListEntry>();
        this.spawnableMonsterList.add(new SpawnListEntry(SpiderMob.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(ZombieMob.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(ZombieArmoredMob.class, 2));
        this.spawnableMonsterList.add(new SpawnListEntry(SkeletonMob.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(CreeperMob.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(SlimeMob.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(SnowmanMob.class, 2));
        this.spawnableCreatureList.add(new SpawnListEntry(SheepMob.class, 102));
        this.spawnableCreatureList.add(new SpawnListEntry(PigMob.class, 102));
        this.spawnableCreatureList.add(new SpawnListEntry(ChickenMob.class, 102));
        this.spawnableCreatureList.add(new SpawnListEntry(CowMob.class, 102));
        this.spawnableWaterCreatureList.add(new SpawnListEntry(SquidMob.class, 10));
        this.spawnableAmbientCreatureList.add(new SpawnListEntry(FireflyClusterMob.class, 10));
    }

    public WorldFeature getRandomWorldGenForTrees(Random random) {
        if (random.nextInt(10) == 0) {
            return new WorldFeatureTreeFancy(Blocks.LEAVES_OAK.id, Blocks.LOG_OAK.id);
        }
        return new WorldFeatureTree(Blocks.LEAVES_OAK.id, Blocks.LOG_OAK.id, 4);
    }

    public Biome setColor(int color) {
        this.color = color;
        return this;
    }

    public int getSkyColor(float temperature) {
        if ((temperature /= 3.0f) < -1.0f) {
            temperature = -1.0f;
        }
        if (temperature > 1.0f) {
            temperature = 1.0f;
        }
        return Color.getHSBColor(0.6222222f - temperature * 0.125f, 0.5f + temperature * 0.1f, 1.0f).getRGB();
    }

    public List<SpawnListEntry> getSpawnableList(MobCategory creatureType) {
        switch (creatureType) {
            case monster: {
                return this.spawnableMonsterList;
            }
            case creature: {
                return this.spawnableCreatureList;
            }
            case waterCreature: {
                return this.spawnableWaterCreatureList;
            }
            case ambientCreature: {
                return this.spawnableAmbientCreatureList;
            }
        }
        return null;
    }

    public boolean hasSurfaceSnow() {
        return this.hasSurfaceSnow;
    }

    public Biome setSurfaceSnow() {
        this.hasSurfaceSnow = true;
        return this;
    }

    public Biome setBlockedWeathers(Weather ... blocked) {
        this.blockedWeathers = blocked;
        return this;
    }

    public Biome setTopBlock(int id) {
        this.topBlock = (short)id;
        return this;
    }

    public Biome setFillerBlock(int id) {
        this.fillerBlock = (short)id;
        return this;
    }
}

