/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.handler;

import com.mojang.logging.LogUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.block.entity.MobSpawnerBlockEntity;
import net.minecraft.core.block.entity.SignBlockEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.vehicle.BoatEntity;
import net.minecraft.core.enums.ArtType;
import net.minecraft.core.enums.EnumSignPicture;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.ChatEmotes;
import net.minecraft.core.net.ICommandListener;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.Commands;
import net.minecraft.core.net.command.PlayerCommandSender;
import net.minecraft.core.net.command.ServerCommandHandler;
import net.minecraft.core.net.command.ServerPlayerCommandSender;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.AnimatePacket;
import net.minecraft.core.net.packet.BlockUpdatePacket;
import net.minecraft.core.net.packet.BoatControlPacket;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.core.net.packet.ContainerAckPacket;
import net.minecraft.core.net.packet.ContainerClickPacket;
import net.minecraft.core.net.packet.ContainerClosePacket;
import net.minecraft.core.net.packet.ContainerSetSlotPacket;
import net.minecraft.core.net.packet.CustomPayloadPacket;
import net.minecraft.core.net.packet.DisconnectPacket;
import net.minecraft.core.net.packet.GuidebookPacket;
import net.minecraft.core.net.packet.InteractPacket;
import net.minecraft.core.net.packet.KeepAlivePacket;
import net.minecraft.core.net.packet.MovePlayerPacket;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PlayerActionPacket;
import net.minecraft.core.net.packet.PlayerCommandPacket;
import net.minecraft.core.net.packet.RespawnPacket;
import net.minecraft.core.net.packet.SetCarriedItemPacket;
import net.minecraft.core.net.packet.SetHotbarOffsetPacket;
import net.minecraft.core.net.packet.SetItemNamePacket;
import net.minecraft.core.net.packet.SetMobSpawnerPacket;
import net.minecraft.core.net.packet.SetPaintingArtPacket;
import net.minecraft.core.net.packet.SignUpdatePacket;
import net.minecraft.core.net.packet.UpdateCreativeInventoryPacket;
import net.minecraft.core.net.packet.UpdatePlayerProfilePacket;
import net.minecraft.core.net.packet.UseItemPacket;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.container.Inventory;
import net.minecraft.core.player.inventory.menu.CreativeInventoryMenu;
import net.minecraft.core.player.inventory.menu.FlagMenu;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.RestHandler;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;
import net.minecraft.server.util.helper.PlayerList;
import net.minecraft.server.world.WorldServer;
import org.slf4j.Logger;

public class ServerPacketHandler
extends PacketHandler
implements ICommandListener {
    public static Logger LOGGER = LogUtils.getLogger();
    public NetworkManager netManager;
    public boolean connectionClosed = false;
    private final MinecraftServer mcServer;
    private ServerPlayer playerEntity;
    private int field_15_f;
    private int field_22004_g;
    private int playerInAirTime;
    private boolean field_22003_h;
    private double lastPosX;
    private double lastPosY;
    private double lastPosZ;
    private boolean hasMoved = true;
    private final Map<Integer, Short> guiIdMap = new HashMap<Integer, Short>();

    public ServerPacketHandler(MinecraftServer minecraftserver, NetworkManager networkManager, ServerPlayer player) {
        this.mcServer = minecraftserver;
        this.netManager = networkManager;
        networkManager.setNetHandler(this);
        this.playerEntity = player;
        player.playerNetServerHandler = this;
    }

    public void handlePackets() {
        this.field_22003_h = false;
        this.netManager.processReadPackets();
        if (this.field_15_f - this.field_22004_g > 20) {
            this.sendPacket(new KeepAlivePacket());
        }
    }

    public void kickPlayer(String s) {
        this.playerEntity.func_30002_A();
        this.sendPacket(new DisconnectPacket(s));
        this.netManager.serverShutdown();
        this.mcServer.playerList.sendPacketToAllPlayers(new ChatPacket(this.playerEntity.getDisplayName() + TextFormatting.YELLOW + " was kicked from the game."));
        this.mcServer.playerList.sendPacketToAllPlayers(new UpdatePlayerProfilePacket(this.playerEntity.username, this.playerEntity.nickname, this.playerEntity.uuid, this.playerEntity.score, this.playerEntity.chatColor, false, this.playerEntity.isOperator()));
        this.mcServer.playerList.playerLoggedOut(this.playerEntity);
        this.connectionClosed = true;
        if (MinecraftServer.statsStatus) {
            RestHandler.post("https://api.betterthanadventure.net/stats?serverToken=" + MinecraftServer.statsToken + "&count=" + this.mcServer.playerList.playerEntities.size());
        }
        PlayerList.updateList();
    }

    @Override
    public void handleSetMobSpawner(SetMobSpawnerPacket packet) {
        BlockEntity tileentity;
        WorldServer world = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        if (this.playerEntity.getGamemode() == Gamemode.creative && world.isBlockLoaded(packet.xPosition, packet.yPosition, packet.zPosition) && (tileentity = world.getBlockEntity(packet.xPosition, packet.yPosition, packet.zPosition)) instanceof MobSpawnerBlockEntity) {
            MobSpawnerBlockEntity tileEntityMobSpawner = (MobSpawnerBlockEntity)tileentity;
            tileEntityMobSpawner.setMobId(packet.spawnType);
            tileEntityMobSpawner.setChanged();
            world.markBlockNeedsUpdate(packet.xPosition, packet.yPosition, packet.zPosition);
        }
    }

    @Override
    public void handleFlying(MovePlayerPacket packet) {
        if (!this.playerEntity.isAlive()) {
            return;
        }
        WorldServer worldserver = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        this.field_22003_h = true;
        if (!this.hasMoved) {
            double d = packet.y - this.lastPosY;
            if (packet.x == this.lastPosX && d * d < 0.01 && packet.z == this.lastPosZ) {
                this.hasMoved = true;
            }
        }
        if (this.hasMoved) {
            boolean flag2;
            if (this.playerEntity.vehicle != null) {
                float f = this.playerEntity.yRot;
                float f1 = this.playerEntity.xRot;
                this.playerEntity.vehicle.positionRider();
                double d2 = this.playerEntity.x;
                double d4 = this.playerEntity.y;
                double d6 = this.playerEntity.z;
                double d8 = 0.0;
                double d9 = 0.0;
                if (packet.hasRotation) {
                    f = packet.yaw;
                    f1 = packet.pitch;
                }
                if (packet.hasPosition && packet.y == -999.0 && packet.yView == -999.0) {
                    d8 = packet.x;
                    d9 = packet.z;
                }
                this.playerEntity.onGround = packet.onGround;
                this.playerEntity.onUpdateEntity();
                this.playerEntity.move(d8, 0.0, d9);
                this.playerEntity.absMoveTo(d2, d4, d6, f, f1);
                this.playerEntity.xd = d8;
                this.playerEntity.zd = d9;
                if (this.playerEntity.vehicle != null && this.playerEntity.vehicle instanceof Entity) {
                    worldserver.func_12017_b((Entity)this.playerEntity.vehicle, true);
                }
                if (this.playerEntity.vehicle != null) {
                    this.playerEntity.vehicle.positionRider();
                }
                this.mcServer.playerList.func_613_b(this.playerEntity);
                this.lastPosX = this.playerEntity.x;
                this.lastPosY = this.playerEntity.y;
                this.lastPosZ = this.playerEntity.z;
                worldserver.updateEntity(this.playerEntity);
                return;
            }
            if (this.playerEntity.isPlayerSleeping()) {
                this.playerEntity.onUpdateEntity();
                this.playerEntity.absMoveTo(this.lastPosX, this.lastPosY, this.lastPosZ, this.playerEntity.yRot, this.playerEntity.xRot);
                worldserver.updateEntity(this.playerEntity);
                return;
            }
            double d1 = this.playerEntity.y;
            this.lastPosX = this.playerEntity.x;
            this.lastPosY = this.playerEntity.y;
            this.lastPosZ = this.playerEntity.z;
            double newPosX = this.playerEntity.x;
            double newPosY = this.playerEntity.y;
            double newPosZ = this.playerEntity.z;
            float f2 = this.playerEntity.yRot;
            float f3 = this.playerEntity.xRot;
            if (packet.hasPosition && packet.y == -999.0 && packet.yView == -999.0) {
                packet.hasPosition = false;
            }
            if (packet.hasPosition) {
                newPosX = packet.x;
                newPosY = packet.y;
                newPosZ = packet.z;
                if (Math.abs(packet.x) > 3.2E7 || Math.abs(packet.z) > 3.2E7) {
                    LOGGER.warn("{} tried to move to an illegal position", (Object)this.playerEntity.username);
                    this.teleportAndRotate(this.lastPosX, this.lastPosY, this.lastPosZ, f2, f3);
                    return;
                }
            }
            if (packet.hasRotation) {
                f2 = packet.yaw;
                f3 = packet.pitch;
            }
            this.playerEntity.onUpdateEntity();
            this.playerEntity.ySlideOffset = 0.0f;
            this.playerEntity.absMoveTo(this.lastPosX, this.lastPosY, this.lastPosZ, f2, f3);
            if (!this.hasMoved) {
                return;
            }
            double dx = newPosX - this.playerEntity.x;
            double dy = newPosY - this.playerEntity.y;
            double dz = newPosZ - this.playerEntity.z;
            double velSquared = dx * dx + dy * dy + dz * dz;
            if (velSquared > 100.0) {
                LOGGER.warn("{} moved too quickly!", (Object)this.playerEntity.username);
                this.teleportAndRotate(this.lastPosX, this.lastPosY, this.lastPosZ, f2, f3);
                return;
            }
            float f4 = 0.0625f;
            boolean flag = worldserver.getCubes(this.playerEntity, this.playerEntity.bb.copy().getInsetBoundingBox(f4, f4, f4)).size() == 0;
            this.playerEntity.move(dx, dy, dz);
            dx = newPosX - this.playerEntity.x;
            dy = newPosY - this.playerEntity.y;
            if (dy > -0.5 || dy < 0.5) {
                dy = 0.0;
            }
            dz = newPosZ - this.playerEntity.z;
            velSquared = dx * dx + dy * dy + dz * dz;
            boolean flag1 = false;
            if (!this.playerEntity.getGamemode().canPlayerFly() && velSquared > 0.0625 && !this.playerEntity.isPlayerSleeping()) {
                flag1 = true;
                LOGGER.warn("{} moved wrongly!", (Object)this.playerEntity.username);
                LOGGER.warn("Got position {}, {}, {}", newPosX, newPosY, newPosZ);
                LOGGER.warn("Expected {}, {}, {}", this.playerEntity.x, this.playerEntity.y, this.playerEntity.z);
            }
            this.playerEntity.absMoveTo(newPosX, newPosY, newPosZ, f2, f3);
            boolean bl = flag2 = worldserver.getCubes(this.playerEntity, this.playerEntity.bb.copy().getInsetBoundingBox(f4, f4, f4)).size() == 0;
            if (!(this.playerEntity.getGamemode().canPlayerFly() || !flag || !flag1 && flag2 || this.playerEntity.isPlayerSleeping())) {
                this.teleportAndRotate(this.lastPosX, this.lastPosY, this.lastPosZ, f2, f3);
                return;
            }
            AABB aabb = this.playerEntity.bb.copy().grow(f4, f4, f4).expand(0.0, -0.55, 0.0);
            if (!(this.playerEntity.getGamemode().canPlayerFly() || this.mcServer.allowFlight || worldserver.getIsAnySolidGround(aabb))) {
                if (dy > -0.03125) {
                    ++this.playerInAirTime;
                    if (this.playerInAirTime > 100) {
                        LOGGER.warn(this.playerEntity.username + " was kicked for floating too long!");
                        this.kickPlayer("Flying is not enabled on this server");
                        return;
                    }
                    if (this.playerInAirTime > 80) {
                        this.teleportAndRotate(this.lastPosX, this.lastPosY, this.lastPosZ, f2, f3);
                    }
                }
            } else {
                this.playerInAirTime = 0;
            }
            this.playerEntity.onGround = packet.onGround;
            this.mcServer.playerList.func_613_b(this.playerEntity);
            this.playerEntity.handleFalling(this.playerEntity.y - d1, packet.onGround);
        }
    }

    public void teleport(double x, double y, double z) {
        this.hasMoved = false;
        this.lastPosX = x;
        this.lastPosY = y;
        this.lastPosZ = z;
        this.playerEntity.absMoveTo(x, y, z, this.playerEntity.yRot, this.playerEntity.xRot);
        this.playerEntity.playerNetServerHandler.sendPacket(new MovePlayerPacket.Pos(x, y + 1.625, y, z, false));
    }

    public void teleportAndRotate(double x, double y, double z, float yaw, float pitch) {
        this.hasMoved = false;
        this.lastPosX = x;
        this.lastPosY = y;
        this.lastPosZ = z;
        this.playerEntity.absMoveTo(x, y, z, yaw, pitch);
        this.playerEntity.playerNetServerHandler.sendPacket(new MovePlayerPacket.PosRot(x, y + 1.625, y, z, yaw, pitch, false));
    }

    @Override
    public void handleBlockDig(PlayerActionPacket packet) {
        int spawnDistZ;
        int x = packet.xPosition;
        int y = packet.yPosition;
        int z = packet.zPosition;
        if (!this.playerEntity.getGamemode().canInteract() || !this.playerEntity.isAlive()) {
            return;
        }
        WorldServer world = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        if (packet.status == 4) {
            this.playerEntity.dropCurrentItem(false);
            return;
        }
        if (packet.status == 5) {
            this.playerEntity.dropCurrentItem(true);
            return;
        }
        if (packet.status == 6) {
            this.playerEntity.pickBlock(x, y, z);
            return;
        }
        double playerDistX = this.playerEntity.x - ((double)x + 0.5);
        double playerDistY = this.playerEntity.y - ((double)y + 0.5);
        double playerDistZ = this.playerEntity.z - ((double)z + 0.5);
        double playerDist = playerDistX * playerDistX + playerDistY * playerDistY + playerDistZ * playerDistZ;
        if (playerDist > 44.0) {
            return;
        }
        world.field_819_z = this.mcServer.spawnProtectionRange <= 0 || world.dimension.id != 0 || this.mcServer.playerList.isOp(this.playerEntity.uuid);
        boolean ignoreSpawnProtection = world.field_819_z;
        ChunkCoordinates spawnPos = world.getSpawnPoint();
        int spawnDistX = (int)MathHelper.abs(x - spawnPos.x);
        int distanceFromSpawn = Math.max(spawnDistX, spawnDistZ = (int)MathHelper.abs(z - spawnPos.z));
        if (distanceFromSpawn <= this.mcServer.spawnProtectionRange && !ignoreSpawnProtection) {
            this.playerEntity.playerNetServerHandler.sendPacket(new BlockUpdatePacket(x, y, z, world));
            world.field_819_z = false;
            return;
        }
        if (packet.status == 0) {
            this.playerEntity.playerController.startMining(x, y, z, packet.side);
        } else if (packet.status == 1) {
            this.playerEntity.playerController.hitBlock(x, y, z, packet.side, packet.xHit, packet.yHit);
        } else if (packet.status == 2 && !this.playerEntity.playerController.destroyBlock(x, y, z, packet.side)) {
            this.playerEntity.playerNetServerHandler.sendPacket(new BlockUpdatePacket(x, y, z, world));
        }
        world.field_819_z = false;
    }

    public void handleSendInitialPlayerList() {
        for (ServerPlayer serverPlayer : this.mcServer.playerList.playerEntities) {
            this.sendPacket(new UpdatePlayerProfilePacket(serverPlayer.username, serverPlayer.nickname, serverPlayer.uuid, serverPlayer.score, serverPlayer.chatColor, true, serverPlayer.isOperator()));
        }
    }

    @Override
    public void handlePlace(UseItemPacket packet) {
        if (!this.playerEntity.getGamemode().canInteract() || !this.playerEntity.isAlive()) {
            return;
        }
        WorldServer worldserver = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        ItemStack itemstack = this.playerEntity.inventory.getCurrentItem();
        worldserver.field_819_z = worldserver.dimension.id != 0 || this.mcServer.playerList.isOp(this.playerEntity.uuid);
        boolean flag = worldserver.field_819_z;
        if (packet.direction == Direction.NONE) {
            if (itemstack == null) {
                return;
            }
            this.playerEntity.playerController.func_6154_a(this.playerEntity, worldserver, itemstack);
        } else {
            int j1;
            int x = packet.xPosition;
            int y = packet.yPosition;
            int z = packet.zPosition;
            Direction direction = packet.direction;
            double xPlaced = packet.xPlaced;
            double yPlaced = packet.yPlaced;
            ChunkCoordinates chunkcoordinates = worldserver.getSpawnPoint();
            int i1 = (int)MathHelper.abs(x - chunkcoordinates.x);
            if (i1 > (j1 = (int)MathHelper.abs(z - chunkcoordinates.z))) {
                j1 = i1;
            }
            if (this.hasMoved && this.playerEntity.distanceToSqr((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) < 64.0 && (j1 > this.mcServer.spawnProtectionRange || flag)) {
                this.playerEntity.playerController.activateBlockOrUseItem(this.playerEntity, worldserver, itemstack, x, y, z, direction.getSide(), xPlaced, yPlaced);
            }
            this.playerEntity.playerNetServerHandler.sendPacket(new BlockUpdatePacket(x, y, z, worldserver));
            this.playerEntity.playerNetServerHandler.sendPacket(new BlockUpdatePacket(x += direction.getOffsetX(), y += direction.getOffsetY(), z += direction.getOffsetZ(), worldserver));
        }
        itemstack = this.playerEntity.inventory.getCurrentItem();
        if (itemstack != null && itemstack.stackSize <= 0) {
            this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.currentItem] = null;
        }
        this.playerEntity.isChangingQuantityOnly = true;
        this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.currentItem] = ItemStack.copyItemStack(this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.currentItem]);
        Slot slot = this.playerEntity.craftingInventory.getSlotFor(this.playerEntity.inventory, this.playerEntity.inventory.currentItem);
        this.playerEntity.craftingInventory.broadcastChanges();
        this.playerEntity.isChangingQuantityOnly = false;
        if (!ItemStack.areItemStacksEqual(this.playerEntity.inventory.getCurrentItem(), packet.itemStack)) {
            this.sendPacket(new ContainerSetSlotPacket(this.playerEntity.craftingInventory.containerId, slot.index, this.playerEntity.inventory.getCurrentItem()));
        }
        worldserver.field_819_z = false;
    }

    @Override
    public void handleErrorMessage(String s, Object[] aobj) {
        LOGGER.info(this.playerEntity.username + " lost connection: " + s);
        this.mcServer.playerList.sendPacketToAllPlayers(new ChatPacket(this.playerEntity.getDisplayName() + TextFormatting.YELLOW + " left the game."));
        this.mcServer.playerList.sendPacketToAllPlayers(new UpdatePlayerProfilePacket(this.playerEntity.username, this.playerEntity.nickname, this.playerEntity.uuid, this.playerEntity.score, this.playerEntity.chatColor, false, this.playerEntity.isOperator()));
        this.mcServer.playerList.playerLoggedOut(this.playerEntity);
        this.connectionClosed = true;
        if (MinecraftServer.statsStatus) {
            RestHandler.post("https://api.betterthanadventure.net/stats?serverToken=" + MinecraftServer.statsToken + "&count=" + this.mcServer.playerList.playerEntities.size());
        }
        PlayerList.updateList();
    }

    @Override
    public void handleInvalidPacket(Packet packet) {
        LOGGER.warn(this.getClass() + " wasn't prepared to deal with a " + packet.getClass());
        this.kickPlayer("Protocol error, unexpected packet");
    }

    public void sendPacket(Packet packet) {
        this.netManager.addToSendQueue(packet);
        this.field_22004_g = this.field_15_f;
    }

    @Override
    public void handleBlockItemSwitch(SetCarriedItemPacket packet) {
        if (packet.id < 0 || packet.id > Inventory.func_25054_e()) {
            LOGGER.warn(this.playerEntity.username + " tried to set an invalid carried item");
            return;
        }
        this.playerEntity.inventory.currentItem = packet.id;
    }

    @Override
    public void handleChat(ChatPacket packet) {
        String message;
        if (packet.encrypted) {
            try {
                message = AES.decrypt(packet.message, AES.keyChain.get(this.playerEntity.username));
            }
            catch (Exception e) {
                throw new RuntimeException("This crash is caused by outdated Java, please update to 8u161 or newer! If your Java version is out of date due to a technical requirement, please add the JCE Unlimited Strength Jurisdiction Policy Files to your installation. https://www.oracle.com/java/technologies/javase-jce-all-downloads.html", e);
            }
        } else {
            message = packet.message;
        }
        if (message.length() > 256) {
            message = message.substring(0, 255);
        }
        message = message.trim();
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c) >= 0) continue;
            this.sendPacket(new ChatPacket(String.valueOf(TextFormatting.GRAY) + TextFormatting.ITALIC + "[SERVER] Illegal characters in chat message."));
            return;
        }
        if (message.startsWith("/")) {
            this.handleSlashCommand(message);
        } else {
            message = ChatEmotes.process(message);
            message = "<" + this.playerEntity.getDisplayName() + TextFormatting.RESET + "> " + TextFormatting.WHITE + message;
            LOGGER.info(message);
            this.mcServer.playerList.sendEncryptedChatToAllPlayers(message);
        }
    }

    private void handleSlashCommand(String s) {
        ServerPlayerCommandSender sender = new ServerPlayerCommandSender(this.mcServer, this.playerEntity);
        ServerCommandHandler handler = new ServerCommandHandler(this.mcServer);
        String[] args = s.substring(1).split(" ");
        String[] args1 = new String[args.length - 1];
        System.arraycopy(args, 1, args1, 0, args.length - 1);
        for (Command command : Commands.commands) {
            if (!command.isName(args[0])) continue;
            if (!sender.isAdmin() && command.opRequired(args1)) {
                LOGGER.info("Player {} tried command: {}", (Object)((PlayerCommandSender)sender).getPlayer().username, (Object)s);
                sender.sendMessage(TextFormatting.RED + "You don't have permission to use this command!");
                return;
            }
            LOGGER.info("Player {} used command: {}", (Object)((PlayerCommandSender)sender).getPlayer().username, (Object)s);
            try {
                boolean success = command.execute(handler, sender, args1);
                if (!success) {
                    command.sendCommandSyntax(handler, sender);
                }
            }
            catch (CommandError e) {
                sender.sendMessage(TextFormatting.RED + e.getMessage());
            }
            catch (Throwable e) {
                LOGGER.error("Exception while trying to perform command '{}'!", (Object)s, (Object)e);
                sender.sendMessage(TextFormatting.RED + "Error!");
            }
            return;
        }
        sender.sendMessage(TextFormatting.RED + "Command '" + args[0] + "' does not exist!");
    }

    @Override
    public void handleAnimation(AnimatePacket packet) {
        if (!this.playerEntity.isAlive()) {
            return;
        }
        if (packet.animate == 1) {
            this.playerEntity.swingItem();
        }
    }

    @Override
    public void handleEntityAction(PlayerCommandPacket packet) {
        if (!this.playerEntity.isAlive()) {
            return;
        }
        if (packet.state == 1) {
            this.playerEntity.setSneaking(true);
        } else if (packet.state == 2) {
            this.playerEntity.setSneaking(false);
        } else if (packet.state == 3) {
            this.playerEntity.wakeUpPlayer(false, true);
            this.hasMoved = false;
        }
    }

    @Override
    public void handleBoatControl(BoatControlPacket boatControlPacket) {
        if (!this.playerEntity.getGamemode().canInteract() || !this.playerEntity.isAlive()) {
            return;
        }
        if (this.playerEntity.vehicle != null && this.playerEntity.vehicle instanceof BoatEntity) {
            BoatEntity boat = (BoatEntity)this.playerEntity.vehicle;
            boat.handleControlDirect(boatControlPacket.targetXD, boatControlPacket.targetZD, boatControlPacket.targetYRot);
            boatControlPacket.entityId = boat.id;
            this.mcServer.playerList.sendPacketToOtherPlayersAroundPoint(this.playerEntity, boat.x, boat.y, boat.z, 128.0, boat.world.dimension.id, boatControlPacket);
        }
    }

    @Override
    public void handleKickDisconnect(DisconnectPacket packet) {
        this.netManager.networkShutdown("disconnect.quitting", new Object[0]);
    }

    public int getNumChunkDataPackets() {
        return this.netManager.getNumChunkDataPackets();
    }

    @Override
    public void logInfo(String s) {
        this.sendPacket(new ChatPacket("\u00a77" + s));
    }

    @Override
    public String getUsername() {
        return this.playerEntity.username;
    }

    @Override
    public void handleUseEntity(InteractPacket packet) {
        if (!this.playerEntity.getGamemode().canInteract() || !this.playerEntity.isAlive()) {
            return;
        }
        WorldServer worldserver = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        Entity targetEntity = worldserver.getEntityFromId(packet.targetEntityID);
        if (targetEntity != null && this.playerEntity.distanceToSqr(targetEntity) < 36.0) {
            boolean canAttack = this.playerEntity.canEntityBeSeen(targetEntity);
            if (!canAttack) {
                float f1 = MathHelper.cos(-this.playerEntity.yRot * 0.01745329f - (float)Math.PI);
                float f2 = MathHelper.sin(-this.playerEntity.yRot * 0.01745329f - (float)Math.PI);
                float f3 = -MathHelper.cos(-this.playerEntity.xRot * 0.01745329f);
                float f4 = MathHelper.sin(-this.playerEntity.xRot * 0.01745329f);
                Vec3 viewVector = Vec3.getTempVec3(f2 * f3, f4, f1 * f3);
                viewVector.x *= 8.0;
                viewVector.y *= 8.0;
                viewVector.z *= 8.0;
                viewVector.x += this.playerEntity.x;
                viewVector.y += this.playerEntity.y;
                viewVector.z += this.playerEntity.z;
                Vec3 playerViewPos = Vec3.getTempVec3(this.playerEntity.x, this.playerEntity.y + (double)this.playerEntity.getHeadHeight(), this.playerEntity.z);
                HitResult movingObjectPosition = targetEntity.bb.clip(playerViewPos, viewVector);
                boolean bl = canAttack = movingObjectPosition != null && worldserver.checkBlockCollisionBetweenPoints(playerViewPos, movingObjectPosition.location) == null;
            }
            if (canAttack) {
                if (packet.action == 0) {
                    this.playerEntity.useCurrentItemOnEntity(targetEntity);
                } else if (packet.action == 1) {
                    this.playerEntity.attackTargetEntityWithCurrentItem(targetEntity);
                }
            }
        }
    }

    @Override
    public void handleOpenGuidebook(GuidebookPacket packet) {
        this.playerEntity.displayGUIGuidebook();
    }

    @Override
    public void handleRespawn(RespawnPacket packet) {
        if (this.playerEntity.getHealth() <= 0) {
            this.playerEntity = this.mcServer.playerList.recreatePlayerEntity(this.playerEntity, 0);
        }
    }

    @Override
    public void handleCloseWindow(ContainerClosePacket packet) {
        this.playerEntity.closeCraftingGui();
    }

    @Override
    public void handleWindowClick(ContainerClickPacket packet) {
        if (this.playerEntity.craftingInventory.containerId == packet.window_Id && this.playerEntity.craftingInventory.isSynched(this.playerEntity)) {
            ItemStack itemstack = this.playerEntity.craftingInventory.clicked(packet.action, packet.args, this.playerEntity);
            if (ItemStack.areItemStacksEqual(packet.itemStack, itemstack)) {
                this.playerEntity.playerNetServerHandler.sendPacket(new ContainerAckPacket(packet.window_Id, packet.actionId, true));
                this.playerEntity.isChangingQuantityOnly = true;
                this.playerEntity.craftingInventory.broadcastChanges();
                this.playerEntity.updateHeldItem();
                this.playerEntity.isChangingQuantityOnly = false;
            } else {
                this.guiIdMap.put(this.playerEntity.craftingInventory.containerId, packet.actionId);
                this.playerEntity.playerNetServerHandler.sendPacket(new ContainerAckPacket(packet.window_Id, packet.actionId, false));
                this.playerEntity.craftingInventory.setSynched(this.playerEntity, false);
                ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
                for (int i = 0; i < this.playerEntity.craftingInventory.slots.size(); ++i) {
                    arraylist.add(this.playerEntity.craftingInventory.slots.get(i).getItem());
                }
                this.playerEntity.updateCraftingInventory(this.playerEntity.craftingInventory, arraylist);
            }
        }
    }

    @Override
    public void handleTransaction(ContainerAckPacket packet) {
        Short short1 = this.guiIdMap.get(this.playerEntity.craftingInventory.containerId);
        if (short1 != null && packet.shortWindowId == short1 && this.playerEntity.craftingInventory.containerId == packet.windowId && !this.playerEntity.craftingInventory.isSynched(this.playerEntity)) {
            this.playerEntity.craftingInventory.setSynched(this.playerEntity, true);
        }
    }

    @Override
    public void handleUpdateSign(SignUpdatePacket packet) {
        if (!this.playerEntity.getGamemode().canInteract() || !this.playerEntity.isAlive()) {
            return;
        }
        WorldServer worldserver = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        if (worldserver.isBlockLoaded(packet.xPosition, packet.yPosition, packet.zPosition)) {
            SignBlockEntity sign;
            BlockEntity blockEntity = worldserver.getBlockEntity(packet.xPosition, packet.yPosition, packet.zPosition);
            if (blockEntity instanceof SignBlockEntity && !(sign = (SignBlockEntity)blockEntity).isEditableBy(this.playerEntity)) {
                LOGGER.warn("Player {} just tried to change non-editable sign", (Object)this.playerEntity.username);
                return;
            }
            for (int i = 0; i < 4; ++i) {
                boolean isLineValid = true;
                if (packet.signLines[i].length() > 15) {
                    isLineValid = false;
                } else {
                    packet.signLines[i] = packet.signLines[i].replaceAll("\u00a7", "$");
                    for (int l = 0; l < packet.signLines[i].length(); ++l) {
                        if (ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(packet.signLines[i].charAt(l)) >= 0) continue;
                        isLineValid = false;
                        break;
                    }
                }
                if (isLineValid) continue;
                packet.signLines[i] = "!?";
            }
            if (blockEntity instanceof SignBlockEntity) {
                int x = packet.xPosition;
                int y = packet.yPosition;
                int z = packet.zPosition;
                SignBlockEntity tileEntity = (SignBlockEntity)blockEntity;
                System.arraycopy(packet.signLines, 0, tileEntity.signText, 0, 4);
                tileEntity.setColor(TextFormatting.FORMATTINGS[packet.color]);
                tileEntity.setPicture(EnumSignPicture.values()[packet.picture]);
                tileEntity.setChanged();
                worldserver.markBlockNeedsUpdate(x, y, z);
            }
        }
    }

    @Override
    public void handleUpdateCreativeInventory(UpdateCreativeInventoryPacket packet) {
        if (this.playerEntity.craftingInventory.containerId == packet.windowId && this.playerEntity.craftingInventory instanceof CreativeInventoryMenu) {
            ((CreativeInventoryMenu)this.playerEntity.craftingInventory).setInventoryStatus(packet.page, packet.searchText);
        }
    }

    @Override
    public void handleSetHotbarOffset(SetHotbarOffsetPacket packet) {
        this.playerEntity.inventory.hotbarOffset = packet.hotbarOffset;
    }

    @Override
    public void handleItemName(SetItemNamePacket packet) {
        String name = packet.name;
        if (name.length() > 16) {
            name = packet.name.substring(0, 16);
        }
        this.playerEntity.inventory.getItem(packet.slot).setCustomName(name);
    }

    @Override
    public void handleSetPaintingMotive(SetPaintingArtPacket packet) {
        this.playerEntity.setSelectedArt(ArtType.values.get(packet.motive));
    }

    @Override
    public void handleCustomPayload(CustomPayloadPacket packet) {
        if ("BTA|RotationLock".equals(packet.channel)) {
            if (packet.data.length == 4) {
                this.playerEntity.rotationLock = Direction.getDirectionById(packet.data[0]);
                this.playerEntity.rotationLockHorizontal = Direction.getDirectionById(packet.data[1]);
                this.playerEntity.rotationLockVertical = Direction.getDirectionById(packet.data[2]);
                this.playerEntity.placementModeOverride = PlacementMode.get(packet.data[3]);
            }
        } else if ("BTA|Flag".equals(packet.channel)) {
            if (packet.data.length == 384 && this.playerEntity.craftingInventory instanceof FlagMenu) {
                FlagMenu flagMenu = (FlagMenu)this.playerEntity.craftingInventory;
                FlagBlockEntity flag = flagMenu.flag;
                if (flag.owner == null || flag.owner.equals(this.playerEntity.uuid)) {
                    flag.owner = this.playerEntity.uuid;
                    System.arraycopy(packet.data, 0, flag.flagColors, 0, 384);
                    this.playerEntity.world.markBlockNeedsUpdate(flag.x, flag.y, flag.z);
                } else {
                    LOGGER.warn("Player '{}' tried editing a flag that belongs to '{}'!", (Object)this.playerEntity.username, (Object)flag.owner);
                    this.playerEntity.world.markBlockNeedsUpdate(flag.x, flag.y, flag.z);
                }
            }
        } else if ("BTA|WandMonster".equals(packet.channel) && this.playerEntity.getHeldItem() != null && this.playerEntity.getHeldItem().getItem() == Items.WAND_MONSTER_SPAWNER) {
            String id = new String(packet.data, StandardCharsets.UTF_8);
            this.playerEntity.getHeldItem().getData().putString("monster", id);
        }
    }

    @Override
    public boolean isServerHandler() {
        return true;
    }
}

