/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.mojang.logging.LogUtils;
import java.util.Properties;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.useless.seedviewer.gui.SeedViewer;

public class SeedViewerMain {
    public static final String VERSION = "1.1.1";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void main(String[] args) {
        try {
            Class.forName("net.minecraft.core.world.biome.provider.BiomeProviderOverworld");
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Could not locate BTA jar! Canceling Startup!", e);
            return;
        }
        try {
            UIManager.setLookAndFeel(new FlatDarculaLaf());
        }
        catch (Exception ex) {
            LOGGER.error("Failed to initialize LaF theme!", ex);
        }
        new SeedViewer(SeedViewerMain.argsToProperties(args));
    }

    @NotNull
    public static Properties argsToProperties(String[] args) {
        Properties properties = new Properties();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                String key = arg.substring(1);
                if (key.isEmpty() || i >= args.length - 1) continue;
                String value = args[++i];
                properties.setProperty(key, value);
                continue;
            }
            LOGGER.error("Unrecognized argument '{}'!", (Object)arg);
        }
        return properties;
    }
}

