/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt;

import com.mojang.nbt.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LongArrayTag
extends Tag<long[]> {
    public LongArrayTag() {
        this.setValue(new long[0]);
    }

    public LongArrayTag(long[] array) {
        super(array);
    }

    @Override
    void write(DataOutput dos) throws IOException {
        dos.writeInt(((long[])this.getValue()).length);
        byte[] bytes = new byte[((long[])this.getValue()).length * 4];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer().put((long[])this.getValue());
        dos.write(bytes);
    }

    @Override
    void read(DataInput dis) throws IOException {
        int length = dis.readInt();
        this.setValue(new long[length]);
        byte[] bytes = new byte[length * 4];
        dis.readFully(bytes);
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer().get((long[])this.getValue());
    }

    @Override
    public byte getId() {
        return 13;
    }
}

