/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity;

import com.b100.utils.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.entity.SkinVariantList;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ClientSkinVariantList
extends SkinVariantList {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int MAX_VARIANT_ID = 255;
    private final Minecraft mc;
    private final Map<String, @Nullable EntityVariants> variantProcessorMap = new HashMap<String, EntityVariants>();

    public ClientSkinVariantList(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void refresh(List<Throwable> errors) {
        this.variantProcessorMap.clear();
    }

    @Override
    @NotNull
    public String getSkinReference(@Nullable String variantJsonPath, @NotNull String defaultKey, int skinIndex) {
        try {
            EntityVariants var;
            if (!((Boolean)Minecraft.getMinecraft((Object)this).gameSettings.mobVariants.value).booleanValue()) {
                return defaultKey;
            }
            if (variantJsonPath == null) {
                return defaultKey;
            }
            if (!this.variantProcessorMap.containsKey(variantJsonPath)) {
                this.loadJson(variantJsonPath);
            }
            if ((var = this.variantProcessorMap.get(variantJsonPath)) != null) {
                return var.getKeyFromIndex(skinIndex);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load json at '{}'!", (Object)variantJsonPath, (Object)e);
            this.variantProcessorMap.put(variantJsonPath, null);
            e.printStackTrace();
        }
        return defaultKey;
    }

    /*
     * Unable to fully structure code
     */
    public void loadJson(String variantJsonPath) {
        block22: {
            try {
                block23: {
                    block26: {
                        block27: {
                            block24: {
                                block25: {
                                    block20: {
                                        block21: {
                                            stream = this.mc.texturePackList.getResourceAsStream(variantJsonPath);
                                            if (stream != null) break block20;
                                            if (stream == null) break block21;
                                            stream.close();
                                        }
                                        return;
                                    }
                                    try {
                                        jsonString = StringUtils.readInputString(stream);
                                    }
                                    catch (Exception e) {
                                        ClientSkinVariantList.LOGGER.error("Failed to parse '{}' as a Json String!", (Object)variantJsonPath, (Object)e);
                                        if (stream != null) {
                                            stream.close();
                                        }
                                        break block22;
                                    }
                                    variantObject = JsonParser.parseString(jsonString).getAsJsonObject();
                                    if (!variantObject.has("skins")) break block23;
                                    skins = variantObject.get("skins");
                                    if (!skins.isJsonPrimitive()) break block24;
                                    this.variantProcessorMap.put(variantJsonPath, new EntityVariants(skins.getAsInt()));
                                    if (stream == null) break block25;
                                    stream.close();
                                }
                                return;
                            }
                            if (!skins.isJsonArray()) break block26;
                            variants = new ArrayList<EntityVariants.VariantEntry>();
                            arr = skins.getAsJsonArray();
                            for (JsonElement e : arr) {
                                entryObj = e.getAsJsonObject();
                                textureReference = entryObj.get("texture").getAsString();
                                weight = 1.0;
                                if (entryObj.has("weight")) {
                                    weight = entryObj.get("weight").getAsDouble();
                                }
                                variants.add(new EntityVariants.VariantEntry(textureReference, weight));
                            }
                            this.variantProcessorMap.put(variantJsonPath, new EntityVariants(variants));
                            if (stream == null) break block27;
                            stream.close();
                        }
                        return;
                    }
                    ClientSkinVariantList.LOGGER.error("Error at {}: value 'skins' must either be a integer or an array!", (Object)variantJsonPath);
                    ** if (stream == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        stream.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block22;
                    }
                }
                try {
                    break block22;
                    catch (JsonParseException e) {
                        ClientSkinVariantList.LOGGER.error("Failed to parse Json at {}", (Object)variantJsonPath, (Object)e);
                    }
                }
                catch (Throwable var3_5) {
                    throw var3_5;
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (IOException e) {
                ClientSkinVariantList.LOGGER.error("IO Exception while trying to read '{}'!", (Object)variantJsonPath, (Object)e);
            }
        }
        this.variantProcessorMap.put(variantJsonPath, null);
    }

    protected static class EntityVariants {
        private final VariantEntry[] variantEntries;
        private final int skins;

        public EntityVariants(int skins) {
            if (skins <= 0) {
                throw new IllegalArgumentException("Skins number attribute must be at-least 1!");
            }
            this.skins = skins;
            this.variantEntries = null;
        }

        public EntityVariants(List<VariantEntry> entries) {
            block7: {
                this.variantEntries = new VariantEntry[256];
                this.skins = -1;
                double accWeight = 0.0;
                entries.sort(Comparator.comparingDouble(o -> -o.weight));
                for (VariantEntry variantEntry : entries) {
                    accWeight += variantEntry.weight;
                }
                int pointer = 0;
                for (VariantEntry e : entries) {
                    int amount = MathHelper.floor(e.weight / accWeight * 255.0);
                    if (amount < 1) {
                        amount = 1;
                    }
                    for (int i = 0; i < amount; ++i) {
                        this.variantEntries[pointer] = e;
                        if (++pointer <= this.variantEntries.length - 1) {
                            continue;
                        }
                        break block7;
                    }
                }
                VariantEntry variantEntry = entries.get(0);
                while (pointer < this.variantEntries.length) {
                    this.variantEntries[pointer] = variantEntry;
                    ++pointer;
                }
            }
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            for (VariantEntry e : this.variantEntries) {
                counts.putIfAbsent(e.textureKey, 0);
                counts.put(e.textureKey, (Integer)counts.get(e.textureKey) + 1);
            }
        }

        public String getKeyFromIndex(int index) {
            if (this.variantEntries != null) {
                return this.variantEntries[index].textureKey;
            }
            return String.valueOf(index % this.skins);
        }

        protected static class VariantEntry {
            public final String textureKey;
            public final double weight;

            public VariantEntry(String key, double weight) {
                this.textureKey = key;
                this.weight = weight;
            }
        }
    }
}

