/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class FluidDripParticle
extends Particle {
    float maxSize;
    boolean fullBright;

    public FluidDripParticle(World world, double x, double y, double z, int color, IconCoordinate texture) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.tex = texture;
        this.gravity = 0.125f;
        this.size /= 4.0f;
        this.maxSize = this.size;
        this.size = 0.0f;
        this.lifetime = (int)((float)this.lifetime * 16.0f);
        this.yd = 0.0;
        this.xd = 0.0;
        this.zd = 0.0;
        this.rCol = (float)Color.redFromInt(color) / 255.0f;
        this.gCol = (float)Color.greenFromInt(color) / 255.0f;
        this.bCol = (float)Color.blueFromInt(color) / 255.0f;
    }

    @Override
    public int getParticleTexture() {
        return 1;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        if (this.age < this.lifetime / 4) {
            float particleProgress = (float)this.age / ((float)this.lifetime / 4.0f);
            this.size = this.maxSize * particleProgress;
            this.gravity = 0.0f;
        } else {
            this.gravity = 0.5f;
            this.yd -= 0.04 * (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if (this.onGround) {
                this.xd *= 0.7;
                this.zd *= 0.7;
            }
        }
    }

    @Override
    public void render(Tessellator t, float partialTick, double xOff, double yOff, double zOff, float xa, float ya, float za, float xa2, float za2) {
        if (this.tex == null) {
            return;
        }
        float u0 = (float)this.tex.getSubIconU(this.uo / 4.0f);
        float u2 = (float)this.tex.getSubIconU(this.uo / 4.0f + 0.25f);
        float v0 = (float)this.tex.getSubIconV(this.vo / 4.0f);
        float v2 = (float)this.tex.getSubIconV(this.vo / 4.0f + 0.25f);
        float r = 0.1f * this.size;
        float x = (float)(this.xo + (this.x - this.xo) * (double)partialTick - xOff);
        float y = (float)(this.yo + (this.y - this.yo) * (double)partialTick - yOff);
        float z = (float)(this.zo + (this.z - this.zo) * (double)partialTick - zOff);
        float br = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            t.setLightmapCoord(this.getLightmapCoord(partialTick));
        } else {
            br = this.getBrightness(partialTick);
        }
        t.setColorOpaque_F(this.rCol * br, this.gCol * br, this.bCol * br);
        t.addVertexWithUV(x - xa * r - xa2 * r, y - ya * r, z - za * r - za2 * r, u2, v2);
        t.addVertexWithUV(x - xa * r + xa2 * r, y + ya * r, z - za * r + za2 * r, u2, v0);
        t.addVertexWithUV(x + xa * r + xa2 * r, y + ya * r, z + za * r + za2 * r, u0, v0);
        t.addVertexWithUV(x + xa * r - xa2 * r, y - ya * r, z + za * r - za2 * r, u0, v2);
    }

    public FluidDripParticle setFullBright() {
        this.fullBright = true;
        return this;
    }

    @Override
    public float getBrightness(float partialTick) {
        if (this.fullBright) {
            return 1.0f;
        }
        return super.getBrightness(partialTick);
    }

    @Override
    public int getLightmapCoord(float partialTick) {
        if (this.fullBright) {
            int blockX = MathHelper.floor(this.x);
            double d = (this.bb.maxY - this.bb.minY) * 0.66;
            int blockY = MathHelper.floor(this.y - (double)this.heightOffset + d);
            int blockZ = MathHelper.floor(this.z);
            return LightmapHelper.getOverbrightLightmapCoord(this.world.getSavedLightValue(LightLayer.Sky, blockX, blockY, blockZ));
        }
        return super.getLightmapCoord(partialTick);
    }
}

