/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class NoteParticle
extends Particle {
    private final float oSize;

    public NoteParticle(World world, double x, double y, double z, double xa, double ya, double za) {
        this(world, x, y, z, xa, ya, za, 2.0f);
    }

    public NoteParticle(World world, double x, double y, double z, double xa, double ya, double za, float scale) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.xd *= 0.01;
        this.yd *= 0.01;
        this.zd *= 0.01;
        this.yd += 0.2;
        this.rCol = MathHelper.sin(((float)xa + 0.0f) * (float)Math.PI * 2.0f) * 0.65f + 0.35f;
        this.gCol = MathHelper.sin(((float)xa + 0.33333334f) * (float)Math.PI * 2.0f) * 0.65f + 0.35f;
        this.bCol = MathHelper.sin(((float)xa + 0.6666667f) * (float)Math.PI * 2.0f) * 0.65f + 0.35f;
        this.size *= 0.75f;
        this.size *= scale;
        this.oSize = this.size;
        this.lifetime = 6;
        this.noPhysics = false;
        this.tex = TextureRegistry.getTexture("minecraft:particle/note");
    }

    @Override
    public void render(Tessellator t, float partialTick, double xOff, double yOff, double zOff, float xa, float ya, float za, float xa2, float za2) {
        float l = ((float)this.age + partialTick) / (float)this.lifetime * 32.0f;
        if (l < 0.0f) {
            l = 0.0f;
        }
        if (l > 1.0f) {
            l = 1.0f;
        }
        this.size = this.oSize * l;
        super.render(t, partialTick, xOff, yOff, zOff, xa, ya, za, xa2, za2);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.move(this.xd, this.yd, this.zd);
        if (this.y == this.yo) {
            this.xd *= 1.1;
            this.zd *= 1.1;
        }
        this.xd *= 0.66;
        this.yd *= 0.66;
        this.zd *= 0.66;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }
}

