/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.item.Item;
import net.minecraft.core.world.World;

public class SlimeChunkParticle
extends Particle {
    public SlimeChunkParticle(World world, double x, double y, double z, Item item) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.tex = ((ItemModel)ItemModelDispatcher.getInstance().getDispatch(item)).getIcon(null, item.getDefaultStack());
        this.gravity = 2.0f;
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.size /= 2.0f;
        this.lifetime = 50;
    }

    @Override
    public int getParticleTexture() {
        return 2;
    }

    @Override
    public void render(Tessellator t, float partialTick, double xOff, double yOff, double zOff, float xa, float ya, float za, float xa2, float za2) {
        float u0 = (float)this.tex.getSubIconU(this.uo / 4.0f);
        float u2 = (float)this.tex.getSubIconU(0.25f + this.uo / 4.0f);
        float v0 = (float)this.tex.getSubIconV(this.uo / 4.0f);
        float v2 = (float)this.tex.getSubIconV(0.25f + this.uo / 4.0f);
        float r = 0.1f * this.size;
        float x = (float)(this.xo + (this.x - this.xo) * (double)partialTick - xOff);
        float y = (float)(this.yo + (this.y - this.yo) * (double)partialTick - yOff);
        float z = (float)(this.zo + (this.z - this.zo) * (double)partialTick - zOff);
        float br = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            t.setLightmapCoord(this.getLightmapCoord(partialTick));
        } else {
            br = this.getBrightness(partialTick);
        }
        t.setColorOpaque_F(br * this.rCol, br * this.gCol, br * this.bCol);
        t.addVertexWithUV(x - xa * r - xa2 * r, y - ya * r, z - za * r - za2 * r, u0, v2);
        t.addVertexWithUV(x - xa * r + xa2 * r, y + ya * r, z - za * r + za2 * r, u0, v0);
        t.addVertexWithUV(x + xa * r + xa2 * r, y + ya * r, z + za * r + za2 * r, u2, v0);
        t.addVertexWithUV(x + xa * r - xa2 * r, y - ya * r, z + za * r - za2 * r, u2, v2);
    }
}

