/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.elements.IListenerElement;
import net.minecraft.client.gui.modelviewer.elements.ListenerButtonElement;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.client.util.helper.Textures;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.Utils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class TextureViewerScreen
extends Screen {
    private static final int TOP_SPACING = 24;
    private static final int BUTTON_SPACING = 4;
    protected int top;
    protected int bottom;
    protected ListenerButtonElement leftTexCycle;
    protected int texIndex = 0;
    protected boolean drawCheckers = true;
    protected boolean flip = false;
    protected boolean drawText = true;

    public TextureViewerScreen(Screen parent) {
        super(parent);
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_LEFT) {
            this.cycleTexture(-1);
        } else if (eventKey == Keyboard.KEY_RIGHT) {
            this.cycleTexture(1);
        } else if (eventKey == Keyboard.KEY_ESCAPE) {
            this.mc.displayScreen(this.parentScreen);
        }
        ArrayList _buttons = new ArrayList(this.buttons);
        for (ButtonElement button : _buttons) {
            if (!(button instanceof IListenerElement) || !button.isHovered(mx, my)) continue;
            ((IListenerElement)((Object)button)).onKeyTyped(eventCharacter, eventKey);
        }
    }

    @Override
    public void tick() {
        ArrayList _buttons = new ArrayList(this.buttons);
        for (ButtonElement button : _buttons) {
            if (!(button instanceof ListenerButtonElement)) continue;
            ((ListenerButtonElement)button).tick();
        }
    }

    @Override
    public void init() {
        this.top = 24;
        this.bottom = this.height - 28;
        this.add(new ListenerButtonElement(0, this.width / 2 - 100, this.height - 24, 200, 20, I18n.getInstance().translateKey("gui.options.button.done")).setActionListener(() -> {
            this.removed();
            this.mc.displayScreen(null);
        }));
        this.leftTexCycle = this.add(new ListenerButtonElement(1, this.width - 48, this.bottom - 24, 20, 20, "<").setActionListener(() -> this.cycleTexture(-1)));
        this.add(new ListenerButtonElement(2, this.width - 24, this.bottom - 24, 20, 20, ">").setActionListener(() -> this.cycleTexture(1)));
        this.add(new ListenerButtonElement(11, 4, this.bottom - 4 - 20, 20, 20, "V").setActionListener(() -> {
            this.drawCheckers = !this.drawCheckers;
        }));
        this.add(new ListenerButtonElement(11, 28, this.bottom - 4 - 20, 20, 20, "F").setActionListener(() -> {
            this.flip = !this.flip;
        }));
        this.add(new ListenerButtonElement(12, 52, this.bottom - 4 - 20, 20, 20, "D").setActionListener(() -> {
            Textures.dumpTextures();
            Utils.openDirectory(new File("dumpTextures"));
        }));
        this.add(new ListenerButtonElement(13, 76, this.bottom - 4 - 20, 20, 20, "T").setActionListener(() -> {
            this.drawText = !this.drawText;
        }));
    }

    @Override
    protected void buttonClicked(ButtonElement button) {
    }

    @Override
    protected void buttonReleased(ButtonElement button) {
    }

    protected void cycleTexture(int offset) {
        List<Integer> textureList = GLAllocation.textureNames;
        this.texIndex += offset;
        if (this.texIndex < 0) {
            this.texIndex += textureList.size();
        }
        this.texIndex %= textureList.size();
    }

    @Override
    public void render(int xm, int ym, float partialTick) {
        this.renderBackground();
        this.font.drawCenteredString(I18n.getInstance().translateKey("gui.texture_viewer.label.title"), this.width / 2, 5, 0xFFFFFF);
        List<Integer> textureList = GLAllocation.textureNames;
        int id = this.texIndex % textureList.size();
        GL11.glBindTexture(3553, textureList.get(id));
        Texture t = this.mc.textureManager.idToTextureMap.get(textureList.get(id));
        GL11.glEnable(3042);
        GL11.glEnable(2929);
        int texWidth = GL11.glGetTexLevelParameteri(3553, 0, 4096);
        int texHeight = GL11.glGetTexLevelParameteri(3553, 0, 4097);
        double ratio = (double)texWidth / (double)texHeight;
        double imgHeight = (double)(this.bottom - this.top) - 40.0;
        double imgWidth = imgHeight * ratio;
        if (imgWidth > (double)this.width * 0.75) {
            imgWidth = (float)this.width * 0.75f;
            imgHeight = imgWidth / ratio;
        }
        double x = ((double)this.width - imgWidth) / 2.0;
        double y = ((double)this.height - imgHeight) / 2.0;
        Tessellator tessellator = Tessellator.instance;
        if (this.drawCheckers) {
            this.mc.textureManager.bindTexture(this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/designer_bg.png"));
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(x + 0.0, y + imgHeight, this.zLevel, 0.0, imgHeight / 2.0);
            tessellator.addVertexWithUV(x + imgWidth, y + imgHeight, this.zLevel, imgWidth / 2.0, imgHeight / 2.0);
            tessellator.addVertexWithUV(x + imgWidth, y + 0.0, this.zLevel, imgWidth / 2.0, 0.0);
            tessellator.addVertexWithUV(x + 0.0, y + 0.0, this.zLevel, 0.0, 0.0);
            tessellator.draw();
        }
        GL11.glBindTexture(3553, textureList.get(id));
        tessellator.startDrawingQuads();
        if (this.flip) {
            tessellator.addVertexWithUV(x + 0.0, y + imgHeight, this.zLevel, 0.0, 0.0);
            tessellator.addVertexWithUV(x + imgWidth, y + imgHeight, this.zLevel, 1.0, 0.0);
            tessellator.addVertexWithUV(x + imgWidth, y + 0.0, this.zLevel, 1.0, 1.0);
            tessellator.addVertexWithUV(x + 0.0, y + 0.0, this.zLevel, 0.0, 1.0);
        } else {
            tessellator.addVertexWithUV(x + 0.0, y + imgHeight, this.zLevel, 0.0, 1.0);
            tessellator.addVertexWithUV(x + imgWidth, y + imgHeight, this.zLevel, 1.0, 1.0);
            tessellator.addVertexWithUV(x + imgWidth, y + 0.0, this.zLevel, 1.0, 0.0);
            tessellator.addVertexWithUV(x + 0.0, y + 0.0, this.zLevel, 0.0, 0.0);
        }
        tessellator.draw();
        super.render(xm, ym, partialTick);
        GL11.glDisable(2929);
        if (this.drawText) {
            this.font.drawString("Tex ID: " + id, 1, this.top + 1, 0xFFFFFF, true);
            this.font.drawString("Tex Width: " + texWidth, 1, this.top + 11, 0xFFFFFF, true);
            this.font.drawString("Tex Height: " + texHeight, 1, this.top + 21, 0xFFFFFF, true);
            String s = t == null ? "None" : t.toString();
            String[] lines = s.split("\n");
            int yOff = this.top + 31;
            for (String line : lines) {
                this.font.drawString(line, 1, yOff, 0xFFFFFF, true);
                yOff += 10;
            }
        }
    }

    @Override
    public void renderBackground() {
        super.renderBackground();
        if (this.mc.theWorld == null) {
            Tessellator tessellator = Tessellator.instance;
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            float scale = 32.0f;
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0x202020);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, (float)this.bottom / scale);
            tessellator.addVertexWithUV(this.width, this.bottom, 0.0, (float)this.width / scale, (float)this.bottom / scale);
            tessellator.addVertexWithUV(this.width, this.top, 0.0, (float)this.width / scale, (float)this.top / scale);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, (float)this.top / scale);
            tessellator.draw();
        } else {
            this.drawRect(0, 0, this.width, this.top, 0x5F000000);
            this.drawRect(0, this.bottom, this.width, this.height, 0x5F000000);
        }
    }
}

